/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.lppgrowth;

import ca.pfv.spmf.algorithms.frequentpatterns.lppgrowth.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.lppgrowth.Itemsets;
import ca.pfv.spmf.algorithms.frequentpatterns.lppgrowth.LPPNode;
import ca.pfv.spmf.algorithms.frequentpatterns.lppgrowth.LPPTree;
import ca.pfv.spmf.algorithms.frequentpatterns.lppgrowth.TimeIntervals;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoLPPGrowth {
    private long startTimestamp;
    private long endTime;
    private int lastTimestamp = -1;
    private int itemsetCount;
    BufferedWriter writer = null;
    protected Itemsets patterns = null;
    final int BUFFERS_SIZE = 2000;
    private int[] itemsetBuffer = null;
    private int[] itemsetOutputBuffer = null;
    private int maxPatternLength = 1000;
    private boolean selfIncrement;
    private int minDur;
    private int maxPer;
    private int maxSoPer;

    public Itemsets runAlgorithm(String input, String output, int maxPer, int minDur, int maxSoPer, boolean selfIncrement) throws IOException {
        this.startTimestamp = System.currentTimeMillis();
        this.itemsetCount = 0;
        MemoryLogger.getInstance().reset();
        MemoryLogger.getInstance().checkMemory();
        this.minDur = minDur;
        this.maxPer = maxPer;
        this.selfIncrement = selfIncrement;
        this.maxSoPer = maxSoPer;
        if (output == null) {
            this.writer = null;
            this.patterns = new Itemsets("Local Periodic Pattern");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(output));
            this.itemsetOutputBuffer = new int[2000];
        }
        Map<Integer, TimeIntervals> mapTimeIntervals = this.scanDatabaseToDetermineTimeIntervalsOfSingleItems(input);
        LPPTree tree = new LPPTree();
        this.buildTreeByScanDataAgain(tree, input, mapTimeIntervals);
        if (tree.headerList.size() > 0) {
            this.itemsetBuffer = new int[2000];
            this.pftiGrowth(tree, this.itemsetBuffer, 0, mapTimeIntervals);
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTime = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        return this.patterns;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void pftiGrowth(LPPTree tree, int[] prefix, int prefixLength, Map<Integer, TimeIntervals> mapTimeIntervals) throws IOException {
        if (prefixLength != this.maxPatternLength) ** GOTO lbl42
        return;
lbl-1000:
        // 1 sources

        {
            item = tree.headerList.get(tree.headerList.size() - 1);
            prefix[prefixLength] = item;
            this.saveItemset(prefix, prefixLength + 1, mapTimeIntervals.get((Object)item).intervals);
            if (prefixLength + 1 >= this.maxPatternLength) continue;
            prefixPaths = new ArrayList<ArrayList<E>>();
            path = tree.mapItemNodes.get(item);
            mapTimestampsBeta = new HashMap<Integer, List<Integer>>();
            while (path != null) {
                if (path.parent.itemID != -1) {
                    prefixPath = new ArrayList<LPPNode>();
                    prefixPath.add(path);
                    pathTimestamps = path.timestamps;
                    parent = path.parent;
                    while (parent.itemID != -1) {
                        prefixPath.add(parent);
                        if (mapTimestampsBeta.get(parent.itemID) == null) {
                            mapTimestampsBeta.put(parent.itemID, (List<Integer>)new ArrayList<Integer>(pathTimestamps){
                                {
                                    this.addAll(list);
                                }
                            });
                        } else {
                            ((List)mapTimestampsBeta.get(parent.itemID)).addAll(pathTimestamps);
                        }
                        parent = parent.parent;
                    }
                    prefixPaths.add(prefixPath);
                }
                path = path.nodeLink;
            }
            tree.removeTailItem();
            mapBetaTimeIntervals = this.getMapBetaTimeIntervals(mapTimestampsBeta);
            if (mapBetaTimeIntervals.size() <= 0) continue;
            treeBeta = new LPPTree();
            for (List prefixPath : prefixPaths) {
                treeBeta.addPrefixPath(prefixPath, mapBetaTimeIntervals);
            }
            if (treeBeta.root.childs.size() <= 0) continue;
            treeBeta.createHeaderList(tree.headerList, mapBetaTimeIntervals);
            this.pftiGrowth(treeBeta, prefix, prefixLength + 1, mapBetaTimeIntervals);
lbl42:
            // 5 sources

            ** while (tree.headerList.size() > 0)
        }
lbl43:
        // 1 sources

        MemoryLogger.getInstance().checkMemory();
    }

    private Map<Integer, TimeIntervals> getMapBetaTimeIntervals(Map<Integer, List<Integer>> mapTimestampsBeta) {
        HashMap<Integer, TimeIntervals> mapBetaTimeIntervals = new HashMap<Integer, TimeIntervals>();
        HashMap<Integer, Integer> soPer = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, List<Integer>> entry : mapTimestampsBeta.entrySet()) {
            TimeIntervals timeIntervals = new TimeIntervals();
            List<Integer> timestamps = entry.getValue();
            Collections.sort(timestamps);
            int preTS = -1;
            for (int timestamp : timestamps) {
                if (preTS != -1) {
                    int per = timestamp - preTS;
                    if (per <= this.maxPer && timeIntervals.left == -1) {
                        timeIntervals.left = preTS;
                        soPer.put(entry.getKey(), this.maxSoPer);
                    }
                    if (timeIntervals.left != -1) {
                        soPer.put(entry.getKey(), Math.max(0, (Integer)soPer.get(entry.getKey()) + (per - this.maxPer)));
                        if ((Integer)soPer.get(entry.getKey()) > this.maxSoPer) {
                            if (preTS - timeIntervals.left >= this.minDur) {
                                timeIntervals.addTimeInterval(preTS);
                            }
                            timeIntervals.left = -1;
                        }
                    }
                }
                preTS = timestamp;
            }
            if (timeIntervals.left != -1) {
                soPer.put(entry.getKey(), Math.max(0, (Integer)soPer.get(entry.getKey()) + (this.lastTimestamp - preTS - this.maxPer)));
                if ((Integer)soPer.get(entry.getKey()) <= this.maxSoPer && this.lastTimestamp - timeIntervals.left >= this.minDur) {
                    timeIntervals.addTimeInterval(this.lastTimestamp);
                }
                if ((Integer)soPer.get(entry.getKey()) > this.maxSoPer && preTS - timeIntervals.left >= this.minDur) {
                    timeIntervals.addTimeInterval(preTS);
                }
            }
            if (timeIntervals.intervals.size() <= 0) continue;
            mapBetaTimeIntervals.put(entry.getKey(), timeIntervals);
        }
        mapTimestampsBeta.clear();
        return mapBetaTimeIntervals;
    }

    private void saveItemset(int[] itemset2, int itemsetLength, List<int[]> timeIntervals) throws IOException {
        ++this.itemsetCount;
        if (this.writer != null) {
            System.arraycopy(itemset2, 0, this.itemsetOutputBuffer, 0, itemsetLength);
            Arrays.sort(this.itemsetOutputBuffer, 0, itemsetLength);
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < itemsetLength) {
                buffer.append(this.itemsetOutputBuffer[i]);
                if (i != itemsetLength - 1) {
                    buffer.append(' ');
                }
                ++i;
            }
            buffer.append(" #TIME-INTERVALS: ");
            for (int[] timeInterval : timeIntervals) {
                buffer.append("[ ");
                buffer.append(timeInterval[0]);
                buffer.append(" , ");
                buffer.append(timeInterval[1]);
                buffer.append(" ]   ");
            }
            this.writer.write(buffer.toString());
            this.writer.newLine();
        } else {
            int[] itemsetArray = new int[itemsetLength];
            System.arraycopy(itemset2, 0, itemsetArray, 0, itemsetLength);
            Arrays.sort(itemsetArray);
            Itemset itemsetObj = new Itemset(itemsetArray, timeIntervals);
            this.patterns.addItemset(itemsetObj, itemsetLength);
        }
    }

    private void buildTreeByScanDataAgain(LPPTree tree, String input, final Map<Integer, TimeIntervals> mapTimeIntervals) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(input));
        if (this.selfIncrement) {
            String line;
            int ts = 1;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] lineSplited = line.trim().split(" ");
                ArrayList<Integer> transaction = new ArrayList<Integer>();
                String[] stringArray = lineSplited;
                int n = lineSplited.length;
                int n2 = 0;
                while (n2 < n) {
                    String itemString = stringArray[n2];
                    Integer itemName = Integer.parseInt(itemString);
                    if (mapTimeIntervals.containsKey(itemName) && mapTimeIntervals.get(itemName).isInside(ts) && !transaction.contains(itemName)) {
                        transaction.add(itemName);
                    }
                    ++n2;
                }
                Collections.sort(transaction, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer item1, Integer item2) {
                        int compare = ((TimeIntervals)mapTimeIntervals.get(item2)).getTotalDuration() - ((TimeIntervals)mapTimeIntervals.get(item1)).getTotalDuration();
                        if (compare == 0) {
                            return item1 - item2;
                        }
                        return compare;
                    }
                });
                tree.addTransaction(transaction, ts);
                ++ts;
            }
        } else {
            String line;
            int ts = -1;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] lineSplited = line.trim().split("\\|");
                String[] lineItems = lineSplited[0].trim().split(" ");
                ts = Integer.parseInt(lineSplited[1]);
                ArrayList<Integer> transaction = new ArrayList<Integer>();
                String[] stringArray = lineItems;
                int n = lineItems.length;
                int n3 = 0;
                while (n3 < n) {
                    String itemString = stringArray[n3];
                    Integer itemName = Integer.parseInt(itemString);
                    if (mapTimeIntervals.containsKey(itemName) && mapTimeIntervals.get(itemName).isInside(ts) && !transaction.contains(itemName)) {
                        transaction.add(itemName);
                    }
                    ++n3;
                }
                Collections.sort(transaction, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer item1, Integer item2) {
                        int compare = ((TimeIntervals)mapTimeIntervals.get(item2)).getTotalDuration() - ((TimeIntervals)mapTimeIntervals.get(item1)).getTotalDuration();
                        if (compare == 0) {
                            return item1 - item2;
                        }
                        return compare;
                    }
                });
                if (transaction.size() <= 0) continue;
                tree.addTransaction(transaction, ts);
            }
        }
        reader.close();
        tree.createHeaderList(null, mapTimeIntervals);
    }

    private Map<Integer, TimeIntervals> scanDatabaseToDetermineTimeIntervalsOfSingleItems(String input) throws IOException {
        HashMap<Integer, Integer> soPer;
        HashMap<Integer, Integer> preTimestamp;
        HashMap<Integer, TimeIntervals> mapTimeIntervals;
        BufferedReader reader;
        block22: {
            int n;
            String[] lineSplited;
            String line;
            int ts;
            block18: {
                reader = new BufferedReader(new FileReader(input));
                mapTimeIntervals = new HashMap<Integer, TimeIntervals>();
                preTimestamp = new HashMap<Integer, Integer>();
                soPer = new HashMap<Integer, Integer>();
                if (!this.selfIncrement) break block18;
                ts = 1;
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                    String[] stringArray = lineSplited = line.split(" ");
                    n = lineSplited.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block20: {
                            Integer itemName;
                            block21: {
                                block19: {
                                    String itemString = stringArray[n2];
                                    itemName = Integer.parseInt(itemString);
                                    if (!mapTimeIntervals.containsKey(itemName)) break block19;
                                    int pre_ts = (Integer)preTimestamp.get(itemName);
                                    int per = ts - pre_ts;
                                    if (per == 0) break block20;
                                    TimeIntervals timeIntervals = (TimeIntervals)mapTimeIntervals.get(itemName);
                                    if (per <= this.maxPer && timeIntervals.left == -1) {
                                        timeIntervals.left = pre_ts;
                                        soPer.put(itemName, this.maxSoPer);
                                    }
                                    if (timeIntervals.left != -1) {
                                        soPer.put(itemName, Math.max(0, (Integer)soPer.get(itemName) + (per - this.maxPer)));
                                        if ((Integer)soPer.get(itemName) > this.maxSoPer) {
                                            if (pre_ts - timeIntervals.left >= this.minDur) {
                                                timeIntervals.addTimeInterval(pre_ts);
                                            }
                                            timeIntervals.left = -1;
                                        }
                                    }
                                    break block21;
                                }
                                mapTimeIntervals.put(itemName, new TimeIntervals());
                            }
                            preTimestamp.put(itemName, ts);
                        }
                        ++n2;
                    }
                    ++ts;
                }
                this.lastTimestamp = ts - 1;
                break block22;
            }
            ts = -1;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                lineSplited = line.split("\\|");
                String[] lineItems = lineSplited[0].split(" ");
                ts = Integer.parseInt(lineSplited[1]);
                String[] stringArray = lineItems;
                int n3 = lineItems.length;
                n = 0;
                while (n < n3) {
                    String itemString = stringArray[n];
                    Integer itemName = Integer.parseInt(itemString);
                    if (preTimestamp.containsKey(itemName)) {
                        int preTS = (Integer)preTimestamp.get(itemName);
                        int per = ts - preTS;
                        TimeIntervals timeIntervals = (TimeIntervals)mapTimeIntervals.get(itemName);
                        if (per <= this.maxPer && timeIntervals.left == -1) {
                            timeIntervals.left = preTS;
                            soPer.put(itemName, this.maxSoPer);
                        }
                        if (timeIntervals.left != -1) {
                            soPer.put(itemName, Math.max(0, (Integer)soPer.get(itemName) + (per - this.maxPer)));
                            if ((Integer)soPer.get(itemName) > this.maxSoPer) {
                                if (preTS - timeIntervals.left >= this.minDur) {
                                    timeIntervals.addTimeInterval(preTS);
                                }
                                timeIntervals.left = -1;
                            }
                        }
                    } else {
                        mapTimeIntervals.put(itemName, new TimeIntervals());
                    }
                    preTimestamp.put(itemName, ts);
                    ++n;
                }
            }
            this.lastTimestamp = ts;
        }
        reader.close();
        Iterator it = mapTimeIntervals.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (((TimeIntervals)entry.getValue()).left != -1) {
                soPer.put((Integer)entry.getKey(), Math.max(0, (Integer)soPer.get(entry.getKey()) + (this.lastTimestamp - (Integer)preTimestamp.get(entry.getKey()) - this.maxPer)));
                if ((Integer)soPer.get(entry.getKey()) <= this.maxSoPer && this.lastTimestamp - ((TimeIntervals)entry.getValue()).left >= this.minDur) {
                    ((TimeIntervals)entry.getValue()).addTimeInterval(this.lastTimestamp);
                }
                if ((Integer)soPer.get(entry.getKey()) > this.maxSoPer && (Integer)preTimestamp.get(entry.getKey()) - ((TimeIntervals)entry.getValue()).left >= this.minDur) {
                    ((TimeIntervals)entry.getValue()).addTimeInterval((Integer)preTimestamp.get(entry.getKey()));
                }
                ((TimeIntervals)entry.getValue()).left = -1;
            }
            if (((TimeIntervals)entry.getValue()).intervals.size() > 0) continue;
            it.remove();
        }
        return mapTimeIntervals;
    }

    public void printStats() {
        System.out.println("=============  LPP-Growth  - STATS ===============");
        long temps = this.endTime - this.startTimestamp;
        System.out.print(" Max memory usage: " + MemoryLogger.getInstance().getMaxMemory() + " mb \n");
        System.out.println(" Itemset counts : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }

    public void setMaximumPatternLength(int length) {
        this.maxPatternLength = length;
    }

    public void cancelSelfIncrement() {
        this.selfIncrement = false;
    }
}

