/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.lhui;

import ca.pfv.spmf.algorithms.frequentpatterns.lhui.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.lhui.Period;
import ca.pfv.spmf.algorithms.frequentpatterns.lhui.UtilityListLHUI;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoLHUIMiner {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    public int candidateCount = 0;
    Map<Integer, Long> mapItemToTWU;
    BufferedWriter writer = null;
    private int joinCount;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    ArrayList<Long> timeTid = new ArrayList();

    public void runAlgorithm(String input, String output, long minUtility, long window) throws IOException {
        ArrayList<UtilityListLHUI> listOfUtilityListPeaks;
        block25: {
            String thisLine;
            BufferedReader myInput;
            block23: {
                MemoryLogger.getInstance().reset();
                this.itemsetBuffer = new int[200];
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToTWU = new HashMap<Integer, Long>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            long transactionUtility = Integer.parseInt(split[1]);
                            this.timeTid.add(Long.parseLong(split[3]));
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Long twu = this.mapItemToTWU.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                this.mapItemToTWU.put(item, twu);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            listOfUtilityListPeaks = new ArrayList<UtilityListLHUI>();
            HashMap<Integer, UtilityListLHUI> mapItemToUtilityListPeak = new HashMap<Integer, UtilityListLHUI>();
            for (Integer item : this.mapItemToTWU.keySet()) {
                if (this.mapItemToTWU.get(item) < minUtility) continue;
                UtilityListLHUI uList = new UtilityListLHUI(item);
                mapItemToUtilityListPeak.put(item, uList);
                listOfUtilityListPeaks.add(uList);
            }
            Collections.sort(listOfUtilityListPeaks, new Comparator<UtilityListLHUI>(){

                @Override
                public int compare(UtilityListLHUI o1, UtilityListLHUI o2) {
                    return AlgoLHUIMiner.this.compareItems(o1.item, o2.item);
                }
            });
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    int tid = 0;
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        long remainingUtility = 0L;
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        int i = 0;
                        while (i < items.length) {
                            Pair pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            if (this.mapItemToTWU.get(pair.item) >= minUtility) {
                                revisedTransaction.add(pair);
                                remainingUtility += pair.utility;
                            }
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Pair>(){

                            @Override
                            public int compare(Pair o1, Pair o2) {
                                return AlgoLHUIMiner.this.compareItems(o1.item, o2.item);
                            }
                        });
                        for (Pair pair : revisedTransaction) {
                            UtilityListLHUI UtilityListPeakOfItem = (UtilityListLHUI)mapItemToUtilityListPeak.get(pair.item);
                            Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                            UtilityListPeakOfItem.addElement(element);
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        for (UtilityListLHUI ulp : listOfUtilityListPeaks) {
            this.generatePeriod(ulp, minUtility, window);
        }
        MemoryLogger.getInstance().checkMemory();
        this.lhuiMiner(this.itemsetBuffer, 0, null, listOfUtilityListPeaks, minUtility, window);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        long compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0L ? item1 - item2 : (int)compare;
    }

    private void lhuiMiner(int[] prefix, int prefixLength, UtilityListLHUI pUL, List<UtilityListLHUI> ULs, long minUtility, long window) throws IOException {
        int i = 0;
        while (i < ULs.size()) {
            UtilityListLHUI X = ULs.get(i);
            if (!X.iutilPeriod.isEmpty()) {
                this.writeOut(prefix, prefixLength, X);
            }
            if (!X.utilPeriod.isEmpty()) {
                ArrayList<UtilityListLHUI> exULs = new ArrayList<UtilityListLHUI>();
                ++this.candidateCount;
                int j = i + 1;
                while (j < ULs.size()) {
                    UtilityListLHUI Y = ULs.get(j);
                    UtilityListLHUI pXY = this.construct(pUL, X, Y);
                    this.generatePeriod(pXY, minUtility, window);
                    exULs.add(pXY);
                    ++this.joinCount;
                    ++j;
                }
                this.itemsetBuffer[prefixLength] = X.item;
                this.lhuiMiner(this.itemsetBuffer, prefixLength + 1, X, exULs, minUtility, window);
            }
            ++i;
        }
    }

    private UtilityListLHUI construct(UtilityListLHUI P, UtilityListLHUI px, UtilityListLHUI py) {
        UtilityListLHUI pxyUL = new UtilityListLHUI(py.item);
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) continue;
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityListLHUI ulist, int tid) {
        ArrayList list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (((Element)list.get((int)middle)).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (((Element)list.get((int)middle)).tid > tid) {
                last = middle - 1;
                continue;
            }
            return (Element)list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, UtilityListLHUI ulp) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(prefix[i]);
            buffer.append(' ');
            ++i;
        }
        buffer.append(ulp.item);
        buffer.append(" #UTIL: ");
        buffer.append(String.valueOf(ulp.sumIutils) + " ");
        i = 0;
        while (i < ulp.iutilPeriod.size()) {
            Period p = ulp.iutilPeriod.get(i);
            buffer.append("[" + this.timeTid.get(((Element)ulp.elements.get((int)p.beginIndex)).tid) + "," + this.timeTid.get(((Element)ulp.elements.get((int)p.endIndex)).tid) + "] ");
            ++i;
        }
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void generatePeriod(UtilityListLHUI ulp, long minutil, long window) {
        long iutil = 0L;
        long rutil = 0L;
        int winEnd = 0;
        boolean iutilPreflag = false;
        boolean utilPreflag = false;
        while (winEnd < ulp.elements.size() && this.timeTid.get(((Element)ulp.elements.get((int)winEnd)).tid) < this.timeTid.get(((Element)ulp.elements.get((int)0)).tid) + window) {
            iutil += ((Element)ulp.elements.get((int)winEnd)).iutils;
            rutil += ((Element)ulp.elements.get((int)winEnd)).rutils;
            ++winEnd;
        }
        if (iutil >= minutil) {
            iutilPreflag = true;
        }
        if (iutil + rutil >= minutil) {
            utilPreflag = true;
        }
        this.slideWindow(ulp, winEnd, minutil, iutil, iutilPreflag, rutil, utilPreflag, window);
    }

    private void slideWindow(UtilityListLHUI ulp, int winEnd, long minutil, long iutil, boolean iutilPreflag, long rutil, boolean utilPreflag, long window) {
        int beginIndex = 0;
        int endIndex = winEnd;
        int uBeginIndex = 0;
        int uEndIndex = winEnd;
        int i = 0;
        while (i < ulp.elements.size()) {
            int y = i;
            while (y < ulp.elements.size() && this.timeTid.get(((Element)ulp.elements.get((int)y)).tid) == this.timeTid.get(((Element)ulp.elements.get((int)i)).tid)) {
                iutil -= ((Element)ulp.elements.get((int)y)).iutils;
                rutil -= ((Element)ulp.elements.get((int)y)).rutils;
                ++y;
            }
            i = y;
            int x = winEnd;
            while (x < ulp.elements.size() && this.timeTid.get(((Element)ulp.elements.get((int)x)).tid) < this.timeTid.get(((Element)ulp.elements.get((int)y)).tid) + window) {
                iutil += ((Element)ulp.elements.get((int)x)).iutils;
                rutil += ((Element)ulp.elements.get((int)x)).rutils;
                winEnd = x + 1;
                ++x;
            }
            if (iutilPreflag) {
                if (iutil < minutil) {
                    ulp.iutilPeriod.add(new Period(beginIndex, endIndex - 1));
                    iutilPreflag = false;
                } else {
                    endIndex = winEnd;
                }
            } else if (iutil >= minutil) {
                iutilPreflag = true;
                beginIndex = i;
                endIndex = winEnd;
            }
            if (utilPreflag) {
                if (iutil + rutil < minutil) {
                    ulp.utilPeriod.add(new Period(uBeginIndex, uEndIndex - 1));
                    utilPreflag = false;
                    continue;
                }
                uEndIndex = winEnd;
                continue;
            }
            if (iutil + rutil < minutil) continue;
            utilPreflag = true;
            uBeginIndex = i;
            uEndIndex = winEnd;
        }
    }

    public void printStats() {
        System.out.println("=============  LHUI-MINER ALGORITHM - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" Local High-utility itemsets count : " + this.huiCount);
        System.out.println(" Join count : " + this.joinCount);
        System.out.println(" Candidate count : " + this.candidateCount);
        System.out.println("===================================================");
    }

    class Pair {
        int item = 0;
        long utility = 0L;

        Pair() {
        }
    }
}

