/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.lcm;

import ca.pfv.spmf.algorithms.frequentpatterns.lcm.Dataset;
import ca.pfv.spmf.algorithms.frequentpatterns.lcm.Transaction;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AlgoLCMMax {
    private Itemsets itemsets;
    BufferedWriter writer = null;
    private int frequentCount;
    long startTimestamp;
    long endTimestamp;
    int minsupRelative;
    private List<Transaction>[] buckets;

    public Itemsets runAlgorithm(double minimumSupport, Dataset dataset, String outputPath) throws IOException {
        this.startTimestamp = System.currentTimeMillis();
        if (outputPath != null) {
            this.writer = new BufferedWriter(new FileWriter(outputPath));
        } else {
            this.writer = null;
            this.itemsets = new Itemsets("Itemsets");
        }
        this.frequentCount = 0;
        MemoryLogger.getInstance().reset();
        this.minsupRelative = (int)Math.ceil(minimumSupport * (double)dataset.getTransactions().size());
        this.performFirstOccurenceDelivery(dataset);
        for (Transaction transaction : dataset.getTransactions()) {
            transaction.removeInfrequentItems(this.buckets, this.minsupRelative);
        }
        ArrayList<Integer> allItems = new ArrayList<Integer>();
        for (Integer item : dataset.getUniqueItems()) {
            if (this.buckets[item].size() < this.minsupRelative) continue;
            allItems.add(item);
        }
        Collections.sort(allItems);
        this.backtrackingLCMMax(null, dataset.getTransactions(), allItems, -1, -1);
        this.endTimestamp = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        MemoryLogger.getInstance().checkMemory();
        return this.itemsets;
    }

    private boolean backtrackingLCMMax(List<Integer> p, List<Transaction> transactionsOfP, List<Integer> frequentItems, int tailPosInP, Integer itemELastAddedToP) throws IOException {
        throw new RuntimeException("This algorithm is unavailable in the current version of SPMF. \n");
    }

    public void performFirstOccurenceDelivery(Dataset dataset) {
        this.buckets = new List[dataset.getMaxItem() + 1];
        for (Integer item : dataset.uniqueItems) {
            this.buckets[item.intValue()] = new ArrayList<Transaction>();
        }
        for (Transaction transaction : dataset.getTransactions()) {
            Integer[] integerArray = transaction.getItems();
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer item = integerArray[n2];
                this.buckets[item].add(transaction);
                ++n2;
            }
        }
    }

    private void anyTimeDatabaseReductionMax(List<Transaction> transactionsPe, int j, List<Integer> frequentItems, List<Integer> itemset2, Integer e) {
        int i = 0;
        while (i < frequentItems.size()) {
            Integer item = frequentItems.get(i);
            this.buckets[item.intValue()] = new ArrayList<Transaction>();
            ++i;
        }
        for (Transaction transaction : transactionsPe) {
            int i2 = transaction.getItems().length - 1;
            while (i2 >= 0) {
                Integer item = transaction.getItems()[i2];
                if (frequentItems.contains(item)) {
                    this.buckets[item].add(transaction);
                }
                --i2;
            }
        }
    }

    public boolean containsByBinarySearch(List<Integer> items, Integer item, int searchAfterPosition) {
        if (items.size() == 0 || item > items.get(items.size() - 1)) {
            return false;
        }
        int low = searchAfterPosition + 1;
        int high = items.size() - 1;
        while (high >= low) {
            int middle = low + high >>> 1;
            if (items.get(middle).equals(item)) {
                return true;
            }
            if (items.get(middle) < item) {
                low = middle + 1;
            }
            if (items.get(middle) <= item) continue;
            high = middle - 1;
        }
        return false;
    }

    public boolean containsByBinarySearch(List<Integer> items, Integer item) {
        if (items.size() == 0 || item > items.get(items.size() - 1)) {
            return false;
        }
        int low = 0;
        int high = items.size() - 1;
        while (high >= low) {
            int middle = low + high >>> 1;
            if (items.get(middle).equals(item)) {
                return true;
            }
            if (items.get(middle) < item) {
                low = middle + 1;
            }
            if (items.get(middle) <= item) continue;
            high = middle - 1;
        }
        return false;
    }

    public List<Transaction> intersectTransactions(List<Transaction> transactionsOfP, Integer e) {
        ArrayList<Transaction> transactionsPe = new ArrayList<Transaction>();
        for (Transaction transaction : transactionsOfP) {
            int posE = transaction.containsByBinarySearch(e);
            if (posE == -1) continue;
            transactionsPe.add(new Transaction(transaction, posE));
        }
        return transactionsPe;
    }

    private boolean isPPCMaxExtension(List<Integer> p, Integer e, List<Transaction> transactionsPe) {
        Transaction firstTrans = transactionsPe.get(0);
        Integer[] firstTransaction = firstTrans.getItems();
        int i = 0;
        while (i < firstTransaction.length) {
            Integer item = firstTransaction[i];
            if (item >= e) break;
            if ((p == null || !this.containsByBinarySearch(p, item)) && this.isItemInAtLeastMinsupTransactionsWithoutFirst(transactionsPe, item)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isItemInAtLeastMinsupTransactionsWithoutFirst(List<Transaction> transactions, Integer item) {
        int supCount = 1;
        int i = 1;
        while (i < transactions.size()) {
            if (transactions.get(i).containsByBinarySearchOriginalTransaction(item) && ++supCount == this.minsupRelative) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isItemInAtLeastMinsupTransactions(List<Transaction> transactions, Integer item) {
        int supCount = 0;
        for (Transaction transaction : transactions) {
            if (transaction.containsByBinarySearch(item) == -1 || ++supCount != this.minsupRelative) continue;
            return true;
        }
        return false;
    }

    private boolean isItemInAllTransactions(List<Transaction> transactions, Integer item) {
        for (Transaction transaction : transactions) {
            if (transaction.containsByBinarySearch(item) != -1) continue;
            return false;
        }
        return true;
    }

    private void output(List<Integer> itemset2, int support) throws IOException {
        if (!itemset2.isEmpty()) {
            ++this.frequentCount;
            if (this.writer == null) {
                this.itemsets.addItemset(new Itemset(itemset2, support), itemset2.size());
            } else {
                StringBuilder buffer = new StringBuilder();
                int i = 0;
                while (i < itemset2.size()) {
                    buffer.append(itemset2.get(i));
                    if (i != itemset2.size() - 1) {
                        buffer.append(' ');
                    }
                    ++i;
                }
                buffer.append(" #SUP: ");
                buffer.append(support);
                this.writer.write(buffer.toString());
                this.writer.newLine();
            }
        }
    }

    public void printStats() {
        System.out.println("========== LCMMax - STATS ============");
        System.out.println(" Freq. maximal itemsets count: " + this.frequentCount);
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("=====================================");
    }
}

