/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.ihaupm;

import ca.pfv.spmf.algorithms.frequentpatterns.ihaupm.IAUNode;
import ca.pfv.spmf.algorithms.frequentpatterns.ihaupm.IAUTree;
import ca.pfv.spmf.algorithms.frequentpatterns.ihaupm.StackElement;
import ca.pfv.spmf.algorithms.frequentpatterns.ihaupm.TableNode;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IHAUPM {
    IAUTree tree = null;
    Map<String, Integer> item2profits;
    Map<String, Map<String, Long>> EUCS = null;
    public int numOfNodes = 0;

    public IHAUPM(IAUTree DBTree) {
        this.tree = DBTree;
        this.item2profits = DBTree.item2profits;
        this.EUCS = IAUTree.EUCS;
    }

    public int[] mine(String outfile) throws IOException {
        BufferedWriter out = null;
        if (outfile != null) {
            out = new BufferedWriter(new FileWriter(outfile));
        }
        int candidateNum = 0;
        int minedItemsetNum = 0;
        HashMap<String, Double> result = new HashMap<String, Double>();
        Iterator it = null;
        List<TableNode> headTableList = IAUTree.headTable;
        int i = headTableList.size() - 1;
        while (i >= 0) {
            TableNode p = headTableList.get(i);
            IAUNode s = p.hlink;
            result.clear();
            List<List<IAUNode.IAUPair>> arys = this.collectIntoList(s);
            this.combine(arys);
            for (List<IAUNode.IAUPair> quanAry : arys) {
                List<IAUNode.IAUPair> sublist = quanAry.subList(0, quanAry.size() - 1);
                this.getCombination(sublist, result, quanAry.get(quanAry.size() - 1));
            }
            while (s != null) {
                List<IAUNode.IAUPair> quanAry;
                quanAry = s.getQuanAry();
                List<IAUNode.IAUPair> sublist = quanAry.subList(0, quanAry.size() - 1);
                this.getCombination(sublist, result, quanAry.get(quanAry.size() - 1));
                s = s.getRight();
            }
            it = result.entrySet().iterator();
            candidateNum += result.size();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String line = (String)entry.getKey();
                double averageUtility = (Double)entry.getValue() / (double)line.split(",").length;
                line = String.valueOf(line) + " #AUTIL: " + averageUtility;
                if (!(averageUtility >= IAUTree.minautil)) continue;
                if (out != null) {
                    out.write(String.valueOf(line) + "\n");
                }
                ++minedItemsetNum;
            }
            --i;
        }
        if (out != null) {
            out.close();
        }
        return new int[]{candidateNum, minedItemsetNum};
    }

    private void getCombination(List<IAUNode.IAUPair> quanAry, Map<String, Double> result, IAUNode.IAUPair curNode) {
        ArrayList<StackElement> stack = new ArrayList<StackElement>();
        StackElement element = new StackElement();
        element.name = curNode.name;
        element.utility = curNode.quan * this.item2profits.get(curNode.name);
        element.location = quanAry.size();
        stack.add(element);
        while (stack.size() != 0) {
            StackElement ele = (StackElement)stack.remove(stack.size() - 1);
            if (!result.containsKey(ele.name)) {
                result.put(ele.name, ele.utility);
            } else {
                double u = result.get(ele.name);
                result.put(ele.name, u += ele.utility);
            }
            String[] names = ele.name.split(",");
            int k = ele.location - 1;
            while (k >= 0) {
                block6: {
                    IAUNode.IAUPair pair = quanAry.get(k);
                    int i = 0;
                    while (i < names.length) {
                        String name1 = pair.name;
                        String name2 = names[i];
                        if (this.isCombine(name1, name2)) {
                            ++i;
                            continue;
                        }
                        break block6;
                    }
                    StackElement tmp = new StackElement();
                    tmp.name = String.valueOf(ele.name) + "," + pair.name;
                    tmp.utility = ele.utility + (double)(pair.quan * this.item2profits.get(pair.name));
                    tmp.location = k;
                    stack.add(tmp);
                }
                --k;
            }
        }
    }

    boolean isCombine(String name1, String name2) {
        Map<String, Long> subEUCS = this.EUCS.get(name1);
        if (subEUCS != null) {
            Long val = subEUCS.get(name2);
            if (val == null) {
                subEUCS = this.EUCS.get(name2);
                if (subEUCS == null) {
                    return false;
                }
                Long oval = subEUCS.get(name1);
                if (oval == null || (double)oval.longValue() < IAUTree.minautil) {
                    return false;
                }
            } else if ((double)val.longValue() < IAUTree.minautil) {
                return false;
            }
        } else {
            subEUCS = this.EUCS.get(name2);
            if (subEUCS != null) {
                Long val = subEUCS.get(name1);
                if (val == null) {
                    subEUCS = this.EUCS.get(name1);
                    if (subEUCS == null) {
                        return false;
                    }
                    Long oval = subEUCS.get(name2);
                    if (oval == null || (double)oval.longValue() < IAUTree.minautil) {
                        return false;
                    }
                } else if ((double)val.longValue() < IAUTree.minautil) {
                    return false;
                }
            }
        }
        return true;
    }

    void combine(List<List<IAUNode.IAUPair>> arys) {
        Collections.sort(arys, new Comparator<List<IAUNode.IAUPair>>(){

            @Override
            public int compare(List<IAUNode.IAUPair> a, List<IAUNode.IAUPair> b) {
                int cmp = a.size() - b.size();
                if (cmp == 0) {
                    int i = 0;
                    while (i < a.size()) {
                        IAUNode.IAUPair aval = a.get(i);
                        IAUNode.IAUPair bval = b.get(i);
                        int namecmp = aval.name.compareTo(bval.name);
                        if (namecmp != 0) {
                            return namecmp;
                        }
                        ++i;
                    }
                    return 0;
                }
                return cmp;
            }
        });
        int i = 1;
        while (i < arys.size()) {
            List<IAUNode.IAUPair> b;
            List<IAUNode.IAUPair> a = arys.get(i - 1);
            if (this.isEquals(a, b = arys.get(i))) {
                int j = 0;
                while (j < a.size()) {
                    IAUNode.IAUPair aval = a.get(j);
                    aval.quan += b.get((int)j).quan;
                    ++j;
                }
                arys.remove(i);
                --i;
            }
            ++i;
        }
    }

    boolean isEquals(List<IAUNode.IAUPair> a, List<IAUNode.IAUPair> b) {
        if (a.size() != b.size()) {
            return false;
        }
        int i = 0;
        while (i < a.size()) {
            IAUNode.IAUPair aval = a.get(i);
            IAUNode.IAUPair bval = b.get(i);
            if (!aval.name.equals(bval.name)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    List<List<IAUNode.IAUPair>> collectIntoList(IAUNode s) {
        ArrayList<List<IAUNode.IAUPair>> arys = new ArrayList<List<IAUNode.IAUPair>>();
        while (s != null) {
            ArrayList<IAUNode.IAUPair> quanAry = s.getQuanAry();
            List sublist = quanAry.subList(0, quanAry.size());
            arys.add(sublist);
            s = s.getRight();
            ++this.numOfNodes;
        }
        return arys;
    }
}

