/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.ElementMLHUIMiner;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityListMLHUIMiner;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class AlgoMLHUIMiner {
    public long startTimeStamp = 0L;
    public long endTimeStamp = 0L;
    public int huiCount = 0;
    Map<Integer, Integer> mapItemToGeneralizedItem;
    Map<Integer, Double> mapItemToGWU;
    Map<Integer, Integer> mapItemToLevel;
    Map<Integer, UtilityListMLHUIMiner> mapItemToUtilityListMLHUIMiner;
    Map<List<Integer>, UtilityListMLHUIMiner> mapItemsetToUtilityListMLHUIMiner;
    Map<Integer, List<Integer>> mapItemToAncestor;
    final int BUFFERS_SIZE = 500;
    private int[] itemsetBuffer = null;
    double[] transactionTU;
    List<List<Integer>> storeResult = new ArrayList<List<Integer>>();
    BufferedWriter writer = null;

    public void runAlgorithm(String inputTransactions, String inputTaxonomy, String output, double min_utility) throws IOException {
        Integer item;
        block55: {
            Cloneable ancestor;
            String thisLineTransaction;
            int tidCount;
            BufferedReader myInputTransaction;
            block53: {
                block51: {
                    MemoryLogger.getInstance().reset();
                    this.startTimeStamp = System.currentTimeMillis();
                    this.writer = new BufferedWriter(new FileWriter(output));
                    this.mapItemToGeneralizedItem = new LinkedHashMap<Integer, Integer>();
                    this.mapItemToGWU = new HashMap<Integer, Double>();
                    this.mapItemToLevel = new HashMap<Integer, Integer>();
                    this.mapItemsetToUtilityListMLHUIMiner = new HashMap<List<Integer>, UtilityListMLHUIMiner>();
                    this.mapItemToAncestor = new HashMap<Integer, List<Integer>>();
                    BufferedReader myInputTaxnomy = null;
                    try {
                        try {
                            String thisLineTaxonomy;
                            myInputTaxnomy = new BufferedReader(new InputStreamReader(new FileInputStream(new File(inputTaxonomy))));
                            while ((thisLineTaxonomy = myInputTaxnomy.readLine()) != null) {
                                if (thisLineTaxonomy.isEmpty() || thisLineTaxonomy.charAt(0) == '#' || thisLineTaxonomy.charAt(0) == '@') continue;
                                String[] splitTaxonomy = thisLineTaxonomy.split(",");
                                this.mapItemToGeneralizedItem.put(Integer.parseInt(splitTaxonomy[0]), Integer.parseInt(splitTaxonomy[1]));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (myInputTaxnomy != null) {
                                myInputTaxnomy.close();
                            }
                            break block51;
                        }
                    }
                    catch (Throwable throwable) {
                        if (myInputTaxnomy != null) {
                            myInputTaxnomy.close();
                        }
                        throw throwable;
                    }
                    if (myInputTaxnomy != null) {
                        myInputTaxnomy.close();
                    }
                }
                myInputTransaction = null;
                tidCount = 0;
                try {
                    try {
                        myInputTransaction = new BufferedReader(new InputStreamReader(new FileInputStream(new File(inputTransactions))));
                        while ((thisLineTransaction = myInputTransaction.readLine()) != null) {
                            if (thisLineTransaction.isEmpty() || thisLineTransaction.charAt(0) == '#' || thisLineTransaction.charAt(0) == '@') continue;
                            String[] split = thisLineTransaction.split(":");
                            String[] items = split[0].split(" ");
                            ArrayList ancestantExist = new ArrayList();
                            double transactionUtility = Double.parseDouble(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                int k;
                                item = Integer.parseInt(items[i]);
                                Double gwu = this.mapItemToGWU.get(item);
                                gwu = gwu == null ? transactionUtility : gwu + transactionUtility;
                                ancestor = new ArrayList<Integer>();
                                ((ArrayList)ancestor).add(item);
                                this.mapItemToGWU.put(item, gwu);
                                if (this.mapItemToAncestor.get(item) == null) {
                                    Integer itemCopy = item;
                                    for (Map.Entry<Integer, Integer> entry : this.mapItemToGeneralizedItem.entrySet()) {
                                        Integer childItem = entry.getKey();
                                        Integer parentItem = entry.getValue();
                                        if (!childItem.equals(itemCopy)) continue;
                                        ((ArrayList)ancestor).add(parentItem);
                                        if (!ancestantExist.contains(parentItem)) {
                                            ancestantExist.add(parentItem);
                                            Double twuParent = this.mapItemToGWU.get(parentItem);
                                            twuParent = twuParent == null ? transactionUtility : twuParent + transactionUtility;
                                            this.mapItemToGWU.put(parentItem, twuParent);
                                        }
                                        itemCopy = parentItem;
                                    }
                                    k = ((ArrayList)ancestor).size();
                                    int j = 0;
                                    while (j < ((ArrayList)ancestor).size()) {
                                        this.mapItemToLevel.put((Integer)((ArrayList)ancestor).get(j), k);
                                        ++j;
                                        --k;
                                    }
                                    int itemKey = 0;
                                    while (itemKey < ((ArrayList)ancestor).size()) {
                                        ArrayList<Integer> itemValue = new ArrayList<Integer>();
                                        int listValue = itemKey + 1;
                                        while (listValue < ((ArrayList)ancestor).size()) {
                                            itemValue.add((Integer)((ArrayList)ancestor).get(listValue));
                                            ++listValue;
                                        }
                                        this.mapItemToAncestor.put((Integer)((ArrayList)ancestor).get(itemKey), itemValue);
                                        ++itemKey;
                                    }
                                } else {
                                    List<Integer> listAncestorOfItem = this.mapItemToAncestor.get(item);
                                    k = 0;
                                    while (k < listAncestorOfItem.size()) {
                                        if (!ancestantExist.contains(listAncestorOfItem.get(k))) {
                                            ancestantExist.add(listAncestorOfItem.get(k));
                                            Double twuParent = this.mapItemToGWU.get(listAncestorOfItem.get(k));
                                            twuParent = twuParent == null ? transactionUtility : twuParent + transactionUtility;
                                            this.mapItemToGWU.put(listAncestorOfItem.get(k), twuParent);
                                        }
                                        ++k;
                                    }
                                }
                                ++i;
                            }
                            ++tidCount;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInputTransaction != null) {
                            myInputTransaction.close();
                        }
                        break block53;
                    }
                }
                catch (Throwable throwable) {
                    if (myInputTransaction != null) {
                        myInputTransaction.close();
                    }
                    throw throwable;
                }
                if (myInputTransaction != null) {
                    myInputTransaction.close();
                }
            }
            ArrayList<UtilityListMLHUIMiner> listOfTaxUtilityListMLHUIMiner = new ArrayList<UtilityListMLHUIMiner>();
            this.mapItemToUtilityListMLHUIMiner = new HashMap<Integer, UtilityListMLHUIMiner>();
            block20: for (Map.Entry<Integer, Double> entry : this.mapItemToGWU.entrySet()) {
                Integer item2 = entry.getKey();
                if (this.mapItemToGWU.get(item2) >= min_utility) {
                    ArrayList<Integer> itemList = new ArrayList<Integer>();
                    itemList.add(item2);
                    UtilityListMLHUIMiner tuList = new UtilityListMLHUIMiner(itemList);
                    this.mapItemToUtilityListMLHUIMiner.put(item2, tuList);
                    listOfTaxUtilityListMLHUIMiner.add(tuList);
                    continue;
                }
                List<Integer> listAncestorOfItem = this.mapItemToAncestor.get(item2);
                int k = 0;
                while (k < listAncestorOfItem.size()) {
                    if (this.mapItemToGWU.get(listAncestorOfItem.get(k)) >= min_utility) {
                        ArrayList<Integer> itemList = new ArrayList<Integer>();
                        itemList.add(item2);
                        UtilityListMLHUIMiner tuList = new UtilityListMLHUIMiner(itemList);
                        this.mapItemToUtilityListMLHUIMiner.put(item2, tuList);
                        listOfTaxUtilityListMLHUIMiner.add(tuList);
                        continue block20;
                    }
                    ++k;
                }
            }
            Collections.sort(listOfTaxUtilityListMLHUIMiner, new Comparator<UtilityListMLHUIMiner>(){

                @Override
                public int compare(UtilityListMLHUIMiner o1, UtilityListMLHUIMiner o2) {
                    return AlgoMLHUIMiner.this.compareItems(o1.item.get(0), o2.item.get(0));
                }
            });
            this.transactionTU = new double[tidCount];
            try {
                try {
                    myInputTransaction = new BufferedReader(new InputStreamReader(new FileInputStream(new File(inputTransactions))));
                    int tid = 0;
                    while ((thisLineTransaction = myInputTransaction.readLine()) != null) {
                        if (thisLineTransaction.isEmpty() || thisLineTransaction.charAt(0) == '#' || thisLineTransaction.charAt(0) == '%' || thisLineTransaction.charAt(0) == '@') continue;
                        String[] split = thisLineTransaction.split(":");
                        String[] items = split[0].split(" ");
                        this.transactionTU[tid] = Double.parseDouble(split[1]);
                        String[] utilityValues = split[2].split(" ");
                        double remainingUtility = 0.0;
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        int i = 0;
                        while (i < items.length) {
                            Pair pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Double.parseDouble(utilityValues[i]);
                            if (this.mapItemToGWU.get(pair.item) >= min_utility) {
                                revisedTransaction.add(pair);
                                remainingUtility += pair.utility;
                            } else {
                                List<Integer> listAncestorOfItem = this.mapItemToAncestor.get(pair.item);
                                int k = 0;
                                while (k < listAncestorOfItem.size()) {
                                    if (this.mapItemToGWU.get(listAncestorOfItem.get(k)) >= min_utility) {
                                        revisedTransaction.add(pair);
                                        remainingUtility += pair.utility;
                                        break;
                                    }
                                    ++k;
                                }
                            }
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Pair>(){

                            @Override
                            public int compare(Pair o1, Pair o2) {
                                return AlgoMLHUIMiner.this.compareItems(o1.item, o2.item);
                            }
                        });
                        ancestor = new LinkedHashMap();
                        HashMap<Integer, Double> firstChildItemUtility = new HashMap<Integer, Double>();
                        HashMap<Integer, Double> firstChildItemRemainingUtility = new HashMap<Integer, Double>();
                        for (Pair pair : revisedTransaction) {
                            UtilityListMLHUIMiner taxUtilityListMLHUIMinerOfItem = this.mapItemToUtilityListMLHUIMiner.get(pair.item);
                            ElementMLHUIMiner element = new ElementMLHUIMiner(tid, pair.utility, remainingUtility -= pair.utility);
                            taxUtilityListMLHUIMinerOfItem.addElement(element);
                            this.mapItemToUtilityListMLHUIMiner.put(pair.item, taxUtilityListMLHUIMinerOfItem);
                            List<Integer> listAncestorOfItem = this.mapItemToAncestor.get(pair.item);
                            int k = 0;
                            while (k < listAncestorOfItem.size()) {
                                ElementMLHUIMiner parentElementMLHUIMiner;
                                UtilityListMLHUIMiner taxUtilityListMLHUIMinerOfParentItem = this.mapItemToUtilityListMLHUIMiner.get(listAncestorOfItem.get(k));
                                double parentUtility = 0.0;
                                if (!ancestor.containsKey(listAncestorOfItem.get(k))) {
                                    firstChildItemUtility.put(listAncestorOfItem.get(k), pair.utility);
                                    firstChildItemRemainingUtility.put(listAncestorOfItem.get(k), remainingUtility);
                                    parentUtility = pair.utility;
                                    ancestor.put(listAncestorOfItem.get(k), parentUtility);
                                    parentElementMLHUIMiner = new ElementMLHUIMiner(tid, pair.utility, (Double)firstChildItemRemainingUtility.get(listAncestorOfItem.get(k)));
                                    taxUtilityListMLHUIMinerOfParentItem.addElement(parentElementMLHUIMiner);
                                } else {
                                    parentElementMLHUIMiner = new ElementMLHUIMiner(tid, pair.utility, -pair.utility);
                                    taxUtilityListMLHUIMinerOfParentItem.addElement(parentElementMLHUIMiner);
                                }
                                this.mapItemToUtilityListMLHUIMiner.put(listAncestorOfItem.get(k), taxUtilityListMLHUIMinerOfParentItem);
                                ++k;
                            }
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInputTransaction != null) {
                        myInputTransaction.close();
                    }
                    break block55;
                }
            }
            catch (Throwable throwable) {
                if (myInputTransaction != null) {
                    myInputTransaction.close();
                }
                throw throwable;
            }
            if (myInputTransaction != null) {
                myInputTransaction.close();
            }
        }
        ArrayList listOfUtilityListMLHUIMiners = new ArrayList();
        int i = 0;
        while (i < AlgoMLHUIMiner.getMaxLevel(this.mapItemToLevel)) {
            ArrayList<UtilityListMLHUIMiner> UtilityListMLHUIMinerOfILevel = new ArrayList<UtilityListMLHUIMiner>();
            for (Map.Entry<Integer, Double> entry : this.mapItemToGWU.entrySet()) {
                item = entry.getKey();
                if (!(this.mapItemToGWU.get(item) >= min_utility) || this.mapItemToLevel.get(item) != i + 1) continue;
                UtilityListMLHUIMiner uList = this.mapItemToUtilityListMLHUIMiner.get(item);
                UtilityListMLHUIMinerOfILevel.add(uList);
            }
            listOfUtilityListMLHUIMiners.add(UtilityListMLHUIMinerOfILevel);
            ++i;
        }
        System.out.println("algorithm is running......");
        MemoryLogger.getInstance().checkMemory();
        i = 0;
        while (i < AlgoMLHUIMiner.getMaxLevel(this.mapItemToLevel)) {
            this.mlhuiminer(this.itemsetBuffer, 0, null, (List)listOfUtilityListMLHUIMiners.get(i), min_utility);
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimeStamp = System.currentTimeMillis();
        System.out.println("finished......");
    }

    private static Integer getMaxLevel(Map<Integer, Integer> map) {
        if (map == null) {
            return null;
        }
        int length = map.size();
        Collection<Integer> c = map.values();
        Object[] obj = c.toArray();
        Arrays.sort(obj);
        return Integer.parseInt(obj[length - 1].toString());
    }

    private int compareItems(int item1, int item2) {
        double compare = this.mapItemToGWU.get(item1) - this.mapItemToGWU.get(item2);
        if (Math.abs(compare) < 0.01) {
            return item1 - item2;
        }
        if (compare > 0.0) {
            return 1;
        }
        return -1;
    }

    private void mlhuiminer(int[] prefix, int prefixLength, UtilityListMLHUIMiner pUL, List<UtilityListMLHUIMiner> ULs, Double minUtility) throws IOException {
        int i = 0;
        while (i < ULs.size()) {
            UtilityListMLHUIMiner X = ULs.get(i);
            if (X.sumIutils >= minUtility) {
                this.writeOut(X.item, X.sumIutils);
            }
            ArrayList<UtilityListMLHUIMiner> exULs = new ArrayList<UtilityListMLHUIMiner>();
            int j = i + 1;
            while (j < ULs.size()) {
                UtilityListMLHUIMiner Y = ULs.get(j);
                UtilityListMLHUIMiner temp = this.construct(pUL, X, Y);
                if (temp != null) {
                    exULs.add(temp);
                }
                this.mlhuiminer(this.itemsetBuffer, prefixLength + 1, X, exULs, minUtility);
                ++j;
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private UtilityListMLHUIMiner construct(UtilityListMLHUIMiner P, UtilityListMLHUIMiner py, UtilityListMLHUIMiner px) {
        ArrayList<Integer> itemOfPXY = new ArrayList<Integer>();
        LinkedHashSet<Integer> itemTemp = new LinkedHashSet<Integer>();
        itemTemp.addAll(py.item);
        itemTemp.addAll(px.item);
        itemOfPXY.addAll(itemTemp);
        UtilityListMLHUIMiner pxyUL = new UtilityListMLHUIMiner(itemOfPXY);
        for (ElementMLHUIMiner ex : px.elements) {
            ElementMLHUIMiner ey = this.findElementMLHUIMinerWithTID(py, ex.tid);
            if (ey == null) continue;
            if (P == null) {
                ElementMLHUIMiner eXY = new ElementMLHUIMiner(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            ElementMLHUIMiner e = this.findElementMLHUIMinerWithTID(P, ex.tid);
            if (e == null) continue;
            ElementMLHUIMiner eXY = new ElementMLHUIMiner(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private ElementMLHUIMiner findElementMLHUIMinerWithTID(UtilityListMLHUIMiner tulist, int tid) {
        List<ElementMLHUIMiner> list = tulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(List<Integer> item, double utility) throws IOException {
        if (!this.storeResult.contains(item)) {
            this.storeResult.add(item);
            ++this.huiCount;
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < item.size()) {
                buffer.append(item.get(i));
                if (i != item.size() - 1) {
                    buffer.append(' ');
                }
                ++i;
            }
            buffer.append(" #UTIL: ");
            buffer.append(utility);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    public void printStatistics() throws IOException {
        System.out.println("=============  MLHUIMiner ALGORITHM - SPMF 0.97e - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimeStamp - this.startTimeStamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiCount);
        System.out.println("===================================================");
    }

    class Pair {
        int item = 0;
        double utility = 0.0;

        Pair() {
        }
    }
}

