/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityListHUP;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoHUPMiner {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    Map<Integer, Integer> mapItemToTWU;
    BufferedWriter writer = null;
    private int joinCount;
    private int partialJoinCount;
    private int transactionCount;
    private int k;
    private int partitionSize;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;

    public void runAlgorithm(String input, String output, int minUtility, int k) throws IOException {
        ArrayList<UtilityListHUP> listOfUtilityLists;
        block26: {
            String thisLine;
            BufferedReader myInput;
            block24: {
                MemoryLogger.getInstance().reset();
                this.itemsetBuffer = new int[200];
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToTWU = new HashMap<Integer, Integer>();
                myInput = null;
                this.transactionCount = 0;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer twu = this.mapItemToTWU.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                this.mapItemToTWU.put(item, twu);
                                ++i;
                            }
                            ++this.transactionCount;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            this.k = k;
            if (k > this.transactionCount) {
                this.partitionSize = this.transactionCount;
                this.k = 1;
            } else {
                this.partitionSize = this.transactionCount / this.k;
                this.k = (int)Math.ceil((double)this.transactionCount / (double)this.partitionSize);
            }
            listOfUtilityLists = new ArrayList<UtilityListHUP>();
            HashMap<Integer, UtilityListHUP> mapItemToUtilityList = new HashMap<Integer, UtilityListHUP>();
            for (Integer item : this.mapItemToTWU.keySet()) {
                if (this.mapItemToTWU.get(item) < minUtility) continue;
                UtilityListHUP uList = new UtilityListHUP(item, this.k);
                mapItemToUtilityList.put(item, uList);
                listOfUtilityLists.add(uList);
            }
            Collections.sort(listOfUtilityLists, new Comparator<UtilityListHUP>(){

                @Override
                public int compare(UtilityListHUP o1, UtilityListHUP o2) {
                    return AlgoHUPMiner.this.compareItems(o1.item, o2.item);
                }
            });
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    int tid = 0;
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        int remainingUtility = 0;
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        int i = 0;
                        while (i < items.length) {
                            Pair pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            if (this.mapItemToTWU.get(pair.item) >= minUtility) {
                                revisedTransaction.add(pair);
                                remainingUtility += pair.utility;
                            }
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Pair>(){

                            @Override
                            public int compare(Pair o1, Pair o2) {
                                return AlgoHUPMiner.this.compareItems(o1.item, o2.item);
                            }
                        });
                        for (Pair pair : revisedTransaction) {
                            UtilityListHUP utilityListOfItem = (UtilityListHUP)mapItemToUtilityList.get(pair.item);
                            Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                            utilityListOfItem.addElement(element, this.partitionSize);
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.hupMiner(this.itemsetBuffer, 0, null, listOfUtilityLists, minUtility);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void hupMiner(int[] prefix, int prefixLength, UtilityListHUP pUL, List<UtilityListHUP> ULs, int minUtility) throws IOException {
        int i = 0;
        while (i < ULs.size()) {
            UtilityListHUP X = ULs.get(i);
            if (X.sumIutils >= (long)minUtility) {
                this.writeOut(prefix, prefixLength, X.item, X.sumIutils);
            }
            if (X.sumIutils + X.sumRutils >= (long)minUtility) {
                ArrayList<UtilityListHUP> exULs = new ArrayList<UtilityListHUP>();
                int j = i + 1;
                while (j < ULs.size()) {
                    UtilityListHUP Y = ULs.get(j);
                    if (!this.puPrune(X, Y, minUtility)) {
                        UtilityListHUP pul = this.construct(pUL, X, Y, minUtility);
                        if (pul != null) {
                            exULs.add(pul);
                            ++this.joinCount;
                        } else {
                            ++this.partialJoinCount;
                        }
                    }
                    ++j;
                }
                this.itemsetBuffer[prefixLength] = X.item;
                this.hupMiner(this.itemsetBuffer, prefixLength + 1, X, exULs, minUtility);
            }
            ++i;
        }
    }

    private boolean puPrune(UtilityListHUP X, UtilityListHUP Y, int minUtil) {
        long sum = 0L;
        int i = 0;
        while (i < this.k) {
            if (Y.partitionSURU[i] != 0) {
                sum += (long)X.partitionSURU[i];
            }
            ++i;
        }
        return sum < (long)minUtil;
    }

    private UtilityListHUP construct(UtilityListHUP P, UtilityListHUP px, UtilityListHUP py, int minUtility) {
        UtilityListHUP pxyUL = new UtilityListHUP(py.item, this.k);
        long totalUtility = px.sumIutils + px.sumRutils;
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) {
                if ((totalUtility -= (long)(ex.iutils + ex.rutils)) >= (long)minUtility) continue;
                return null;
            }
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY, this.partitionSize);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY, this.partitionSize);
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityListHUP ulist, int tid) {
        List list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (((Element)list.get((int)middle)).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (((Element)list.get((int)middle)).tid > tid) {
                last = middle - 1;
                continue;
            }
            return (Element)list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, int item, long utility) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(prefix[i]);
            buffer.append(' ');
            ++i;
        }
        buffer.append(item);
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("=============  HUP-MINER ALGORITHM v0.96r18 - STATS =============");
        System.out.println(" Transaction count: " + this.transactionCount + " Partition count: " + this.k);
        System.out.println(" Partition size: " + this.partitionSize);
        System.out.println(" Join count: " + this.joinCount + " Partial join count:" + this.partialJoinCount);
        System.out.println(" Total time: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max. Memory: " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" High-utility itemsets count: " + this.huiCount);
        System.out.println("===================================================");
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

