/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.ElementFHMPlus;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityListFHMPlus;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoFHMPlus {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    public int candidateCount = 0;
    Map<Integer, Long> mapItemToTWU;
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, Long>> mapFMAP;
    boolean ENABLE_LA_PRUNE = true;
    boolean DEBUG = false;
    public double totalExecutionTime = 0.0;
    public double maximumMemoryUsage = 0.0;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    boolean ENABLE_NEW_CONSTRUCT = true;
    boolean USE_ALPHABETICAL_ORDER = true;
    private int maximumLength = Integer.MAX_VALUE;
    private int minimumLength = 1;
    final int TRANSACTION_BUFFER = 3000;
    private int[] utilitiesBuffer = new int[3000];
    private Pair[] sortedPairsBuffer = new Pair[3000];

    public void runAlgorithm(String input, String output, int minUtility, int minimumLength, int maximumLength) throws IOException {
        ArrayList<UtilityListFHMPlus> listOfUtilityLists;
        block36: {
            String thisLine;
            BufferedReader myInput;
            block34: {
                MemoryLogger.getInstance().reset();
                this.itemsetBuffer = new int[200];
                this.minimumLength = minimumLength;
                this.maximumLength = maximumLength;
                this.mapFMAP = new HashMap<Integer, Map<Integer, Long>>();
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToTWU = new HashMap<Integer, Long>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            int z = 0;
                            String[] stringArray = split[2].split(" ");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String utilityValue = stringArray[n2];
                                this.utilitiesBuffer[z++] = Integer.parseInt(utilityValue);
                                ++n2;
                            }
                            Arrays.sort(this.utilitiesBuffer, 0, items.length);
                            int reducedTWU = 0;
                            int startIndex = items.length - 1 - maximumLength;
                            if (startIndex < 0) {
                                startIndex = 0;
                            }
                            int i = items.length - 1;
                            while (i >= startIndex) {
                                reducedTWU += this.utilitiesBuffer[i];
                                --i;
                            }
                            i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Long twu = this.mapItemToTWU.get(item);
                                twu = twu == null ? (long)reducedTWU : twu + (long)reducedTWU;
                                this.mapItemToTWU.put(item, twu);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block34;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            listOfUtilityLists = new ArrayList<UtilityListFHMPlus>();
            HashMap<Integer, UtilityListFHMPlus> mapItemToUtilityList = new HashMap<Integer, UtilityListFHMPlus>();
            for (Integer item : this.mapItemToTWU.keySet()) {
                if (this.mapItemToTWU.get(item) < (long)minUtility) continue;
                UtilityListFHMPlus uList = new UtilityListFHMPlus(item);
                mapItemToUtilityList.put(item, uList);
                listOfUtilityLists.add(uList);
            }
            Collections.sort(listOfUtilityLists, new Comparator<UtilityListFHMPlus>(){

                @Override
                public int compare(UtilityListFHMPlus o1, UtilityListFHMPlus o2) {
                    return AlgoFHMPlus.this.compareItems(o1.item, o2.item);
                }
            });
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    int tid = 0;
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        int newItemCount = 0;
                        int i = 0;
                        while (i < items.length) {
                            int item = Integer.parseInt(items[i]);
                            if (this.mapItemToTWU.get(item) >= (long)minUtility) {
                                Pair pair = new Pair();
                                pair.utility = Integer.parseInt(utilityValues[i]);
                                pair.item = item;
                                this.sortedPairsBuffer[newItemCount] = pair;
                                ++newItemCount;
                            }
                            ++i;
                        }
                        Arrays.sort(this.sortedPairsBuffer, 0, newItemCount, new Comparator<Pair>(){

                            @Override
                            public int compare(Pair o1, Pair o2) {
                                int compare = o2.utility - o1.utility;
                                if (compare == 0) {
                                    compare = o2.item - o1.item;
                                }
                                return compare;
                            }
                        });
                        long newTWU = 0L;
                        int z = 0;
                        while (z < maximumLength && z < newItemCount) {
                            newTWU += (long)this.sortedPairsBuffer[z].utility;
                            ++z;
                        }
                        int i2 = 0;
                        while (i2 < newItemCount) {
                            Pair pair = this.sortedPairsBuffer[i2];
                            UtilityListFHMPlus utilityListOfItem = (UtilityListFHMPlus)mapItemToUtilityList.get(pair.item);
                            ElementFHMPlus element = new ElementFHMPlus(tid, pair.utility);
                            int sizeRemainingArray = maximumLength - 1;
                            element.remainingArray = new int[sizeRemainingArray];
                            Map<Integer, Long> mapFMAPItem = this.mapFMAP.get(pair.item);
                            if (mapFMAPItem == null) {
                                mapFMAPItem = new HashMap<Integer, Long>();
                                this.mapFMAP.put(pair.item, mapFMAPItem);
                            }
                            int numberOfItemsCanExtendWhithinMaxLimit = 0;
                            int j = 0;
                            while (j < newItemCount) {
                                Pair otherPair = this.sortedPairsBuffer[j];
                                if (this.compareItems(pair.item, otherPair.item) < 0) {
                                    Long twuSum;
                                    if (numberOfItemsCanExtendWhithinMaxLimit != sizeRemainingArray) {
                                        element.rutils += otherPair.utility;
                                        element.remainingArray[numberOfItemsCanExtendWhithinMaxLimit] = otherPair.utility;
                                        ++numberOfItemsCanExtendWhithinMaxLimit;
                                    }
                                    if ((twuSum = mapFMAPItem.get(otherPair.item)) == null) {
                                        mapFMAPItem.put(otherPair.item, newTWU);
                                    } else {
                                        mapFMAPItem.put(otherPair.item, twuSum + newTWU);
                                    }
                                }
                                ++j;
                            }
                            utilityListOfItem.addElement(element);
                            ++i2;
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block36;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        for (UtilityListFHMPlus X : listOfUtilityLists) {
            if (X.sumIutils < (long)minUtility) continue;
            this.writeOut(this.itemsetBuffer, 0, X.item, X.sumIutils);
        }
        if (maximumLength > 1) {
            this.fhm(this.itemsetBuffer, 0, null, listOfUtilityLists, minUtility);
        }
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
        this.maximumMemoryUsage = MemoryLogger.getInstance().getMaxMemory();
        this.totalExecutionTime = this.endTimestamp - this.startTimestamp;
    }

    private int compareItems(int item1, int item2) {
        if (!this.USE_ALPHABETICAL_ORDER) {
            int compare = (int)(this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2));
            return compare == 0 ? item1 - item2 : compare;
        }
        return item1 - item2;
    }

    private void fhm(int[] prefix, int prefixLength, UtilityListFHMPlus pUL, List<UtilityListFHMPlus> ULs, int minUtility) throws IOException {
        int i = 0;
        while (i < ULs.size()) {
            UtilityListFHMPlus X = ULs.get(i);
            if (X.sumIutils + X.sumRutils >= (long)minUtility) {
                this.itemsetBuffer[prefixLength] = X.item;
                ArrayList<UtilityListFHMPlus> exULs = new ArrayList<UtilityListFHMPlus>();
                int j = i + 1;
                while (j < ULs.size()) {
                    Long twuF;
                    UtilityListFHMPlus Y = ULs.get(j);
                    Map<Integer, Long> mapTWUF = this.mapFMAP.get(X.item);
                    if (mapTWUF == null || (twuF = mapTWUF.get(Y.item)) != null && twuF >= (long)minUtility) {
                        ++this.candidateCount;
                        UtilityListFHMPlus temp = this.ENABLE_NEW_CONSTRUCT ? this.construct(pUL, X, Y, minUtility, prefixLength + 2) : this.oldConstruct(pUL, X, Y, minUtility, prefixLength + 2);
                        if (temp != null) {
                            if (temp.sumIutils >= (long)minUtility) {
                                this.writeOut(this.itemsetBuffer, prefixLength + 1, temp.item, temp.sumIutils);
                            }
                            if (prefixLength + 2 != this.maximumLength) {
                                exULs.add(temp);
                            }
                        }
                    }
                    ++j;
                }
                if (prefixLength + 2 != this.maximumLength) {
                    this.fhm(this.itemsetBuffer, prefixLength + 1, X, exULs, minUtility);
                }
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private UtilityListFHMPlus construct(UtilityListFHMPlus P, UtilityListFHMPlus px, UtilityListFHMPlus py, int minUtility, int pxyLength) {
        UtilityListFHMPlus pxyUL = new UtilityListFHMPlus(py.item);
        long totalUtility = px.sumIutils + px.sumRutils;
        for (ElementFHMPlus ex : px.elements) {
            ElementFHMPlus ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) {
                if (!this.ENABLE_LA_PRUNE || (totalUtility -= (long)(ex.iutils + ex.rutils)) >= (long)minUtility) continue;
                return null;
            }
            ElementFHMPlus eXY = null;
            if (P == null) {
                eXY = new ElementFHMPlus(ex.tid, ex.iutils + ey.iutils);
                int newRemainingArraySize = 0;
                int z = 0;
                while (z < ey.remainingArray.length) {
                    if (ey.remainingArray[z] == 0) break;
                    ++newRemainingArraySize;
                    ++z;
                }
                if (newRemainingArraySize + pxyLength > this.maximumLength && --newRemainingArraySize == -1) {
                    newRemainingArraySize = 0;
                }
                eXY.remainingArray = new int[newRemainingArraySize];
                int i = 0;
                while (i < newRemainingArraySize) {
                    if (ey.remainingArray[i] != 0) {
                        eXY.remainingArray[i] = ey.remainingArray[i];
                        eXY.rutils += ey.remainingArray[i];
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                ElementFHMPlus e = this.findElementWithTID(P, ex.tid);
                if (e != null) {
                    eXY = new ElementFHMPlus(ex.tid, ex.iutils + ey.iutils - e.iutils);
                    int newRemainingArraySize = ey.remainingArray.length;
                    if (newRemainingArraySize + pxyLength > this.maximumLength && --newRemainingArraySize == -1) {
                        newRemainingArraySize = 0;
                    }
                    eXY.remainingArray = new int[newRemainingArraySize];
                    int i = 0;
                    while (i < newRemainingArraySize) {
                        if (ey.remainingArray[i] != 0) {
                            eXY.remainingArray[i] = ey.remainingArray[i];
                            eXY.rutils += ey.remainingArray[i];
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
            }
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private UtilityListFHMPlus oldConstruct(UtilityListFHMPlus P, UtilityListFHMPlus px, UtilityListFHMPlus py, int minUtility, int pxyLength) {
        UtilityListFHMPlus pxyUL = new UtilityListFHMPlus(py.item);
        long totalUtility = px.sumIutils + px.sumRutils;
        for (ElementFHMPlus ex : px.elements) {
            ElementFHMPlus ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) {
                if (!this.ENABLE_LA_PRUNE || (totalUtility -= (long)(ex.iutils + ex.rutils)) >= (long)minUtility) continue;
                return null;
            }
            if (P == null) {
                ElementFHMPlus eXY = new ElementFHMPlus(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            ElementFHMPlus e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            ElementFHMPlus eXY = new ElementFHMPlus(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private ElementFHMPlus findElementWithTID(UtilityListFHMPlus ulist, int tid) {
        List<ElementFHMPlus> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, int item, long utility) throws IOException {
        if (prefixLength + 1 < this.minimumLength) {
            return;
        }
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(prefix[i]);
            buffer.append(' ');
            ++i;
        }
        buffer.append(item);
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() throws IOException {
        System.out.println("=============  FHM+ ALGORITHM - SPMF 0.99c - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiCount);
        System.out.println(" Candidate count : " + this.candidateCount);
        if (this.DEBUG) {
            int pairCount = 0;
            double maxMemory = this.getObjectSize(this.mapFMAP);
            for (Map.Entry<Integer, Map<Integer, Long>> entry : this.mapFMAP.entrySet()) {
                maxMemory += this.getObjectSize(entry.getKey());
                for (Map.Entry<Integer, Long> entry2 : entry.getValue().entrySet()) {
                    ++pairCount;
                    maxMemory += this.getObjectSize(entry2.getKey()) + this.getObjectSize(entry2.getValue());
                }
            }
            System.out.println("CMAP size " + maxMemory + " MB");
            System.out.println("PAIR COUNT " + pairCount);
        }
        System.out.println("===================================================");
    }

    private double getObjectSize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        double maxMemory = (double)baos.size() / 1024.0 / 1024.0;
        return maxMemory;
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

