/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hminer;

import ca.pfv.spmf.algorithms.frequentpatterns.hminer.CUL_List;
import ca.pfv.spmf.algorithms.frequentpatterns.hminer.Element_CUL_List;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoHMiner {
    public double maxMemory = 0.0;
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public long construct_time = 0L;
    public long huiCount = 0L;
    public long candidateCount = 0L;
    public long construct_calls = 0L;
    public long numberRecursions = 0L;
    public long closure_time = 0L;
    public long temp_closure_time = 0L;
    public long p_laprune = 0L;
    public long p_cprune = 0L;
    public long recursive_calls = 0L;
    public long merging_time = 0L;
    public long temp_merging_time = 0L;
    Map<Integer, Long> mapItemToTWU;
    BufferedWriter writer = null;
    String outputFile;
    Map<Integer, Map<Integer, Long>> mapFMAP;
    public static boolean merging_flag;
    public static boolean eucs_flag;
    boolean debug = false;
    long stats_time = 0L;

    public void runAlgorithm(String transactionFile, String outputFile, long minUtility, boolean merging, boolean EUCS) throws IOException {
        long time_EUCS;
        ArrayList<CUL_List> listOfCULLists;
        block39: {
            String thisLine;
            BufferedReader myInput;
            block37: {
                MemoryLogger.getInstance().reset();
                merging_flag = merging;
                eucs_flag = EUCS;
                this.mapFMAP = new HashMap<Integer, Map<Integer, Long>>();
                this.startTimestamp = System.currentTimeMillis();
                this.mapItemToTWU = new HashMap<Integer, Long>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(transactionFile))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Long twu = this.mapItemToTWU.get(item);
                                twu = twu == null ? (long)transactionUtility : twu + (long)transactionUtility;
                                this.mapItemToTWU.put(item, twu);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block37;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            listOfCULLists = new ArrayList<CUL_List>();
            HashMap HT = new HashMap();
            HashMap<Integer, CUL_List> mapItemToCULList = new HashMap<Integer, CUL_List>();
            for (Integer item : this.mapItemToTWU.keySet()) {
                if (this.mapItemToTWU.get(item) < minUtility) continue;
                CUL_List uList = new CUL_List(item);
                mapItemToCULList.put(item, uList);
                listOfCULLists.add(uList);
            }
            Collections.sort(listOfCULLists, new Comparator<CUL_List>(){

                @Override
                public int compare(CUL_List o1, CUL_List o2) {
                    return AlgoHMiner.this.compareItems(o1.item, o2.item);
                }
            });
            time_EUCS = 0L;
            long temp_EUCS = 0L;
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(transactionFile))));
                    int tid = 1;
                    while ((thisLine = myInput.readLine()) != null) {
                        Pair pair;
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        long remainingUtility = 0L;
                        long newTWU = 0L;
                        ArrayList<Integer> tx_key = new ArrayList<Integer>();
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        int i = 0;
                        while (i < items.length) {
                            pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            if (this.mapItemToTWU.get(pair.item) >= minUtility) {
                                revisedTransaction.add(pair);
                                tx_key.add(pair.item);
                                newTWU += pair.utility;
                            }
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Pair>(){

                            @Override
                            public int compare(Pair o1, Pair o2) {
                                return AlgoHMiner.this.compareItems(o1.item, o2.item);
                            }
                        });
                        if (revisedTransaction.size() > 0) {
                            CUL_List CULListOfItem;
                            if (merging_flag) {
                                if (!HT.containsKey(tx_key)) {
                                    this.temp_merging_time = System.currentTimeMillis();
                                    HT.put(tx_key, ((CUL_List)mapItemToCULList.get((Object)Integer.valueOf((int)((Pair)revisedTransaction.get((int)(revisedTransaction.size() - 1))).item))).elements.size());
                                    this.merging_time += System.currentTimeMillis() - this.temp_merging_time;
                                    i = revisedTransaction.size() - 1;
                                    while (i >= 0) {
                                        pair = (Pair)revisedTransaction.get(i);
                                        CULListOfItem = (CUL_List)mapItemToCULList.get(pair.item);
                                        Element_CUL_List element = new Element_CUL_List(tid, pair.utility, remainingUtility, 0L, 0);
                                        element.Ppos = i > 0 ? ((CUL_List)mapItemToCULList.get((Object)Integer.valueOf((int)((Pair)revisedTransaction.get((int)(i - 1))).item))).elements.size() : -1;
                                        CULListOfItem.addElement(element);
                                        remainingUtility += pair.utility;
                                        --i;
                                    }
                                } else {
                                    this.temp_merging_time = System.currentTimeMillis();
                                    int pos = (Integer)HT.get(tx_key);
                                    remainingUtility = 0L;
                                    int i2 = revisedTransaction.size() - 1;
                                    while (i2 >= 0) {
                                        CULListOfItem = (CUL_List)mapItemToCULList.get(((Pair)revisedTransaction.get((int)i2)).item);
                                        CULListOfItem.elements.get((int)pos).Nu += ((Pair)revisedTransaction.get((int)i2)).utility;
                                        CULListOfItem.elements.get((int)pos).Nru += remainingUtility;
                                        CULListOfItem.sumNu += ((Pair)revisedTransaction.get((int)i2)).utility;
                                        CULListOfItem.sumNru += remainingUtility;
                                        remainingUtility += ((Pair)revisedTransaction.get((int)i2)).utility;
                                        pos = CULListOfItem.elements.get((int)pos).Ppos;
                                        --i2;
                                    }
                                    this.merging_time += System.currentTimeMillis() - this.temp_merging_time;
                                }
                            } else {
                                i = revisedTransaction.size() - 1;
                                while (i >= 0) {
                                    pair = (Pair)revisedTransaction.get(i);
                                    CULListOfItem = (CUL_List)mapItemToCULList.get(pair.item);
                                    Element_CUL_List element = new Element_CUL_List(tid, pair.utility, remainingUtility, 0L, 0);
                                    element.Ppos = i > 0 ? ((CUL_List)mapItemToCULList.get((Object)Integer.valueOf((int)((Pair)revisedTransaction.get((int)(i - 1))).item))).elements.size() : -1;
                                    CULListOfItem.addElement(element);
                                    remainingUtility += pair.utility;
                                    --i;
                                }
                            }
                        }
                        if (eucs_flag) {
                            temp_EUCS = System.currentTimeMillis();
                            i = revisedTransaction.size() - 1;
                            while (i >= 0) {
                                Pair pair2 = (Pair)revisedTransaction.get(i);
                                Map<Integer, Long> mapFMAPItem = this.mapFMAP.get(pair2.item);
                                if (mapFMAPItem == null) {
                                    mapFMAPItem = new HashMap<Integer, Long>();
                                    this.mapFMAP.put(pair2.item, mapFMAPItem);
                                }
                                int j = i + 1;
                                while (j < revisedTransaction.size()) {
                                    Pair pairAfter = (Pair)revisedTransaction.get(j);
                                    Long twuSum = mapFMAPItem.get(pairAfter.item);
                                    if (twuSum == null) {
                                        mapFMAPItem.put(pairAfter.item, newTWU);
                                    } else {
                                        mapFMAPItem.put(pairAfter.item, twuSum + newTWU);
                                    }
                                    ++j;
                                }
                                --i;
                            }
                            time_EUCS += System.currentTimeMillis() - temp_EUCS;
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block39;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.checkMemory();
        long initial_time = System.currentTimeMillis() - this.startTimestamp;
        if (this.debug) {
            System.out.println("Initial time taken before mining: " + initial_time);
            System.out.println("EUCS time taken before mining: " + time_EUCS);
            System.out.println("Initial merging time: " + this.merging_time);
        }
        MemoryLogger.getInstance().checkMemory();
        this.writer = new BufferedWriter(new FileWriter(outputFile));
        this.Explore_search_tree(new int[0], listOfCULLists, minUtility);
        this.writer.close();
        if (this.debug) {
            System.out.println("Closure time: " + this.closure_time);
            System.out.println("Final merging time: " + this.merging_time);
            System.out.println("#recursive calls: " + this.recursive_calls);
            System.out.println("#LA prune successful: " + this.p_laprune);
            System.out.println("#C prune + LA prune successful: " + this.p_cprune);
        }
        this.endTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
    }

    private int compareItems(int item1, int item2) {
        int compare = (int)(this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2));
        return compare == 0 ? item1 - item2 : compare;
    }

    private void Explore_search_tree(int[] prefix, ArrayList<CUL_List> ULs, long minUtility) throws IOException {
        ++this.recursive_calls;
        int i = 0;
        while (i < ULs.size()) {
            CUL_List X = ULs.get(i);
            int[] sorted_prefix = new int[prefix.length + 1];
            System.arraycopy(prefix, 0, sorted_prefix, 0, prefix.length);
            sorted_prefix[prefix.length] = X.item;
            if (X.sumNu + X.sumCu >= minUtility) {
                this.writeOut(prefix, prefix.length, X.item, X.sumNu + X.sumCu);
            }
            ++this.candidateCount;
            if (X.sumNu + X.sumCu + X.sumNru + X.sumCru >= minUtility) {
                ArrayList<CUL_List> exULs = this.ConstructCUL(X, ULs, i, minUtility, sorted_prefix.length);
                this.Explore_search_tree(sorted_prefix, exULs, minUtility);
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private ArrayList<CUL_List> ConstructCUL(CUL_List X, ArrayList<CUL_List> CULs, int st, long minutil, int length) {
        int sz;
        ArrayList<CUL_List> exCULs = new ArrayList<CUL_List>();
        ArrayList<Long> LAU = new ArrayList<Long>();
        ArrayList<Long> CUTIL = new ArrayList<Long>();
        ArrayList<Integer> ey_tid = new ArrayList<Integer>();
        int i = 0;
        while (i <= CULs.size() - 1) {
            CUL_List uList = new CUL_List(CULs.get((int)i).item);
            exCULs.add(uList);
            LAU.add(0L);
            CUTIL.add(0L);
            ey_tid.add(0);
            ++i;
        }
        int extSz = sz = CULs.size() - (st + 1);
        int j = st + 1;
        while (j <= CULs.size() - 1) {
            if (eucs_flag) {
                Map<Integer, Long> mapTWUF = this.mapFMAP.get(X.item);
                if (mapTWUF != null) {
                    Long twuF = mapTWUF.get(CULs.get((int)j).item);
                    if (twuF != null && twuF < minutil) {
                        exCULs.set(j, null);
                        extSz = sz - 1;
                    } else {
                        CUL_List uList = new CUL_List(CULs.get((int)j).item);
                        exCULs.set(j, uList);
                        ey_tid.set(j, 0);
                        LAU.set(j, X.sumCu + X.sumCru + X.sumNu + X.sumNru);
                        CUTIL.set(j, X.sumCu + X.sumCru);
                    }
                }
            } else {
                CUL_List uList = new CUL_List(CULs.get((int)j).item);
                exCULs.set(j, uList);
                ey_tid.set(j, 0);
                LAU.set(j, X.sumCu + X.sumCru + X.sumNu + X.sumNru);
                CUTIL.set(j, X.sumCu + X.sumCru);
            }
            ++j;
        }
        HashMap<ArrayList<Integer>, Integer> HT = new HashMap<ArrayList<Integer>, Integer>();
        ArrayList<Integer> newT = null;
        for (Element_CUL_List ex : X.elements) {
            newT = new ArrayList<Integer>();
            int j2 = st + 1;
            while (j2 <= CULs.size() - 1) {
                if (exCULs.get(j2) != null) {
                    List<Element_CUL_List> eylist = CULs.get((int)j2).elements;
                    while ((Integer)ey_tid.get(j2) < eylist.size() && eylist.get((int)ey_tid.get((int)j2).intValue()).tid < ex.tid) {
                        ey_tid.set(j2, ey_tid.get(j2) + 1);
                    }
                    if (ey_tid.get(j2) < eylist.size() && eylist.get((int)ey_tid.get((int)j2).intValue()).tid == ex.tid) {
                        newT.add(j2);
                    } else {
                        LAU.set(j2, (Long)LAU.get(j2) - ex.Nu - ex.Nru);
                        if ((Long)LAU.get(j2) < minutil) {
                            exCULs.set(j2, null);
                            --extSz;
                            ++this.p_laprune;
                        }
                    }
                }
                ++j2;
            }
            if (newT.size() == extSz) {
                this.temp_closure_time = System.currentTimeMillis();
                this.UpdateClosed(X, CULs, st, exCULs, newT, ex, ey_tid, length);
                this.closure_time += System.currentTimeMillis() - this.temp_closure_time;
            } else {
                Element_CUL_List element;
                Element_CUL_List Y;
                CUL_List CULListOfItem;
                int i2;
                if (newT.size() == 0) continue;
                long remainingUtility = 0L;
                if (merging_flag) {
                    if (!HT.containsKey(newT)) {
                        this.temp_merging_time = System.currentTimeMillis();
                        HT.put(newT, exCULs.get((int)newT.get((int)(newT.size() - 1)).intValue()).elements.size());
                        this.merging_time += System.currentTimeMillis() - this.temp_merging_time;
                        i2 = newT.size() - 1;
                        while (i2 >= 0) {
                            CULListOfItem = exCULs.get(newT.get(i2));
                            Y = CULs.get((int)newT.get((int)i2).intValue()).elements.get(ey_tid.get(newT.get(i2)));
                            element = new Element_CUL_List(ex.tid, ex.Nu + Y.Nu - ex.Pu, remainingUtility, ex.Nu, 0);
                            element.Ppos = i2 > 0 ? exCULs.get((int)newT.get((int)(i2 - 1)).intValue()).elements.size() : -1;
                            CULListOfItem.addElement(element);
                            remainingUtility += Y.Nu - ex.Pu;
                            --i2;
                        }
                    } else {
                        this.temp_merging_time = System.currentTimeMillis();
                        int dupPos = (Integer)HT.get(newT);
                        this.UpdateElement(X, CULs, st, exCULs, newT, ex, dupPos, ey_tid);
                        this.merging_time += System.currentTimeMillis() - this.temp_merging_time;
                    }
                } else {
                    i2 = newT.size() - 1;
                    while (i2 >= 0) {
                        CULListOfItem = exCULs.get(newT.get(i2));
                        Y = CULs.get((int)newT.get((int)i2).intValue()).elements.get(ey_tid.get(newT.get(i2)));
                        element = new Element_CUL_List(ex.tid, ex.Nu + Y.Nu - ex.Pu, remainingUtility, ex.Nu, 0);
                        element.Ppos = i2 > 0 ? exCULs.get((int)newT.get((int)(i2 - 1)).intValue()).elements.size() : -1;
                        CULListOfItem.addElement(element);
                        remainingUtility += Y.Nu - ex.Pu;
                        --i2;
                    }
                }
            }
            j2 = st + 1;
            while (j2 <= CULs.size() - 1) {
                CUTIL.set(j2, (Long)CUTIL.get(j2) + ex.Nu + ex.Nru);
                ++j2;
            }
        }
        ArrayList<CUL_List> filter_CULs = new ArrayList<CUL_List>();
        int j3 = st + 1;
        while (j3 <= CULs.size() - 1) {
            if ((Long)CUTIL.get(j3) < minutil || exCULs.get(j3) == null) {
                ++this.p_cprune;
            } else {
                if (length > 1) {
                    ((CUL_List)exCULs.get((int)j3)).sumCu += CULs.get((int)j3).sumCu + X.sumCu - X.sumCpu;
                    exCULs.get((int)j3).sumCru += CULs.get((int)j3).sumCru;
                    exCULs.get((int)j3).sumCpu += X.sumCu;
                }
                filter_CULs.add((CUL_List)exCULs.get(j3));
            }
            ++j3;
        }
        return filter_CULs;
    }

    private void UpdateClosed(CUL_List X, ArrayList<CUL_List> CULs, int st, ArrayList<CUL_List> exCULs, ArrayList<Integer> newT, Element_CUL_List ex, ArrayList<Integer> ey_tid, int length) {
        long nru = 0L;
        int j = newT.size() - 1;
        while (j >= 0) {
            CUL_List ey = CULs.get(newT.get(j));
            Element_CUL_List eyy = ey.elements.get(ey_tid.get(newT.get(j)));
            exCULs.get((int)newT.get((int)j).intValue()).sumCu += ex.Nu + eyy.Nu - ex.Pu;
            exCULs.get((int)newT.get((int)j).intValue()).sumCru += nru;
            exCULs.get((int)newT.get((int)j).intValue()).sumCpu += ex.Nu;
            nru = nru + eyy.Nu - ex.Pu;
            --j;
        }
    }

    private void UpdateElement(CUL_List X, ArrayList<CUL_List> CULs, int st, ArrayList<CUL_List> exCULs, ArrayList<Integer> newT, Element_CUL_List ex, int dupPos, ArrayList<Integer> ey_tid) {
        long nru = 0L;
        int pos = dupPos;
        int j = newT.size() - 1;
        while (j >= 0) {
            CUL_List ey = CULs.get(newT.get(j));
            Element_CUL_List eyy = ey.elements.get(ey_tid.get(newT.get(j)));
            exCULs.get((int)newT.get((int)j).intValue()).elements.get((int)pos).Nu += ex.Nu + eyy.Nu - ex.Pu;
            exCULs.get((int)newT.get((int)j).intValue()).sumNu += ex.Nu + eyy.Nu - ex.Pu;
            exCULs.get((int)newT.get((int)j).intValue()).elements.get((int)pos).Nru += nru;
            exCULs.get((int)newT.get((int)j).intValue()).sumNru += nru;
            exCULs.get((int)newT.get((int)j).intValue()).elements.get((int)pos).Pu += ex.Nu;
            nru = nru + eyy.Nu - ex.Pu;
            pos = exCULs.get((int)newT.get((int)j).intValue()).elements.get((int)pos).Ppos;
            --j;
        }
    }

    private void writeOut(int[] prefix, int prefixLength, int item, long utility) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(prefix[i]);
            buffer.append(' ');
            ++i;
        }
        buffer.append(item);
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() throws IOException {
        System.out.println("=============  HMINER ALGORITHM v.2.34 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiCount);
        System.out.println("================================================");
    }

    class Pair {
        int item = 0;
        long utility = 0L;

        Pair() {
        }

        public String toString() {
            return "[" + this.item + "," + this.utility + "]";
        }
    }
}

