/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hauim_gmu;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoHAUIM_GMU {
    int mau = 0;
    Map<Integer, Integer> mapItemToAUUB;
    List<Integer> itemLists = new ArrayList<Integer>();
    Map<Integer, ItemInfo> mapItemToItemInfo = new HashMap<Integer, ItemInfo>();
    List<Integer> maxUtilityList = new ArrayList<Integer>();
    Map<Integer, List<Integer>> mapTransactionToUtility = new HashMap<Integer, List<Integer>>();
    int minSupport = 0;
    int maxItemsetSize = 0;
    int maxTidSize = 0;
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    double HAUICount = 0.0;
    BufferedWriter writer = null;

    public void runAlgorithm(String input, String output, int threshold) throws IOException {
        block39: {
            String thisLine;
            BufferedReader myInput;
            block37: {
                this.writer = new BufferedWriter(new FileWriter(output));
                this.startTimestamp = System.currentTimeMillis();
                this.mau = threshold;
                myInput = null;
                this.mapItemToAUUB = new HashMap<Integer, Integer>();
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            String[] utilityValues = split[2].split(" ");
                            Integer MU = Integer.MIN_VALUE;
                            int i = 0;
                            while (i < utilityValues.length) {
                                if (MU < Integer.parseInt(utilityValues[i])) {
                                    MU = Integer.parseInt(utilityValues[i]);
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer auub = this.mapItemToAUUB.get(item);
                                auub = auub == null ? MU : auub + MU;
                                this.mapItemToAUUB.put(item, auub);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block37;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            this.maxItemsetSize = this.mapItemToAUUB.keySet().size();
            for (Integer item : this.mapItemToAUUB.keySet()) {
                if (this.mapItemToAUUB.get(item) < this.mau) continue;
                this.itemLists.add(item);
            }
            Collections.sort(this.itemLists);
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    int tid = 0;
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        int maxUtility = 0;
                        ArrayList<Integer> tempUtilityList = new ArrayList<Integer>();
                        int i = 0;
                        while (i < utilityValues.length) {
                            if (this.mapItemToAUUB.get(Integer.parseInt(items[i])) >= this.mau) {
                                if (this.mapItemToItemInfo.containsKey(Integer.parseInt(items[i]))) {
                                    this.mapItemToItemInfo.get((Object)Integer.valueOf((int)Integer.parseInt((String)items[i]))).tidset.set(tid);
                                    this.mapItemToItemInfo.get((Object)Integer.valueOf((int)Integer.parseInt((String)items[i]))).mapTidToUtility.put(tid, Integer.parseInt(utilityValues[i]));
                                } else {
                                    ItemInfo iteminfo = new ItemInfo();
                                    iteminfo.tidset.set(tid);
                                    iteminfo.mapTidToUtility.put(tid, Integer.parseInt(utilityValues[i]));
                                    this.mapItemToItemInfo.put(Integer.parseInt(items[i]), iteminfo);
                                }
                                tempUtilityList.add(Integer.parseInt(utilityValues[i]));
                                if (maxUtility < Integer.parseInt(utilityValues[i])) {
                                    maxUtility = Integer.parseInt(utilityValues[i]);
                                }
                            }
                            ++i;
                        }
                        this.maxUtilityList.add(maxUtility);
                        if (!tempUtilityList.isEmpty()) {
                            Collections.sort(tempUtilityList);
                            Collections.reverse(tempUtilityList);
                            ArrayList<Integer> utilityCumulationList = new ArrayList<Integer>();
                            utilityCumulationList.add((Integer)tempUtilityList.get(0));
                            int i2 = 1;
                            while (i2 < tempUtilityList.size()) {
                                utilityCumulationList.add((Integer)tempUtilityList.get(i2) + (Integer)utilityCumulationList.get(i2 - 1));
                                ++i2;
                            }
                            this.mapTransactionToUtility.put(tid, utilityCumulationList);
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block39;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.maxTidSize = this.mapTransactionToUtility.size();
        Collections.sort(this.maxUtilityList);
        Collections.reverse(this.maxUtilityList);
        int sum = 0;
        for (Integer maxUtility : this.maxUtilityList) {
            if ((sum += maxUtility.intValue()) >= this.mau) {
                ++this.minSupport;
                break;
            }
            ++this.minSupport;
        }
        int i = 0;
        while (i < this.itemLists.size()) {
            ArrayList<Integer> itemsetBuffer = new ArrayList<Integer>();
            Integer itemI = this.itemLists.get(i);
            itemsetBuffer.add(itemI);
            ItemInfo iteminfoI = this.mapItemToItemInfo.get(itemI);
            BitSet tidsetI = iteminfoI.getTidset();
            this.saveItem(itemI, tidsetI);
            ArrayList<Integer> equivalenceClassIitems = new ArrayList<Integer>();
            ArrayList<BitSet> equivalenceClassItidsets = new ArrayList<BitSet>();
            int j = i + 1;
            while (j < this.itemLists.size()) {
                int itemJ = this.itemLists.get(j);
                ItemInfo iteminfoJ = this.mapItemToItemInfo.get(itemJ);
                BitSet tidsetIJ = (BitSet)tidsetI.clone();
                tidsetIJ.and(iteminfoJ.getTidset());
                if (tidsetIJ.cardinality() >= this.minSupport) {
                    int auubIJ = 0;
                    int tid = 0;
                    while (tid < this.maxTidSize) {
                        if (tidsetIJ.get(tid)) {
                            auubIJ += this.mapTransactionToUtility.get(tid).get(1).intValue();
                        }
                        ++tid;
                    }
                    if ((auubIJ /= 2) >= this.mau) {
                        equivalenceClassIitems.add(itemJ);
                        equivalenceClassItidsets.add(tidsetIJ);
                    }
                }
                ++j;
            }
            if (equivalenceClassIitems.size() > 0) {
                this.processEquivalenceClass(itemsetBuffer, 1, equivalenceClassIitems, equivalenceClassItidsets);
            }
            ++i;
        }
        this.checkMemory();
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    private void processEquivalenceClass(List<Integer> prefix, int prefixLength, List<Integer> equivalenceClassItems, List<BitSet> equivalenceClassTidsets) throws IOException {
        if (equivalenceClassItems.size() == 1) {
            int itemI = equivalenceClassItems.get(0);
            BitSet tidsetItemset = equivalenceClassTidsets.get(0);
            this.save(prefix, itemI, tidsetItemset);
            return;
        }
        if (equivalenceClassItems.size() == 2) {
            int itemI = equivalenceClassItems.get(0);
            BitSet tidsetI = equivalenceClassTidsets.get(0);
            this.save(prefix, itemI, tidsetI);
            int itemJ = equivalenceClassItems.get(1);
            BitSet tidsetJ = equivalenceClassTidsets.get(1);
            this.save(prefix, itemJ, tidsetJ);
            if (prefixLength + 2 <= this.maxItemsetSize) {
                BitSet tidsetPIJ = (BitSet)tidsetI.clone();
                tidsetPIJ.and(tidsetJ);
                if (tidsetPIJ.cardinality() >= this.minSupport) {
                    int newPrefixLength = prefixLength + 1;
                    int auubPIJ = 0;
                    int tid = 0;
                    while (tid < this.maxTidSize) {
                        if (tidsetPIJ.get(tid)) {
                            auubPIJ += this.mapTransactionToUtility.get(tid).get(newPrefixLength).intValue();
                        }
                        ++tid;
                    }
                    if ((auubPIJ /= newPrefixLength + 1) >= this.mau) {
                        prefix.add(itemI);
                        this.save(prefix, itemJ, tidsetPIJ);
                    }
                }
            }
            return;
        }
        int i = 0;
        while (i < equivalenceClassItems.size()) {
            int suffixI = equivalenceClassItems.get(i);
            BitSet tidsetI = equivalenceClassTidsets.get(i);
            this.save(prefix, suffixI, tidsetI);
            if (prefixLength + 2 <= this.maxItemsetSize) {
                ArrayList<Integer> equivalenceClassISuffixItems = new ArrayList<Integer>();
                ArrayList<BitSet> equivalenceClassISuffixTidsets = new ArrayList<BitSet>();
                int j = i + 1;
                while (j < equivalenceClassItems.size()) {
                    int suffixJ = equivalenceClassItems.get(j);
                    BitSet tidsetIJ = (BitSet)tidsetI.clone();
                    tidsetIJ.and(equivalenceClassTidsets.get(j));
                    if (tidsetIJ.cardinality() >= this.minSupport) {
                        int auub = 0;
                        int t = 0;
                        while (t < this.maxTidSize) {
                            if (tidsetIJ.get(t)) {
                                auub += this.mapTransactionToUtility.get(t).get(prefixLength + 1).intValue();
                            }
                            ++t;
                        }
                        if ((auub /= prefixLength + 2) >= this.mau) {
                            equivalenceClassISuffixItems.add(suffixJ);
                            equivalenceClassISuffixTidsets.add(tidsetIJ);
                        }
                    }
                    ++j;
                }
                if (equivalenceClassISuffixItems.size() > 0) {
                    ArrayList<Integer> newPrefix = new ArrayList<Integer>(prefix);
                    newPrefix.add(suffixI);
                    int newPrefixLength = prefixLength + 1;
                    this.processEquivalenceClass(newPrefix, newPrefixLength, equivalenceClassISuffixItems, equivalenceClassISuffixTidsets);
                }
            }
            ++i;
        }
    }

    private void save(List<Integer> prefix, int itemI, BitSet tidsetItemset) throws IOException {
        ArrayList<Integer> candidate = new ArrayList<Integer>(prefix);
        candidate.add(itemI);
        int au = 0;
        int j = 0;
        while (j < tidsetItemset.length()) {
            if (tidsetItemset.get(j)) {
                int k = 0;
                while (k < candidate.size()) {
                    au += this.mapItemToItemInfo.get(candidate.get((int)k)).mapTidToUtility.get(j).intValue();
                    ++k;
                }
            }
            ++j;
        }
        if ((au /= candidate.size()) >= this.mau) {
            this.HAUICount += 1.0;
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < candidate.size()) {
                buffer.append(candidate.get(i));
                if (i != candidate.size() - 1) {
                    buffer.append(' ');
                }
                ++i;
            }
            buffer.append(" #AUTIL: ");
            buffer.append(au);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    private void saveItem(Integer item, BitSet tidset2) throws IOException {
        int au = 0;
        int j = 0;
        while (j < tidset2.length()) {
            if (tidset2.get(j)) {
                au += this.mapItemToItemInfo.get((Object)item).mapTidToUtility.get(j).intValue();
            }
            ++j;
        }
        if (au >= this.mau) {
            this.HAUICount += 1.0;
            StringBuffer buffer = new StringBuffer();
            buffer.append(Integer.toString(item));
            buffer.append(" #AUTIL: ");
            buffer.append(au);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    public void printStats() {
        System.out.println("=============  HAUIM-GMU ALGORITHM  v2.50 =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory: " + this.maxMemory + " MB");
        System.out.println(" HAUI count: " + this.HAUICount);
        System.out.println("===================================================");
    }

    class ItemInfo {
        BitSet tidset = new BitSet();
        Map<Integer, Integer> mapTidToUtility = new HashMap<Integer, Integer>();

        ItemInfo() {
        }

        public BitSet getTidset() {
            return this.tidset;
        }

        public void setTidset(BitSet tidset2) {
            this.tidset = tidset2;
        }
    }
}

