/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau;

import ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau.ItemsetTP;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ItemsetsTP {
    private final List<List<ItemsetTP>> levels = new ArrayList<List<ItemsetTP>>();
    private int itemsetsCount = 0;
    private String name;

    public ItemsetsTP(String name) {
        this.name = name;
        this.levels.add(new ArrayList());
    }

    public void printItemsets(Map<Integer, Integer> mutipleMinUtilities, int GLMAU) {
        System.out.println(" ------- " + this.name + " -------");
        for (List<ItemsetTP> level : this.levels) {
            for (ItemsetTP itemset2 : level) {
                itemset2.print();
                System.out.print(" #AUTIL: " + itemset2.getAUtility());
                System.out.println(" #mau: " + itemset2.getItemsetMau(mutipleMinUtilities, GLMAU));
            }
        }
        System.out.println(" --------------------------------");
    }

    public void saveResultsToFile(String output, int transactionCount, int GLMAU) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        for (List<ItemsetTP> level : this.levels) {
            for (ItemsetTP itemset2 : level) {
                writer.write(itemset2.toString());
                writer.write("#AUTIL: " + itemset2.getAUtility());
                writer.newLine();
            }
        }
        writer.close();
    }

    public void addItemset(ItemsetTP itemset2, int k) {
        while (this.levels.size() <= k) {
            this.levels.add(new ArrayList());
        }
        this.levels.get(k).add(itemset2);
        ++this.itemsetsCount;
    }

    public List<List<ItemsetTP>> getLevels() {
        return this.levels;
    }

    public int getItemsetsCount() {
        return this.itemsetsCount;
    }

    public void decreaseCount() {
        --this.itemsetsCount;
    }
}

