/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.fin_prepost;

import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class PrePost {
    long startTimestamp;
    long endTimestamp;
    int outputCount;
    BufferedWriter writer = null;
    public int[][] bf;
    public int bf_cursor;
    public int bf_size;
    public int bf_col;
    public int bf_currentSize;
    public int numOfFItem;
    public int minSupport;
    public Item[] item;
    public int[] result;
    public int resultLen;
    public int resultCount;
    public int nlLenSum;
    public PPCTreeNode ppcRoot;
    public NodeListTreeNode nlRoot;
    public PPCTreeNode[] headTable;
    public int[] headTableLen;
    public int[] itemsetCount;
    public int[] sameItems;
    public int nlNodeCount;
    public boolean usePrePostPlus = false;
    static Comparator<Item> comp = new Comparator<Item>(){

        @Override
        public int compare(Item a, Item b) {
            return b.num - a.num;
        }
    };
    private int numOfTrans;

    public void setUsePrePostPlus(boolean usePrePostPlus) {
        this.usePrePostPlus = usePrePostPlus;
    }

    public void runAlgorithm(String filename, double minsup, String output) throws IOException {
        this.outputCount = 0;
        this.nlNodeCount = 0;
        this.ppcRoot = new PPCTreeNode();
        this.nlRoot = new NodeListTreeNode();
        this.resultLen = 0;
        this.resultCount = 0;
        this.nlLenSum = 0;
        MemoryLogger.getInstance().reset();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.startTimestamp = System.currentTimeMillis();
        this.bf_size = 1000000;
        this.bf = new int[100000][];
        this.bf_currentSize = this.bf_size * 10;
        this.bf[0] = new int[this.bf_currentSize];
        this.bf_cursor = 0;
        this.bf_col = 0;
        this.getData(filename, minsup);
        this.resultLen = 0;
        this.result = new int[this.numOfFItem];
        this.buildTree(filename);
        this.nlRoot.label = this.numOfFItem;
        this.nlRoot.firstChild = null;
        this.nlRoot.next = null;
        this.initializeTree();
        this.sameItems = new int[this.numOfFItem];
        int from_cursor = this.bf_cursor;
        int from_col = this.bf_col;
        int from_size = this.bf_currentSize;
        NodeListTreeNode curNode = this.nlRoot.firstChild;
        NodeListTreeNode next = null;
        while (curNode != null) {
            next = curNode.next;
            this.traverse(curNode, this.nlRoot, 1, 0);
            int c = this.bf_col;
            while (c > from_col) {
                this.bf[c] = null;
                --c;
            }
            this.bf_col = from_col;
            this.bf_cursor = from_cursor;
            this.bf_currentSize = from_size;
            curNode = next;
        }
        this.writer.close();
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    void buildTree(String filename) throws IOException {
        String line;
        this.ppcRoot.label = -1;
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        Item[] transaction = new Item[1000];
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            int tLen = 0;
            String[] stringArray = lineSplited;
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                int itemX = Integer.parseInt(itemString);
                int j = 0;
                while (j < this.numOfFItem) {
                    if (itemX == this.item[j].index) {
                        transaction[tLen] = new Item();
                        transaction[tLen].index = itemX;
                        transaction[tLen].num = 0 - j;
                        ++tLen;
                        break;
                    }
                    ++j;
                }
                ++n2;
            }
            Arrays.sort(transaction, 0, tLen, comp);
            int curPos = 0;
            PPCTreeNode curRoot = this.ppcRoot;
            PPCTreeNode rightSibling = null;
            while (curPos != tLen) {
                PPCTreeNode child = curRoot.firstChild;
                while (child != null) {
                    if (child.label == 0 - transaction[curPos].num) {
                        ++curPos;
                        ++child.count;
                        curRoot = child;
                        break;
                    }
                    if (child.rightSibling == null) {
                        rightSibling = child;
                        child = null;
                        break;
                    }
                    child = child.rightSibling;
                }
                if (child == null) break;
            }
            int j = curPos;
            while (j < tLen) {
                PPCTreeNode ppcNode = new PPCTreeNode();
                ppcNode.label = 0 - transaction[j].num;
                if (rightSibling != null) {
                    rightSibling.rightSibling = ppcNode;
                    rightSibling = null;
                } else {
                    curRoot.firstChild = ppcNode;
                }
                ppcNode.rightSibling = null;
                ppcNode.firstChild = null;
                ppcNode.father = curRoot;
                ppcNode.labelSibling = null;
                ppcNode.count = 1;
                curRoot = ppcNode;
                ++j;
            }
        }
        reader.close();
        this.headTable = new PPCTreeNode[this.numOfFItem];
        this.headTableLen = new int[this.numOfFItem];
        PPCTreeNode[] tempHead = new PPCTreeNode[this.numOfFItem];
        this.itemsetCount = new int[(this.numOfFItem - 1) * this.numOfFItem / 2];
        PPCTreeNode root = this.ppcRoot.firstChild;
        int pre = 0;
        int last = 0;
        block6: while (root != null) {
            root.foreIndex = pre++;
            if (this.headTable[root.label] == null) {
                this.headTable[root.label] = root;
                tempHead[root.label] = root;
            } else {
                tempHead[root.label].labelSibling = root;
                tempHead[root.label] = root;
            }
            int n = root.label;
            this.headTableLen[n] = this.headTableLen[n] + 1;
            PPCTreeNode temp = root.father;
            while (temp.label != -1) {
                int n3 = root.label * (root.label - 1) / 2 + temp.label;
                this.itemsetCount[n3] = this.itemsetCount[n3] + root.count;
                temp = temp.father;
            }
            if (root.firstChild != null) {
                root = root.firstChild;
                continue;
            }
            root.backIndex = last++;
            if (root.rightSibling != null) {
                root = root.rightSibling;
                continue;
            }
            root = root.father;
            while (root != null) {
                root.backIndex = last++;
                if (root.rightSibling != null) {
                    root = root.rightSibling;
                    continue block6;
                }
                root = root.father;
            }
        }
    }

    void initializeTree() {
        NodeListTreeNode lastChild = null;
        int t = this.numOfFItem - 1;
        while (t >= 0) {
            if (this.bf_cursor > this.bf_currentSize - this.headTableLen[t] * 3) {
                ++this.bf_col;
                this.bf_cursor = 0;
                this.bf_currentSize = 10 * this.bf_size;
                this.bf[this.bf_col] = new int[this.bf_currentSize];
            }
            NodeListTreeNode nlNode = new NodeListTreeNode();
            nlNode.label = t;
            nlNode.support = 0;
            nlNode.NLStartinBf = this.bf_cursor;
            nlNode.NLLength = 0;
            nlNode.NLCol = this.bf_col;
            nlNode.firstChild = null;
            nlNode.next = null;
            PPCTreeNode ni = this.headTable[t];
            while (ni != null) {
                nlNode.support += ni.count;
                this.bf[this.bf_col][this.bf_cursor++] = ni.foreIndex;
                this.bf[this.bf_col][this.bf_cursor++] = ni.backIndex;
                this.bf[this.bf_col][this.bf_cursor++] = ni.count;
                ++nlNode.NLLength;
                ni = ni.labelSibling;
            }
            if (this.nlRoot.firstChild == null) {
                this.nlRoot.firstChild = nlNode;
                lastChild = nlNode;
            } else {
                lastChild.next = nlNode;
                lastChild = nlNode;
            }
            --t;
        }
    }

    void getData(String filename, double support) throws IOException {
        String line;
        this.numOfTrans = 0;
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            ++this.numOfTrans;
            String[] stringArray = lineSplited = line.split(" ");
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                Integer item = Integer.parseInt(itemString);
                Integer count = (Integer)mapItemCount.get(item);
                if (count == null) {
                    mapItemCount.put(item, 1);
                } else {
                    count = count + 1;
                    mapItemCount.put(item, count);
                }
                ++n2;
            }
        }
        reader.close();
        this.minSupport = (int)Math.ceil(support * (double)this.numOfTrans);
        this.numOfFItem = mapItemCount.size();
        Item[] tempItems = new Item[this.numOfFItem];
        int i = 0;
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Integer)entry.getValue() < this.minSupport) continue;
            tempItems[i] = new Item();
            tempItems[i].index = (Integer)entry.getKey();
            tempItems[i].num = (Integer)entry.getValue();
            ++i;
        }
        this.item = new Item[i];
        System.arraycopy(tempItems, 0, this.item, 0, i);
        this.numOfFItem = this.item.length;
        Arrays.sort(this.item, comp);
    }

    NodeListTreeNode iskItemSetFreq(NodeListTreeNode ni, NodeListTreeNode nj, int level, NodeListTreeNode lastChild, IntegerByRef sameCountRef) {
        if (this.bf_cursor + ni.NLLength * 3 > this.bf_currentSize) {
            ++this.bf_col;
            this.bf_cursor = 0;
            this.bf_currentSize = this.bf_size > ni.NLLength * 1000 ? this.bf_size : ni.NLLength * 1000;
            this.bf[this.bf_col] = new int[this.bf_currentSize];
        }
        NodeListTreeNode nlNode = new NodeListTreeNode();
        nlNode.support = 0;
        nlNode.NLStartinBf = this.bf_cursor;
        nlNode.NLCol = this.bf_col;
        nlNode.NLLength = 0;
        int cursor_i = ni.NLStartinBf;
        int cursor_j = nj.NLStartinBf;
        int col_i = ni.NLCol;
        int col_j = nj.NLCol;
        int last_cur = -1;
        while (cursor_i < ni.NLStartinBf + ni.NLLength * 3 && cursor_j < nj.NLStartinBf + nj.NLLength * 3) {
            if (this.bf[col_i][cursor_i] > this.bf[col_j][cursor_j] && this.bf[col_i][cursor_i + 1] < this.bf[col_j][cursor_j + 1]) {
                if (last_cur == cursor_j) {
                    int[] nArray = this.bf[this.bf_col];
                    int n = this.bf_cursor - 1;
                    nArray[n] = nArray[n] + this.bf[col_i][cursor_i + 2];
                } else {
                    this.bf[this.bf_col][this.bf_cursor++] = this.bf[col_j][cursor_j];
                    this.bf[this.bf_col][this.bf_cursor++] = this.bf[col_j][cursor_j + 1];
                    this.bf[this.bf_col][this.bf_cursor++] = this.bf[col_i][cursor_i + 2];
                    ++nlNode.NLLength;
                }
                nlNode.support += this.bf[col_i][cursor_i + 2];
                last_cur = cursor_j;
                cursor_i += 3;
                continue;
            }
            if (this.bf[col_i][cursor_i] < this.bf[col_j][cursor_j]) {
                cursor_i += 3;
                continue;
            }
            if (this.bf[col_i][cursor_i + 1] <= this.bf[col_j][cursor_j + 1]) continue;
            cursor_j += 3;
        }
        if (nlNode.support >= this.minSupport) {
            if (ni.support == nlNode.support && (this.usePrePostPlus || nlNode.NLLength == 1)) {
                this.sameItems[sameCountRef.count++] = nj.label;
                this.bf_cursor = nlNode.NLStartinBf;
                if (nlNode != null) {
                    nlNode = null;
                }
            } else {
                nlNode.label = nj.label;
                nlNode.firstChild = null;
                nlNode.next = null;
                if (ni.firstChild == null) {
                    ni.firstChild = nlNode;
                    lastChild = nlNode;
                } else {
                    lastChild.next = nlNode;
                    lastChild = nlNode;
                }
            }
            return lastChild;
        }
        this.bf_cursor = nlNode.NLStartinBf;
        if (nlNode != null) {
            nlNode = null;
        }
        return lastChild;
    }

    public void traverse(NodeListTreeNode curNode, NodeListTreeNode curRoot, int level, int sameCount) throws IOException {
        MemoryLogger.getInstance().checkMemory();
        NodeListTreeNode sibling = curNode.next;
        NodeListTreeNode lastChild = null;
        while (sibling != null) {
            if (level > 1 || level == 1 && this.itemsetCount[(curNode.label - 1) * curNode.label / 2 + sibling.label] >= this.minSupport) {
                IntegerByRef sameCountTemp = new IntegerByRef();
                sameCountTemp.count = sameCount;
                lastChild = this.iskItemSetFreq(curNode, sibling, level, lastChild, sameCountTemp);
                sameCount = sameCountTemp.count;
            }
            sibling = sibling.next;
        }
        this.resultCount = (int)((double)this.resultCount + Math.pow(2.0, sameCount));
        this.nlLenSum = (int)((double)this.nlLenSum + Math.pow(2.0, sameCount) * (double)curNode.NLLength);
        this.result[this.resultLen++] = curNode.label;
        this.writeItemsetsToFile(curNode, sameCount);
        ++this.nlNodeCount;
        int from_cursor = this.bf_cursor;
        int from_col = this.bf_col;
        int from_size = this.bf_currentSize;
        NodeListTreeNode child = curNode.firstChild;
        NodeListTreeNode next = null;
        while (child != null) {
            next = child.next;
            this.traverse(child, curNode, level + 1, sameCount);
            int c = this.bf_col;
            while (c > from_col) {
                this.bf[c] = null;
                --c;
            }
            this.bf_col = from_col;
            this.bf_cursor = from_cursor;
            this.bf_currentSize = from_size;
            child = next;
        }
        --this.resultLen;
    }

    private void writeItemsetsToFile(NodeListTreeNode curNode, int sameCount) throws IOException {
        StringBuilder buffer = new StringBuilder();
        if (curNode.support >= this.minSupport) {
            ++this.outputCount;
            int i = 0;
            while (i < this.resultLen) {
                buffer.append(this.item[this.result[i]].index);
                buffer.append(' ');
                ++i;
            }
            buffer.append("#SUP: ");
            buffer.append(curNode.support);
            buffer.append("\n");
        }
        if (sameCount > 0) {
            long i = 1L;
            long max = 1 << sameCount;
            while (i < max) {
                int k = 0;
                while (k < this.resultLen) {
                    buffer.append(this.item[this.result[k]].index);
                    buffer.append(' ');
                    ++k;
                }
                int j = 0;
                while (j < sameCount) {
                    int isSet = (int)i & 1 << j;
                    if (isSet > 0) {
                        buffer.append(this.item[this.sameItems[j]].index);
                        buffer.append(' ');
                    }
                    ++j;
                }
                buffer.append("#SUP: ");
                buffer.append(curNode.support);
                buffer.append("\n");
                ++this.outputCount;
                ++i;
            }
        }
        this.writer.write(buffer.toString());
    }

    public void printStats() {
        String prePost = this.usePrePostPlus ? "PrePost+" : "PrePost";
        System.out.println("========== " + prePost + " - STATS ============");
        System.out.println(" Minsup = " + this.minSupport + "\n Number of transactions: " + this.numOfTrans);
        System.out.println(" Number of frequent  itemsets: " + this.outputCount);
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("=====================================");
    }

    class IntegerByRef {
        int count;

        IntegerByRef() {
        }
    }

    class Item {
        public int index;
        public int num;

        Item() {
        }
    }

    class NodeListTreeNode {
        public int label;
        public NodeListTreeNode firstChild;
        public NodeListTreeNode next;
        public int support;
        public int NLStartinBf;
        public int NLLength;
        public int NLCol;

        NodeListTreeNode() {
        }
    }

    class PPCTreeNode {
        public int label;
        public PPCTreeNode firstChild;
        public PPCTreeNode rightSibling;
        public PPCTreeNode labelSibling;
        public PPCTreeNode father;
        public int count;
        public int foreIndex;
        public int backIndex;

        PPCTreeNode() {
        }
    }
}

