/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer;

import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.QItemTrans;
import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.Qitem;
import java.util.ArrayList;

public class UtilityListFHUQIMiner {
    private ArrayList<Qitem> itemsetName;
    private long sumIutils;
    private long sumRutils;
    private long twu;
    private ArrayList<QItemTrans> qItemTrans = null;

    public UtilityListFHUQIMiner(ArrayList<Qitem> qitemset, long twu) {
        this.itemsetName = new ArrayList();
        this.itemsetName = qitemset;
        this.sumIutils = 0L;
        this.sumRutils = 0L;
        this.twu = twu;
        this.qItemTrans = new ArrayList();
    }

    public UtilityListFHUQIMiner(ArrayList<Qitem> qitemset) {
        this.itemsetName = new ArrayList();
        this.itemsetName = qitemset;
        this.sumIutils = 0L;
        this.sumRutils = 0L;
        this.twu = 0L;
        this.qItemTrans = new ArrayList();
    }

    public UtilityListFHUQIMiner(Qitem name) {
        this.itemsetName = new ArrayList();
        this.itemsetName.add(name);
        this.sumIutils = 0L;
        this.sumRutils = 0L;
        this.twu = 0L;
        this.qItemTrans = new ArrayList();
    }

    public UtilityListFHUQIMiner(Qitem name, long twu) {
        this.itemsetName = new ArrayList();
        this.itemsetName.add(name);
        this.sumIutils = 0L;
        this.sumRutils = 0L;
        this.twu = twu;
        this.qItemTrans = new ArrayList();
    }

    public UtilityListFHUQIMiner() {
    }

    public void addTWU(int twu) {
        this.twu += (long)twu;
    }

    public void setTWUtoZero() {
        this.twu = 0L;
    }

    public void addTrans(QItemTrans qTid, long twu) {
        this.sumIutils += (long)qTid.getEu();
        this.sumRutils += (long)qTid.getRu();
        this.qItemTrans.add(qTid);
        this.twu += twu;
    }

    public void addTrans(QItemTrans qTid) {
        this.sumIutils += (long)qTid.getEu();
        this.sumRutils += (long)qTid.getRu();
        this.qItemTrans.add(qTid);
    }

    public long getSumIutils() {
        return this.sumIutils;
    }

    public long getSumRutils() {
        return this.sumRutils;
    }

    public void setSumIutils(long x) {
        this.sumIutils = x;
    }

    public void setSumRutils(long x) {
        this.sumRutils = x;
    }

    public long getTwu() {
        return this.twu;
    }

    public void setTwu(long twu) {
        this.twu = twu;
    }

    public ArrayList<Qitem> getItemsetName() {
        return this.itemsetName;
    }

    public Qitem getSingleItemsetName() {
        return this.itemsetName.get(0);
    }

    public ArrayList<QItemTrans> getQItemTrans() {
        return this.qItemTrans;
    }

    public void setQItemTrans(ArrayList<QItemTrans> elements) {
        this.qItemTrans = elements;
    }

    public QItemTrans QitemTransAdd(QItemTrans a, QItemTrans b) {
        QItemTrans x = new QItemTrans(a.getTid(), a.getEu() + b.getEu(), a.getRu() + b.getRu());
        return x;
    }

    public void addUtilityList2(UtilityListFHUQIMiner next) {
        ArrayList<QItemTrans> temp = next.getQItemTrans();
        ArrayList<QItemTrans> mainlist = new ArrayList<QItemTrans>();
        this.sumIutils += next.getSumIutils();
        this.sumRutils += next.getSumRutils();
        this.twu += next.getTwu();
        if (this.qItemTrans.size() == 0) {
            int k = 0;
            while (k < temp.size()) {
                this.qItemTrans.add(temp.get(k));
                ++k;
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < this.qItemTrans.size() && j < temp.size()) {
                int t2;
                int t1 = this.qItemTrans.get(i).getTid();
                if (t1 > (t2 = temp.get(j).getTid())) {
                    mainlist.add(temp.get(j));
                    ++j;
                    continue;
                }
                if (t1 < t2) {
                    mainlist.add(this.qItemTrans.get(i));
                    ++i;
                    continue;
                }
                mainlist.add(t1, this.QitemTransAdd(this.qItemTrans.get(i), temp.get(j)));
            }
            if (i == this.qItemTrans.size()) {
                while (j < temp.size()) {
                    mainlist.add(temp.get(j++));
                }
            } else if (j == temp.size()) {
                while (i < this.qItemTrans.size()) {
                    mainlist.add(this.qItemTrans.get(i++));
                }
            }
            this.qItemTrans.clear();
            this.qItemTrans = mainlist;
        }
    }

    public String toString() {
        String str = "\n=================================\n";
        str = String.valueOf(str) + this.itemsetName + "\r\n";
        str = String.valueOf(str) + "sumEU=" + this.sumIutils + " sumRU=" + this.sumRutils + " twu=" + this.twu + "\r\n";
        int i = 0;
        while (i < this.qItemTrans.size()) {
            str = String.valueOf(str) + this.qItemTrans.get(i).toString() + "\r\n";
            ++i;
        }
        str = String.valueOf(str) + "=================================\n";
        return str;
    }

    public int getqItemTransLength() {
        if (this.qItemTrans == null) {
            return 0;
        }
        return this.qItemTrans.size();
    }
}

