/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.ffi_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.ffi_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.ffi_miner.FFIList;
import ca.pfv.spmf.algorithms.frequentpatterns.ffi_miner.Regions;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoFFIMiner {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int FFICount = 0;
    Map<Integer, Float> mapItemLowSUM;
    Map<Integer, Float> mapItemMiddleSUM;
    Map<Integer, Float> mapItemHighSUM;
    Map<Integer, Float> mapItemSUM;
    Map<Integer, String> mapItemRegion;
    BufferedWriter writer = null;
    private int joinCount;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;

    public void runAlgorithm(String input, String output, float minSupport) throws IOException {
        ArrayList<FFIList> listOfFFILists;
        block41: {
            float high;
            String thisLine;
            BufferedReader myInput;
            block39: {
                MemoryLogger.getInstance().reset();
                this.itemsetBuffer = new int[200];
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemLowSUM = new HashMap<Integer, Float>();
                this.mapItemMiddleSUM = new HashMap<Integer, Float>();
                this.mapItemHighSUM = new HashMap<Integer, Float>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            String[] quanaities = split[2].split(" ");
                            int i = 0;
                            while (i < items.length) {
                                Regions regions = new Regions(Integer.parseInt(quanaities[i]), 3);
                                Integer item = Integer.parseInt(items[i]);
                                if (this.mapItemLowSUM.containsKey(item)) {
                                    float low = this.mapItemLowSUM.get(item).floatValue();
                                    this.mapItemLowSUM.put(item, Float.valueOf(low += regions.low));
                                } else {
                                    this.mapItemLowSUM.put(item, Float.valueOf(regions.low));
                                }
                                if (this.mapItemMiddleSUM.containsKey(item)) {
                                    float middle = this.mapItemMiddleSUM.get(item).floatValue();
                                    this.mapItemMiddleSUM.put(item, Float.valueOf(middle += regions.middle));
                                } else {
                                    this.mapItemMiddleSUM.put(item, Float.valueOf(regions.middle));
                                }
                                if (this.mapItemHighSUM.containsKey(item)) {
                                    high = this.mapItemHighSUM.get(item).floatValue();
                                    this.mapItemHighSUM.put(item, Float.valueOf(high += regions.high));
                                } else {
                                    this.mapItemHighSUM.put(item, Float.valueOf(regions.high));
                                }
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block39;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            listOfFFILists = new ArrayList<FFIList>();
            HashMap<Integer, FFIList> mapItemToFFIList = new HashMap<Integer, FFIList>();
            this.mapItemSUM = new HashMap<Integer, Float>();
            this.mapItemRegion = new HashMap<Integer, String>();
            for (Integer item : this.mapItemLowSUM.keySet()) {
                float low = this.mapItemLowSUM.get(item).floatValue();
                float middle = this.mapItemMiddleSUM.get(item).floatValue();
                high = this.mapItemHighSUM.get(item).floatValue();
                if (low >= middle && low >= high) {
                    this.mapItemSUM.put(item, Float.valueOf(low));
                    this.mapItemRegion.put(item, "L");
                } else if (middle >= low && middle >= high) {
                    this.mapItemSUM.put(item, Float.valueOf(middle));
                    this.mapItemRegion.put(item, "M");
                } else if (high >= low && high >= middle) {
                    this.mapItemSUM.put(item, Float.valueOf(high));
                    this.mapItemRegion.put(item, "H");
                }
                if (!(this.mapItemSUM.get(item).floatValue() >= minSupport)) continue;
                FFIList fuList = new FFIList(item);
                mapItemToFFIList.put(item, fuList);
                listOfFFILists.add(fuList);
            }
            Collections.sort(listOfFFILists, new Comparator<FFIList>(){

                @Override
                public int compare(FFIList o1, FFIList o2) {
                    return (int)AlgoFFIMiner.this.compareItems(o1.item, o2.item);
                }
            });
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    int tid = 0;
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] quanaities = split[2].split(" ");
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        int i = 0;
                        while (i < items.length) {
                            Pair pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            Regions regions = new Regions(Integer.parseInt(quanaities[i]), 3);
                            if (this.mapItemSUM.get(pair.item).floatValue() >= minSupport) {
                                if (this.mapItemRegion.get(pair.item).equals("L")) {
                                    pair.quantity = regions.low;
                                } else if (this.mapItemRegion.get(pair.item).equals("M")) {
                                    pair.quantity = regions.middle;
                                } else if (this.mapItemRegion.get(pair.item).equals("H")) {
                                    pair.quantity = regions.high;
                                }
                                if (pair.quantity > 0.0f) {
                                    revisedTransaction.add(pair);
                                }
                            }
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Pair>(){

                            @Override
                            public int compare(Pair o1, Pair o2) {
                                return (int)AlgoFFIMiner.this.compareItems(o1.item, o2.item);
                            }
                        });
                        float remainingUtility = -2.1474836E9f;
                        int i2 = revisedTransaction.size() - 1;
                        while (i2 >= 0) {
                            Pair pair = (Pair)revisedTransaction.get(i2);
                            remainingUtility = pair.quantity > remainingUtility ? pair.quantity : remainingUtility;
                            FFIList FFIListOfItem = (FFIList)mapItemToFFIList.get(pair.item);
                            Element element = new Element(tid, pair.quantity, remainingUtility);
                            FFIListOfItem.addElement(element);
                            --i2;
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block41;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.FFIMiner(this.itemsetBuffer, 0, listOfFFILists, minSupport);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private float compareItems(int item1, int item2) {
        float compare = this.mapItemSUM.get(item1).floatValue() - this.mapItemSUM.get(item2).floatValue();
        return compare == 0.0f ? (float)(item1 - item2) : compare;
    }

    private void FFIMiner(int[] prefix, int prefixLength, List<FFIList> FFILs, float minSupport) throws IOException {
        int i = 0;
        while (i < FFILs.size()) {
            FFIList X = FFILs.get(i);
            if (X.sumIutils >= minSupport) {
                this.writeOut(prefix, prefixLength, X.item, X.sumIutils);
            }
            if (X.sumRutils >= minSupport) {
                ArrayList<FFIList> exULs = new ArrayList<FFIList>();
                int j = i + 1;
                while (j < FFILs.size()) {
                    FFIList Y = FFILs.get(j);
                    exULs.add(this.construct(X, Y));
                    ++this.joinCount;
                    ++j;
                }
                this.itemsetBuffer[prefixLength] = X.item;
                this.FFIMiner(this.itemsetBuffer, prefixLength + 1, exULs, minSupport);
            }
            ++i;
        }
    }

    private FFIList construct(FFIList px, FFIList py) {
        FFIList pxyUL = new FFIList(py.item);
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) continue;
            Element eXY = new Element(ex.tid, Float.min(ex.iutils, ey.iutils), ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(FFIList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, int item, float sumIutils) throws IOException {
        ++this.FFICount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(String.valueOf(prefix[i]) + "." + this.mapItemRegion.get(prefix[i]));
            buffer.append(' ');
            ++i;
        }
        buffer.append(String.valueOf(item) + "." + this.mapItemRegion.get(item));
        buffer.append(" #FVL: ");
        buffer.append(sumIutils);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("=============  FFI-MINER ALGORITHM v.2.15 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" FFI count : " + this.FFICount);
        System.out.println(" Join count : " + this.joinCount);
        System.out.println("===================================================");
    }

    class Pair {
        int item = 0;
        float quantity = 0.0f;

        Pair() {
        }
    }
}

