/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.feacp;

import ca.pfv.spmf.algorithms.frequentpatterns.feacp.AlgoFEACP;
import ca.pfv.spmf.algorithms.frequentpatterns.feacp.TaxonomyNode;
import ca.pfv.spmf.algorithms.frequentpatterns.feacp.TaxonomyTree;
import java.util.HashMap;
import java.util.Map;

public class Transaction {
    public static int[] tempItems = new int[2000];
    public static double[] tempUtilities = new double[2000];
    int offset;
    int[] items;
    double[] utilities;
    double transactionUtility;
    double OldTU;
    double prefixUtility;
    public Map<Integer, Double> parentsInTransaction = new HashMap<Integer, Double>();

    public Transaction(int[] items, double[] utilities, double transactionUtility) {
        this.items = items;
        this.utilities = utilities;
        this.transactionUtility = transactionUtility;
        this.prefixUtility = 0.0;
        this.offset = 0;
        this.OldTU = transactionUtility;
    }

    public Transaction(Transaction transaction, int itemE, int[] newNamesToOldNames, TaxonomyTree taxonomy) {
        this.OldTU = transaction.OldTU;
        double newTU = transaction.getUtility();
        double utilityE = 0.0;
        int newSize = 0;
        int i = 0;
        while (i < transaction.getItems().length) {
            int item = transaction.getItems()[i];
            if (item < itemE) {
                newTU -= transaction.getUtilities()[i];
            } else if (item == itemE) {
                newTU -= transaction.getUtilities()[i];
                utilityE = transaction.getUtilities()[i];
            } else {
                Transaction.tempItems[newSize] = transaction.getItems()[i];
                Transaction.tempUtilities[newSize] = transaction.getUtilities()[i];
                ++newSize;
            }
            ++i;
        }
        this.items = new int[newSize];
        System.arraycopy(tempItems, 0, this.items, 0, newSize);
        this.utilities = new double[newSize];
        System.arraycopy(tempUtilities, 0, this.utilities, 0, newSize);
        this.prefixUtility = transaction.prefixUtility + utilityE;
        this.transactionUtility = newTU;
        this.parentsInTransaction = new HashMap<Integer, Double>();
        long initialTime = System.currentTimeMillis();
        for (Map.Entry<Integer, Double> entry : transaction.parentsInTransaction.entrySet()) {
            if (itemE >= entry.getKey() || this.CheckParent(newNamesToOldNames[entry.getKey()], newNamesToOldNames[itemE], taxonomy)) continue;
            this.parentsInTransaction.put(entry.getKey(), entry.getValue());
        }
        long endTime = System.currentTimeMillis();
        AlgoFEACP.timeProject += endTime - initialTime;
    }

    public Transaction(Transaction transaction, int ParentItem, TaxonomyTree taxonomy, int[] newNamesToOldNames) {
        this.OldTU = transaction.OldTU;
        double newTU = transaction.getUtility();
        int newSize = 0;
        int i = 0;
        while (i < transaction.getItems().length) {
            int item = transaction.getItems()[i];
            if (!this.CheckParent(newNamesToOldNames[item], newNamesToOldNames[ParentItem], taxonomy)) {
                if (ParentItem > item) {
                    newTU -= transaction.getUtilities()[i];
                } else {
                    Transaction.tempItems[newSize] = transaction.getItems()[i];
                    Transaction.tempUtilities[newSize] = transaction.getUtilities()[i];
                    ++newSize;
                }
            }
            ++i;
        }
        this.items = new int[newSize];
        System.arraycopy(tempItems, 0, this.items, 0, newSize);
        this.utilities = new double[newSize];
        System.arraycopy(tempUtilities, 0, this.utilities, 0, newSize);
        double utilityofParent = transaction.parentsInTransaction.get(ParentItem);
        this.prefixUtility = transaction.prefixUtility + utilityofParent;
        this.transactionUtility = newTU -= utilityofParent;
        this.parentsInTransaction = new HashMap<Integer, Double>();
        long start = System.currentTimeMillis();
        for (Map.Entry<Integer, Double> entry : transaction.parentsInTransaction.entrySet()) {
            Integer item = entry.getKey();
            if (ParentItem >= item || this.CheckParent(newNamesToOldNames[item], newNamesToOldNames[ParentItem], taxonomy)) continue;
            this.parentsInTransaction.put(item, entry.getValue());
        }
        long end = System.currentTimeMillis();
        AlgoFEACP.timeProject += end - start;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.items.length) {
            buffer.append(this.items[i]);
            buffer.append("[");
            buffer.append(this.utilities[i]);
            buffer.append("] ");
            ++i;
        }
        buffer.append(" Remaining Utility:" + this.transactionUtility);
        buffer.append(" Prefix Utility:" + this.prefixUtility);
        return buffer.toString();
    }

    public String toStringShort() {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.items.length) {
            buffer.append(this.items[i]);
            buffer.append("[");
            buffer.append(this.utilities[i]);
            buffer.append("] ");
            ++i;
        }
        return buffer.toString();
    }

    public String toStringCompact() {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.items.length) {
            buffer.append(this.items[i]);
            buffer.append(" ");
            ++i;
        }
        return buffer.toString();
    }

    public int[] getItems() {
        return this.items;
    }

    public double[] getUtilities() {
        return this.utilities;
    }

    public int getLastPosition() {
        return this.items.length - 1;
    }

    public void removeUnpromisingItems(int[] oldNamesToNewNames, TaxonomyTree taxonomy) {
        int i = 0;
        int newTU = 0;
        int j = 0;
        while (j < this.items.length) {
            int item = this.items[j];
            double utility = this.utilities[j];
            TaxonomyNode nodeParent = taxonomy.getMapItemToTaxonomyNode().get(item).getParent();
            while (nodeParent.getData() != -1) {
                int newNameParent = oldNamesToNewNames[nodeParent.getData()];
                if (newNameParent != 0) {
                    Double UtitilityOfParent = this.parentsInTransaction.get(newNameParent);
                    if (UtitilityOfParent == null) {
                        this.parentsInTransaction.put(newNameParent, utility);
                    } else {
                        this.parentsInTransaction.put(newNameParent, UtitilityOfParent + utility);
                    }
                }
                nodeParent = nodeParent.getParent();
            }
            int newName = oldNamesToNewNames[item];
            if (newName != 0) {
                Transaction.tempItems[i] = newName;
                Transaction.tempUtilities[i] = this.utilities[j];
                ++i;
                newTU = (int)((double)newTU + this.utilities[j]);
            }
            ++j;
        }
        this.transactionUtility = this.OldTU;
        this.items = new int[i];
        System.arraycopy(tempItems, 0, this.items, 0, i);
        this.utilities = new double[i];
        System.arraycopy(tempUtilities, 0, this.utilities, 0, i);
        Transaction.insertionSort(this.items, this.utilities);
    }

    public static void insertionSort(int[] items, double[] utitilies) {
        int j = 1;
        while (j < items.length) {
            int itemJ = items[j];
            double utilityJ = utitilies[j];
            int i = j - 1;
            while (i >= 0 && items[i] > itemJ) {
                items[i + 1] = items[i];
                utitilies[i + 1] = utitilies[i];
                --i;
            }
            items[i + 1] = itemJ;
            utitilies[i + 1] = utilityJ;
            ++j;
        }
    }

    public double getUtility() {
        return this.transactionUtility;
    }

    private boolean CheckParent(int item1, int item2, TaxonomyTree taxonomy) {
        int levelOfItem2;
        TaxonomyNode nodeItem1 = taxonomy.getMapItemToTaxonomyNode().get(item1);
        TaxonomyNode nodeItem2 = taxonomy.getMapItemToTaxonomyNode().get(item2);
        int levelOfItem1 = nodeItem1.getLevel();
        if (levelOfItem1 == (levelOfItem2 = nodeItem2.getLevel())) {
            return false;
        }
        if (levelOfItem1 > levelOfItem2) {
            TaxonomyNode parentItem1 = nodeItem1.getParent();
            while (parentItem1.getData() != -1) {
                if (parentItem1.getData() == nodeItem2.getData()) {
                    return true;
                }
                parentItem1 = parentItem1.getParent();
            }
            return false;
        }
        TaxonomyNode parentItem2 = nodeItem2.getParent();
        while (parentItem2.getData() != -1) {
            if (parentItem2.getData() == nodeItem1.getData()) {
                return true;
            }
            parentItem2 = parentItem2.getParent();
        }
        return false;
    }
}

