/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.feacp;

import ca.pfv.spmf.algorithms.frequentpatterns.feacp.TaxonomyNode;
import ca.pfv.spmf.algorithms.frequentpatterns.feacp.TaxonomyTree;
import ca.pfv.spmf.algorithms.frequentpatterns.feacp.Transaction;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Dataset {
    List<Transaction> transactions = new ArrayList<Transaction>();
    long totalUtility = 0L;
    TaxonomyTree taxonomy;
    private int maxItem = 0;

    public Dataset(String datasetPath, int maximumTransactionCount, String TaxonomyPath) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(datasetPath));
        int i = 0;
        this.taxonomy = new TaxonomyTree();
        this.taxonomy.ReadDataFromPath(TaxonomyPath);
        this.maxItem = this.taxonomy.MaxItem;
        while ((line = br.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            Transaction t = this.createTransaction(line);
            this.totalUtility = (long)((double)this.totalUtility + t.getUtility());
            this.transactions.add(t);
            if (++i == maximumTransactionCount) break;
        }
        br.close();
    }

    private Transaction createTransaction(String line) {
        String[] split = line.split(":");
        double transactionUtility = Double.parseDouble(split[1]);
        String[] itemsString = split[0].split(" ");
        String[] itemsUtilitiesString = split[2].split(" ");
        int[] items = new int[itemsString.length];
        double[] utilities = new double[itemsString.length];
        int i = 0;
        while (i < items.length) {
            items[i] = Integer.parseInt(itemsString[i]);
            Integer item = items[i];
            utilities[i] = Double.parseDouble(itemsUtilitiesString[i]);
            if (items[i] > this.maxItem) {
                this.maxItem = items[i];
            }
            if (this.taxonomy.mapItemToTaxonomyNode.get(item) == null) {
                TaxonomyNode newNode = new TaxonomyNode(item);
                this.taxonomy.mapItemToTaxonomyNode.get(-1).addChildren(newNode);
                this.taxonomy.mapItemToTaxonomyNode.put(item, newNode);
            } else {
                TaxonomyNode parentNode = this.taxonomy.mapItemToTaxonomyNode.get(item).getParent();
                while (parentNode.getData() != -1) {
                    parentNode = parentNode.getParent();
                }
            }
            ++i;
        }
        return new Transaction(items, utilities, transactionUtility);
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public int getMaxItem() {
        return this.maxItem;
    }

    public String toString() {
        StringBuilder datasetContent = new StringBuilder();
        for (Transaction transaction : this.transactions) {
            datasetContent.append(transaction.toString());
            datasetContent.append("\n");
        }
        return datasetContent.toString();
    }

    public long getTotalUtility() {
        return this.totalUtility;
    }
}

