/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.estDec;

import ca.pfv.spmf.algorithms.frequentpatterns.estDec.ParentNode;
import java.util.ArrayList;
import java.util.List;

public class CPTreeNode {
    List<Integer> itemIDList = new ArrayList<Integer>();
    List<ParentNode> parents;
    double counter1;
    double counter2;
    List<CPTreeNode> children;

    CPTreeNode(Integer item, CPTreeNode parent, short parentInd, double count) {
        this.itemIDList.add(item);
        this.parents = new ArrayList<ParentNode>();
        this.parents.add(new ParentNode(parent, parentInd));
        this.counter1 = count;
        this.counter2 = count;
        this.children = new ArrayList<CPTreeNode>();
    }

    CPTreeNode() {
        this.parents = new ArrayList<ParentNode>();
        this.counter1 = 1.0;
        this.counter2 = 1.0;
        this.children = new ArrayList<CPTreeNode>();
    }

    public short getInnerIndexWithID(int id, CPTreeNode parentNode, short parentInd) {
        short i = (short)(parentInd + 1);
        while (i < this.itemIDList.size()) {
            if (this.itemIDList.get(i) == id && this.parents.get((int)i).pNode == parentNode && this.parents.get((int)i).pInd == parentInd) {
                return i;
            }
            i = (short)(i + 1);
        }
        return -1;
    }

    public CPTreeNode getChildWithID(int id, int q) {
        if (this.children == null) {
            return null;
        }
        for (CPTreeNode child : this.children) {
            if (child.itemIDList.get(0) != id || child.parents.get((int)0).pInd != q) continue;
            return child;
        }
        return null;
    }

    public int getLevel(int j) {
        int level = 0;
        while (true) {
            ++level;
            if (j == 0) break;
            j = this.parents.get((int)j).pInd;
        }
        return level;
    }

    public int getLongestLevel() {
        int level = 1;
        ArrayList<Integer> p = new ArrayList<Integer>();
        p.add(0);
        while (p.size() != 0) {
            ++level;
            ArrayList<Integer> p2 = new ArrayList<Integer>();
            int j = 1;
            while (j < this.itemIDList.size()) {
                short x = this.parents.get((int)j).pInd;
                if (p.contains(x)) {
                    p2.add(j);
                }
                ++j;
            }
            p = p2;
        }
        return level - 1;
    }

    public Boolean isLeafLevel(int id) {
        int i = id + 1;
        while (i < this.itemIDList.size()) {
            if (this.parents.get((int)i).pNode == this && this.parents.get((int)i).pInd == id) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void update(double d) {
        this.counter1 = this.counter1 * d + 1.0;
    }

    public double computeSupport(double N, int level) {
        int maxL = this.getLongestLevel();
        return this.estimateMergeCount(level, maxL) / N;
    }

    public double estimateMergeCount(int level, int longestL) {
        if (level == 1) {
            return this.counter1;
        }
        if (level == longestL) {
            return this.counter2;
        }
        double x = 0.0;
        int l = 1;
        while (l <= longestL - 1) {
            x += 1.0 / (double)l;
            ++l;
        }
        double s = 0.0;
        int l2 = 1;
        while (l2 <= level - 1) {
            s += 1.0 / (double)l2;
            ++l2;
        }
        return this.counter1 - (this.counter1 - this.counter2) * s / x;
    }

    public String toString(String indent) {
        StringBuilder output = new StringBuilder();
        output.append("ID=" + super.toString());
        output.append(" Counter1=" + this.counter1);
        output.append(" Counter2=" + this.counter2);
        output.append(" ItemIDList=");
        for (Integer item : this.itemIDList) {
            output.append(item + ",");
        }
        output.append(" Parents=");
        for (ParentNode parent : this.parents) {
            output.append("(pind=" + parent.pInd + ",node=" + parent.pNode.toString() + ")");
        }
        output.append("\n");
        String newIndent = String.valueOf(indent) + "   ";
        for (CPTreeNode child : this.children) {
            output.append(String.valueOf(newIndent) + child.toString(newIndent));
        }
        return output.toString();
    }
}

