/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.dci_closed_optimized;

import java.util.BitSet;

public class BitMatrix {
    private BitSet[] matrixItemTIDs;
    private int[] support1item;

    BitMatrix(int itemCount, int transactionCount) {
        this.support1item = new int[itemCount];
        this.matrixItemTIDs = new BitSet[itemCount];
        int i = 0;
        while (i < this.matrixItemTIDs.length) {
            this.matrixItemTIDs[i] = new BitSet(transactionCount);
            ++i;
        }
    }

    public void addTidForItem(Integer item, int bit) {
        this.matrixItemTIDs[item - 1].set(bit, true);
    }

    public int getSupportOfItemFirstTime(int i) {
        this.support1item[i - 1] = this.matrixItemTIDs[i - 1].cardinality();
        return this.support1item[i - 1];
    }

    public int getSupportOfItem(int i) {
        return this.support1item[i - 1];
    }

    public BitSet getBitSetOf(Integer i) {
        return this.matrixItemTIDs[i - 1];
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        BitSet[] bitSetArray = this.matrixItemTIDs;
        int n = this.matrixItemTIDs.length;
        int n2 = 0;
        while (n2 < n) {
            BitSet bitset = bitSetArray[n2];
            buffer.append(bitset.toString());
            ++n2;
        }
        return buffer.toString();
    }
}

