/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.cori;

import ca.pfv.spmf.algorithms.frequentpatterns.cori.ItemsetCORI;
import ca.pfv.spmf.algorithms.frequentpatterns.cori.ItemsetsCORI;
import ca.pfv.spmf.datastructures.triangularmatrix.TriangularMatrix;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoCORI {
    private int minsupRelative;
    private double minBond;
    protected TransactionDatabase database;
    protected long startTimestamp;
    protected long endTime;
    protected ItemsetsCORI frequentItemsets;
    BufferedWriter writer = null;
    protected int itemsetCount;
    private TriangularMatrix matrix;
    final int BUFFERS_SIZE = 2000;
    private int[] itemsetBuffer = null;
    boolean showTransactionIdentifiers = false;
    int maxItemsetSize = Integer.MAX_VALUE;

    public ItemsetsCORI runAlgorithm(String output, TransactionDatabase database, double minsupp, double minBond, boolean useTriangularMatrixOptimization) throws IOException {
        this.itemsetBuffer = new int[2000];
        MemoryLogger.getInstance().reset();
        if (output == null) {
            this.writer = null;
            this.frequentItemsets = new ItemsetsCORI("CORRELATED ITEMSETS");
        } else {
            this.frequentItemsets = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.itemsetCount = 0;
        this.database = database;
        this.startTimestamp = System.currentTimeMillis();
        this.minsupRelative = (int)Math.ceil(minsupp * (double)database.size());
        this.minBond = minBond;
        final HashMap<Integer, BitSetSupport> mapItemTIDS = new HashMap<Integer, BitSetSupport>();
        int maxItemId = this.calculateSupportSingleItems(database, mapItemTIDS);
        if (useTriangularMatrixOptimization && this.maxItemsetSize >= 1) {
            this.matrix = new TriangularMatrix(maxItemId + 1);
            for (List<Integer> itemset2 : database.getTransactions()) {
                Object[] array = itemset2.toArray();
                int i = 0;
                while (i < itemset2.size()) {
                    Integer itemI = (Integer)array[i];
                    int j = i + 1;
                    while (j < itemset2.size()) {
                        Integer itemJ = (Integer)array[j];
                        this.matrix.incrementCount(itemI, itemJ);
                        ++j;
                    }
                    ++i;
                }
            }
        }
        ArrayList<Integer> singleItems = new ArrayList<Integer>();
        for (Map.Entry entry : mapItemTIDS.entrySet()) {
            BitSetSupport tidset2 = (BitSetSupport)entry.getValue();
            int support = tidset2.support;
            int item = (Integer)entry.getKey();
            if (this.maxItemsetSize < 1) continue;
            singleItems.add(item);
            if (support >= this.minsupRelative) continue;
            this.saveSingleItem(item, support, tidset2.bitset);
        }
        Collections.sort(singleItems, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return ((BitSetSupport)mapItemTIDS.get((Object)arg0)).support - ((BitSetSupport)mapItemTIDS.get((Object)arg1)).support;
            }
        });
        if (this.maxItemsetSize >= 2) {
            int i = 0;
            while (i < singleItems.size()) {
                Integer itemI = (Integer)singleItems.get(i);
                BitSetSupport tidsetI = (BitSetSupport)mapItemTIDS.get(itemI);
                ArrayList<Integer> equivalenceClassIitems = new ArrayList<Integer>();
                ArrayList<BitSetSupport> equivalenceClassItidsets = new ArrayList<BitSetSupport>();
                ArrayList<BitSetSupport> equivalenceClassConjunctiveItidsets = new ArrayList<BitSetSupport>();
                int j = i + 1;
                while (j < singleItems.size()) {
                    int itemJ = (Integer)singleItems.get(j);
                    int supportIJ = -1;
                    if (useTriangularMatrixOptimization) {
                        supportIJ = this.matrix.getSupportForItems(itemI, itemJ);
                    }
                    BitSetSupport tidsetJ = (BitSetSupport)mapItemTIDS.get(itemJ);
                    BitSetSupport bitsetSupportIJ = null;
                    bitsetSupportIJ = useTriangularMatrixOptimization ? this.performANDFirstTime(tidsetI, tidsetJ, supportIJ) : this.performAND(tidsetI, tidsetJ);
                    BitSetSupport conjunctiveSupportIJ = null;
                    if (bitsetSupportIJ.support >= 1) {
                        conjunctiveSupportIJ = this.performOR(tidsetI, tidsetJ);
                        equivalenceClassIitems.add(itemJ);
                        equivalenceClassItidsets.add(bitsetSupportIJ);
                        equivalenceClassConjunctiveItidsets.add(conjunctiveSupportIJ);
                    }
                    ++j;
                }
                if (equivalenceClassIitems.size() > 0) {
                    this.itemsetBuffer[0] = itemI;
                    this.processEquivalenceClass(this.itemsetBuffer, 1, equivalenceClassIitems, equivalenceClassItidsets, equivalenceClassConjunctiveItidsets);
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTime = System.currentTimeMillis();
        return this.frequentItemsets;
    }

    int calculateSupportSingleItems(TransactionDatabase database, Map<Integer, BitSetSupport> mapItemTIDS) {
        int maxItemId = 0;
        int i = 0;
        while (i < database.size()) {
            for (Integer item : database.getTransactions().get(i)) {
                BitSetSupport tids = mapItemTIDS.get(item);
                if (tids == null) {
                    tids = new BitSetSupport();
                    mapItemTIDS.put(item, tids);
                    if (item > maxItemId) {
                        maxItemId = item;
                    }
                }
                tids.bitset.set(i);
                ++tids.support;
            }
            ++i;
        }
        return maxItemId;
    }

    BitSetSupport performAND(BitSetSupport tidsetI, BitSetSupport tidsetJ) {
        BitSetSupport bitsetSupportIJ = new BitSetSupport();
        bitsetSupportIJ.bitset = (BitSet)tidsetI.bitset.clone();
        bitsetSupportIJ.bitset.and(tidsetJ.bitset);
        bitsetSupportIJ.support = bitsetSupportIJ.bitset.cardinality();
        return bitsetSupportIJ;
    }

    BitSetSupport performOR(BitSetSupport tidsetI, BitSetSupport tidsetJ) {
        BitSetSupport bitsetSupportIJ = new BitSetSupport();
        bitsetSupportIJ.bitset = (BitSet)tidsetI.bitset.clone();
        bitsetSupportIJ.bitset.or(tidsetJ.bitset);
        bitsetSupportIJ.support = bitsetSupportIJ.bitset.cardinality();
        return bitsetSupportIJ;
    }

    BitSetSupport performANDFirstTime(BitSetSupport tidsetI, BitSetSupport tidsetJ, int supportIJ) {
        BitSetSupport bitsetSupportIJ = new BitSetSupport();
        bitsetSupportIJ.bitset = (BitSet)tidsetI.bitset.clone();
        bitsetSupportIJ.bitset.and(tidsetJ.bitset);
        bitsetSupportIJ.support = supportIJ;
        return bitsetSupportIJ;
    }

    private void processEquivalenceClass(int[] prefix, int prefixLength, List<Integer> equivalenceClassItems, List<BitSetSupport> equivalenceClassTidsets, List<BitSetSupport> equivalenceClassConjunctiveItidsets) throws IOException {
        if (equivalenceClassItems.size() == 1) {
            int itemI = equivalenceClassItems.get(0);
            BitSetSupport tidsetI = equivalenceClassTidsets.get(0);
            if (tidsetI.support < this.minsupRelative) {
                BitSetSupport conjunctiveI = equivalenceClassConjunctiveItidsets.get(0);
                double bondI = (double)tidsetI.support / (double)conjunctiveI.support;
                if (bondI >= this.minBond) {
                    this.save(prefix, prefixLength, itemI, tidsetI, bondI);
                }
            }
            return;
        }
        if (equivalenceClassItems.size() == 2) {
            double bondJ;
            int itemI = equivalenceClassItems.get(0);
            BitSetSupport tidsetI = equivalenceClassTidsets.get(0);
            BitSetSupport conjunctiveI = equivalenceClassConjunctiveItidsets.get(0);
            double bondI = (double)tidsetI.support / (double)conjunctiveI.support;
            if (tidsetI.support < this.minsupRelative && bondI >= this.minBond) {
                this.save(prefix, prefixLength, itemI, tidsetI, bondI);
            }
            int itemJ = equivalenceClassItems.get(1);
            BitSetSupport tidsetJ = equivalenceClassTidsets.get(1);
            BitSetSupport conjunctiveJ = equivalenceClassConjunctiveItidsets.get(1);
            if (tidsetJ.support < this.minsupRelative && (bondJ = (double)tidsetJ.support / (double)conjunctiveJ.support) >= this.minBond) {
                this.save(prefix, prefixLength, itemJ, tidsetJ, bondJ);
            }
            BitSetSupport bitsetSupportIJ = this.performAND(tidsetI, tidsetJ);
            if (bitsetSupportIJ.support < this.minsupRelative && prefixLength + 2 <= this.maxItemsetSize) {
                int newPrefixLength = prefixLength + 1;
                prefix[prefixLength] = itemI;
                if (bitsetSupportIJ.support >= 1 && bitsetSupportIJ.support < this.minsupRelative) {
                    BitSetSupport bitsetConjunctiveSupportIJ = this.performOR(conjunctiveI, conjunctiveJ);
                    double bondIJ = (double)bitsetSupportIJ.support / (double)bitsetConjunctiveSupportIJ.support;
                    if (bondIJ >= this.minBond) {
                        this.save(prefix, newPrefixLength, itemJ, bitsetSupportIJ, bondIJ);
                    }
                }
            }
            return;
        }
        int i = 0;
        while (i < equivalenceClassItems.size()) {
            double bondI;
            int itemI = equivalenceClassItems.get(i);
            BitSetSupport tidsetI = equivalenceClassTidsets.get(i);
            BitSetSupport conjunctiveI = equivalenceClassConjunctiveItidsets.get(i);
            if (tidsetI.support < this.minsupRelative && (bondI = (double)tidsetI.support / (double)conjunctiveI.support) >= this.minBond) {
                this.save(prefix, prefixLength, itemI, tidsetI, bondI);
            }
            if (prefixLength + 2 <= this.maxItemsetSize) {
                ArrayList<Integer> equivalenceClassISuffixItems = new ArrayList<Integer>();
                ArrayList<BitSetSupport> equivalenceITidsets = new ArrayList<BitSetSupport>();
                ArrayList<BitSetSupport> equivalenceConjunctiveITidsets = new ArrayList<BitSetSupport>();
                int j = i + 1;
                while (j < equivalenceClassItems.size()) {
                    int itemJ = equivalenceClassItems.get(j);
                    BitSetSupport tidsetJ = equivalenceClassTidsets.get(j);
                    BitSetSupport conjunctiveJ = equivalenceClassConjunctiveItidsets.get(j);
                    BitSetSupport bitsetSupportIJ = this.performAND(tidsetI, tidsetJ);
                    BitSetSupport bitsetConjunctiveSupportIJ = this.performOR(conjunctiveI, conjunctiveJ);
                    double bondIJ = (double)bitsetSupportIJ.support / (double)bitsetConjunctiveSupportIJ.support;
                    if (bitsetSupportIJ.support >= 1 && bondIJ >= this.minBond) {
                        equivalenceClassISuffixItems.add(itemJ);
                        equivalenceITidsets.add(bitsetSupportIJ);
                        equivalenceConjunctiveITidsets.add(bitsetConjunctiveSupportIJ);
                    }
                    ++j;
                }
                if (equivalenceClassISuffixItems.size() > 0) {
                    prefix[prefixLength] = itemI;
                    int newPrefixLength = prefixLength + 1;
                    this.processEquivalenceClass(prefix, newPrefixLength, equivalenceClassISuffixItems, equivalenceITidsets, equivalenceConjunctiveITidsets);
                }
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void save(int[] prefix, int prefixLength, int suffixItem, BitSetSupport tidset2, double bond) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            int[] itemsetArray = new int[prefixLength + 1];
            System.arraycopy(prefix, 0, itemsetArray, 0, prefixLength);
            itemsetArray[prefixLength] = suffixItem;
            ItemsetCORI itemset2 = new ItemsetCORI(itemsetArray);
            itemset2.setAbsoluteSupport(tidset2.support);
            itemset2.bond = bond;
            this.frequentItemsets.addItemset(itemset2, itemset2.size());
        } else {
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < prefixLength) {
                int item = prefix[i];
                buffer.append(item);
                buffer.append(" ");
                ++i;
            }
            buffer.append(suffixItem);
            buffer.append(" #SUP: ");
            buffer.append(tidset2.support);
            buffer.append(" #BOND: ");
            buffer.append(bond);
            if (this.showTransactionIdentifiers) {
                buffer.append(" #TID:");
                BitSet bitset = tidset2.bitset;
                int tid = bitset.nextSetBit(0);
                while (tid != -1) {
                    buffer.append(" " + tid);
                    tid = bitset.nextSetBit(tid + 1);
                }
            }
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    private void saveSingleItem(int item, int support, BitSet tidset2) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            ItemsetCORI itemset2 = new ItemsetCORI(new int[]{item});
            itemset2.setAbsoluteSupport(support);
            itemset2.bond = 1.0;
            this.frequentItemsets.addItemset(itemset2, itemset2.size());
        } else {
            StringBuilder buffer = new StringBuilder();
            buffer.append(item);
            buffer.append(" #SUP: ");
            buffer.append(support);
            buffer.append(" #BOND: ");
            buffer.append(1.0);
            if (this.showTransactionIdentifiers) {
                buffer.append(" #TID:");
                int tid = tidset2.nextSetBit(0);
                while (tid != -1) {
                    buffer.append(" " + tid);
                    tid = tidset2.nextSetBit(tid + 1);
                }
            }
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    public void printStats() {
        System.out.println("=============  CORI _96r18 - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Minbond = " + this.minBond + " Minsup = " + this.minsupRelative + " transactions");
        System.out.println(" Database transaction count: " + this.database.size());
        System.out.println(" Rare correlated itemset count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("===================================================");
    }

    public ItemsetsCORI getItemsets() {
        return this.frequentItemsets;
    }

    public void setShowTransactionIdentifiers(boolean showTransactionIdentifiers) {
        this.showTransactionIdentifiers = showTransactionIdentifiers;
    }

    public void setMaximumPatternLength(int length) {
        this.maxItemsetSize = length;
    }

    public class BitSetSupport {
        BitSet bitset = new BitSet();
        int support;
    }
}

