/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.clhminer;

import ca.pfv.spmf.algorithms.frequentpatterns.clhminer.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.clhminer.TaxonomyNode;
import ca.pfv.spmf.algorithms.frequentpatterns.clhminer.TaxonomyTree;
import ca.pfv.spmf.algorithms.frequentpatterns.clhminer.UtilityList;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AlgoCLHMiner {
    int minUtil;
    List<UtilityList> ListUls;
    int itemCount = 0;
    int giCount = 0;
    int taxDepth = 0;
    static Map<Integer, UtilityList> mapItemToUtilityList;
    long startTimestamp = 0L;
    Map<Integer, Double> mapItemToTWU;
    long endTimestamp = 0L;
    TaxonomyTree taxonomy;
    private int[] itemsetBuffer = null;
    List<Pair> revisedTransaction;
    List<List<Pair>> datasetAfterRemove;
    int countHUI;
    int candidate;
    BufferedWriter writer;

    public void runAlgorithm(int minUtil, String inputPath, String outputPath, String TaxonomyPath) throws IOException {
        String thisLine;
        this.writer = new BufferedWriter(new FileWriter(outputPath));
        this.minUtil = minUtil;
        this.candidate = 0;
        this.startTimestamp = System.currentTimeMillis();
        this.mapItemToTWU = new HashMap<Integer, Double>();
        this.taxonomy = new TaxonomyTree();
        this.taxonomy.ReadDataFromPath(TaxonomyPath);
        BufferedReader myInput = null;
        this.itemsetBuffer = new int[500];
        this.datasetAfterRemove = new ArrayList<List<Pair>>();
        this.countHUI = 0;
        HashSet<Integer> itemInDB = new HashSet<Integer>();
        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(inputPath))));
        while ((thisLine = myInput.readLine()) != null) {
            Double twu;
            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
            String[] split = thisLine.split(":");
            String[] items = split[0].split(" ");
            double transactionUtility = Double.parseDouble(split[1]);
            HashSet<Integer> setParent = new HashSet<Integer>();
            int i = 0;
            while (i < items.length) {
                Integer item = Integer.parseInt(items[i]);
                itemInDB.add(item);
                if (this.taxonomy.mapItemToTaxonomyNode.get(item) == null) {
                    TaxonomyNode newNode = new TaxonomyNode(item);
                    this.taxonomy.mapItemToTaxonomyNode.get(-1).addChildren(newNode);
                    this.taxonomy.mapItemToTaxonomyNode.put(item, newNode);
                } else {
                    TaxonomyNode parentNode = this.taxonomy.mapItemToTaxonomyNode.get(item).getParent();
                    while (parentNode.getData() != -1) {
                        setParent.add(parentNode.getData());
                        parentNode = parentNode.getParent();
                    }
                }
                twu = this.mapItemToTWU.get(item);
                twu = twu == null ? transactionUtility : twu + transactionUtility;
                this.mapItemToTWU.put(item, twu);
                ++i;
            }
            for (Integer parentItemInTransaction : setParent) {
                twu = this.mapItemToTWU.get(parentItemInTransaction);
                twu = twu == null ? transactionUtility : twu + transactionUtility;
                this.mapItemToTWU.put(parentItemInTransaction, twu);
            }
        }
        ArrayList<UtilityList> listOfUtilityLists = new ArrayList<UtilityList>();
        mapItemToUtilityList = new HashMap<Integer, UtilityList>();
        for (Integer item : this.mapItemToTWU.keySet()) {
            if (!(this.mapItemToTWU.get(item) >= (double)minUtil)) continue;
            UtilityList uList = new UtilityList(item);
            mapItemToUtilityList.put(item, uList);
            listOfUtilityLists.add(uList);
        }
        Collections.sort(listOfUtilityLists, new Comparator<UtilityList>(){

            @Override
            public int compare(UtilityList o1, UtilityList o2) {
                return AlgoCLHMiner.this.compareItems(o1.item, o2.item);
            }
        });
        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(inputPath))));
        int tid = 0;
        while ((thisLine = myInput.readLine()) != null) {
            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
            String[] split = thisLine.split(":");
            String[] items = split[0].split(" ");
            String[] utilityValues = split[2].split(" ");
            double remainingUtility = 0.0;
            double TU = Double.parseDouble(split[1]);
            ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
            HashMap<Integer, Double> mapParentToUtility = new HashMap<Integer, Double>();
            int i = 0;
            while (i < items.length) {
                Double Utiliy = Double.parseDouble(utilityValues[i]);
                int item = Integer.parseInt(items[i]);
                TaxonomyNode nodeParent = this.taxonomy.mapItemToTaxonomyNode.get(item).getParent();
                while (nodeParent.getData() != -1) {
                    Double utilityOfParent = (Double)mapParentToUtility.get(nodeParent.getData());
                    if (utilityOfParent != null) {
                        mapParentToUtility.put(nodeParent.getData(), utilityOfParent + Utiliy);
                    } else {
                        mapParentToUtility.put(nodeParent.getData(), Utiliy);
                    }
                    nodeParent = nodeParent.getParent();
                }
                Pair pair = new Pair();
                pair.item = item;
                pair.utility = Utiliy;
                if (this.mapItemToTWU.get(pair.item) >= (double)minUtil) {
                    revisedTransaction.add(pair);
                    remainingUtility += pair.utility;
                }
                ++i;
            }
            Collections.sort(revisedTransaction, new Comparator<Pair>(){

                @Override
                public int compare(Pair o1, Pair o2) {
                    return AlgoCLHMiner.this.compareItems(o1.item, o2.item);
                }
            });
            double CountUtility = remainingUtility;
            int i2 = 0;
            while (i2 < revisedTransaction.size()) {
                Pair pair = (Pair)revisedTransaction.get(i2);
                UtilityList utilityListOfItem = mapItemToUtilityList.get(pair.item);
                Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility, TU);
                utilityListOfItem.addElement(element);
                ++i2;
            }
            for (Integer itemParent : mapParentToUtility.keySet()) {
                double CountUtilityOfEachItem = CountUtility;
                int i3 = 0;
                while (i3 < revisedTransaction.size()) {
                    Pair CurrentItem = (Pair)revisedTransaction.get(i3);
                    if (this.CheckParent(itemParent, CurrentItem.item)) {
                        CountUtilityOfEachItem -= CurrentItem.utility;
                    } else if (this.compareItems(itemParent, CurrentItem.item) > 0) {
                        CountUtilityOfEachItem -= CurrentItem.utility;
                    }
                    ++i3;
                }
                UtilityList utilityListOfItem = mapItemToUtilityList.get(itemParent);
                if (utilityListOfItem == null) continue;
                Element element = new Element(tid, (Double)mapParentToUtility.get(itemParent), CountUtilityOfEachItem, TU);
                utilityListOfItem.addElement(element);
            }
            this.datasetAfterRemove.add(revisedTransaction);
            ++tid;
        }
        ArrayList<UtilityList> listUtilityLevel1 = new ArrayList<UtilityList>();
        for (UtilityList ul1 : listOfUtilityLists) {
            if (this.taxonomy.getMapItemToTaxonomyNode().get(ul1.item).getLevel() == 1) {
                listUtilityLevel1.add(ul1);
            }
            if (this.taxonomy.getMapItemToTaxonomyNode().get(ul1.item).getLevel() > 1) break;
        }
        this.itemCount = itemInDB.size();
        this.giCount = this.taxonomy.getGI() - 1;
        this.taxDepth = this.taxonomy.getMaxLevel();
        this.SearchTree(this.itemsetBuffer, 0, null, listUtilityLevel1);
        this.endTimestamp = System.currentTimeMillis();
        myInput.close();
        this.writer.close();
    }

    private void SearchTree(int[] prefix, int prefixLength, UtilityList pUL, List<UtilityList> ULs) throws IOException {
        int i = 0;
        while (i < ULs.size()) {
            UtilityList X = ULs.get(i);
            ++this.candidate;
            if (X.sumIutils > this.minUtil) {
                ++this.countHUI;
                int j = 0;
                while (j < prefixLength) {
                    this.writer.write(String.valueOf(prefix[j]) + " ");
                    ++j;
                }
                this.writer.write(X.item + " #UTIL: " + X.sumIutils);
                this.writer.newLine();
            }
            ArrayList<UtilityList> exULs = new ArrayList<UtilityList>();
            int j = i + 1;
            while (j < ULs.size()) {
                UtilityList Y = ULs.get(j);
                if (!this.CheckParent(Y.item, X.item)) {
                    UtilityList exULBuild = this.construct(pUL, X, Y);
                    if (exULBuild.GWU > this.minUtil) {
                        exULs.add(exULBuild);
                    }
                }
                ++j;
            }
            if (X.sumIutils + X.sumRutils > this.minUtil) {
                TaxonomyNode taxonomyNodeX = this.taxonomy.getMapItemToTaxonomyNode().get(X.item);
                List<TaxonomyNode> childOfX = taxonomyNodeX.getChildren();
                for (TaxonomyNode taxonomyNode : childOfX) {
                    int Child = taxonomyNode.getData();
                    UtilityList ULofChild = mapItemToUtilityList.get(Child);
                    if (ULofChild == null) continue;
                    UtilityList exULBuild = this.constructTax(pUL, ULofChild);
                    X.AddChild(exULBuild);
                }
                for (UtilityList childULs : X.getChild()) {
                    if (childULs.GWU <= this.minUtil) continue;
                    ULs.add(childULs);
                }
            }
            this.itemsetBuffer[prefixLength] = X.item;
            this.SearchTree(this.itemsetBuffer, prefixLength + 1, X, exULs);
            ++i;
        }
    }

    private UtilityList constructTax(UtilityList P, UtilityList Child) {
        if (P == null) {
            return Child;
        }
        UtilityList newULs = new UtilityList(Child.item);
        for (Element PElment : P.getElement()) {
            Element UnionChild = this.findElementWithTID(Child, PElment.tid);
            if (UnionChild == null) continue;
            List<Pair> trans = this.datasetAfterRemove.get(UnionChild.tid);
            double remainUtility = 0.0;
            int i = 0;
            while (i < trans.size()) {
                Integer currentItem = trans.get((int)i).item;
                if (this.compareItems(currentItem, Child.item) > 0 && !this.CheckParent(Child.item, currentItem) && !this.CheckParent(Child.item, currentItem)) {
                    remainUtility += trans.get((int)i).utility;
                }
                ++i;
            }
            Element newElment = new Element(UnionChild.tid, PElment.iutils + UnionChild.iutils, remainUtility, UnionChild.TU);
            newULs.addElement(newElment);
        }
        return newULs;
    }

    private UtilityList construct(UtilityList P, UtilityList px, UtilityList py) {
        UtilityList pxyUL = new UtilityList(py.item);
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) continue;
            if (P == null) {
                List<Pair> trans = this.datasetAfterRemove.get(ex.tid);
                double remainUtility = 0.0;
                int i = 0;
                while (i < trans.size()) {
                    Integer currentItem = trans.get((int)i).item;
                    if (this.compareItems(currentItem, py.item) > 0 && !this.CheckParent(px.item, currentItem) && !this.CheckParent(py.item, currentItem)) {
                        remainUtility += trans.get((int)i).utility;
                    }
                    ++i;
                }
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, remainUtility, ey.TU);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            List<Pair> trans = this.datasetAfterRemove.get(e.tid);
            double remainUtility = 0.0;
            int i = 0;
            while (i < trans.size()) {
                Integer currentItem = trans.get((int)i).item;
                if (this.compareItems(currentItem, py.item) > 0 && !this.CheckParent(px.item, currentItem) && !this.CheckParent(py.item, currentItem)) {
                    remainUtility += trans.get((int)i).utility;
                }
                ++i;
            }
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, remainUtility, ey.TU);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private int compareItems(int item1, int item2) {
        int levelOfItem2;
        int levelOfItem1 = this.taxonomy.getMapItemToTaxonomyNode().get(item1).getLevel();
        if (levelOfItem1 == (levelOfItem2 = this.taxonomy.getMapItemToTaxonomyNode().get(item2).getLevel())) {
            int compare = (int)(this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2));
            return compare == 0 ? item1 - item2 : compare;
        }
        return levelOfItem1 - levelOfItem2;
    }

    private boolean CheckParent(int item1, int item2) {
        int levelOfItem2;
        TaxonomyNode nodeItem1 = this.taxonomy.getMapItemToTaxonomyNode().get(item1);
        TaxonomyNode nodeItem2 = this.taxonomy.getMapItemToTaxonomyNode().get(item2);
        int levelOfItem1 = nodeItem1.getLevel();
        if (levelOfItem1 == (levelOfItem2 = nodeItem2.getLevel())) {
            return false;
        }
        if (levelOfItem1 > levelOfItem2) {
            TaxonomyNode parentItem1 = nodeItem1.getParent();
            while (parentItem1.getData() != -1) {
                if (parentItem1.getData() == nodeItem2.getData()) {
                    return true;
                }
                parentItem1 = parentItem1.getParent();
            }
            return false;
        }
        TaxonomyNode parentItem2 = nodeItem2.getParent();
        while (parentItem2.getData() != -1) {
            if (parentItem2.getData() == nodeItem1.getData()) {
                return true;
            }
            parentItem2 = parentItem2.getParent();
        }
        return false;
    }

    public void printStats() throws IOException {
        System.out.println("=============  CLH-Miner v. 2.45 =============");
        System.out.println(" Runtime time ~ : " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ : " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" Cross level high utility itemsets (count): " + this.countHUI);
        System.out.println("   Number of items              : " + this.itemCount);
        System.out.println("   Number of generalized items             : " + this.giCount);
        System.out.println("   Taxonomy depth   : " + this.taxDepth);
        System.out.println("   Candidates (count): " + this.candidate);
        System.out.println("======================================");
    }

    class Pair {
        int item = 0;
        double utility = 0.0;

        Pair() {
        }
    }
}

