/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.chud;

import ca.pfv.spmf.algorithms.frequentpatterns.chud.TransactionTP;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class UtilityTransactionDatabaseTP {
    private final Set<Integer> allItems = new HashSet<Integer>();
    private final List<TransactionTP> transactions = new ArrayList<TransactionTP>();

    UtilityTransactionDatabaseTP() {
    }

    public void addTransaction(TransactionTP t) {
        this.transactions.add(t);
        this.allItems.addAll(t.getItems());
    }

    public void loadFile(String path) throws IOException {
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                FileInputStream fin = new FileInputStream(new File(path));
                myInput = new BufferedReader(new InputStreamReader(fin));
                while ((thisLine = myInput.readLine()) != null) {
                    if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                    this.processTransaction(thisLine.split(":"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }

    private void processTransaction(String[] line) {
        int transactionUtility = Integer.parseInt(line[1]);
        ArrayList<Integer> items = new ArrayList<Integer>();
        String[] stringArray = line[0].split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            items.add(Integer.parseInt(item));
            ++n2;
        }
        ArrayList<Integer> itemsUtilities = new ArrayList<Integer>();
        String[] stringArray2 = line[2].split(" ");
        int n3 = stringArray2.length;
        n = 0;
        while (n < n3) {
            String utility = stringArray2[n];
            itemsUtilities.add(Integer.parseInt(utility));
            ++n;
        }
        this.bubbleSort(items, itemsUtilities);
        this.transactions.add(new TransactionTP(items, itemsUtilities, transactionUtility));
    }

    private void bubbleSort(List<Integer> items, List<Integer> itemsUtilities) {
        int i = 0;
        while (i < items.size()) {
            int j = items.size() - 1;
            while (j >= i + 1) {
                if (items.get(j) < items.get(j - 1)) {
                    int temp = items.get(j);
                    items.set(j, items.get(j - 1));
                    items.set(j - 1, temp);
                    int tempUtilities = itemsUtilities.get(j);
                    itemsUtilities.set(j, itemsUtilities.get(j - 1));
                    itemsUtilities.set(j - 1, tempUtilities);
                }
                --j;
            }
            ++i;
        }
    }

    public void printDatabase() {
        System.out.println("===================  Database ===================");
        int count = 0;
        for (TransactionTP itemset2 : this.transactions) {
            System.out.print("0" + count + ":  ");
            itemset2.print();
            System.out.println("");
            ++count;
        }
    }

    public int size() {
        return this.transactions.size();
    }

    public List<TransactionTP> getTransactions() {
        return this.transactions;
    }

    public Set<Integer> getAllItems() {
        return this.allItems;
    }
}

