/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.charm;

import ca.pfv.spmf.patterns.itemset_array_integers_with_tids_bitset.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids_bitset.Itemsets;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;

public class AlgoCharmMFI {
    private long startTimestamp;
    private long endTimestamp;
    protected Itemsets maximalItemsets;
    BufferedWriter writer = null;
    boolean showTransactionIdentifiers = false;

    public Itemsets runAlgorithm(String output, Itemsets frequentClosed) throws IOException {
        this.writer = output == null ? null : new BufferedWriter(new FileWriter(output));
        this.maximalItemsets = frequentClosed;
        this.maximalItemsets.setName("FREQUENT MAXIMAL ITEMSETS");
        this.startTimestamp = System.currentTimeMillis();
        int maxItemsetLength = frequentClosed.getLevels().size();
        int i = 1;
        while (i < maxItemsetLength - 1) {
            List<Itemset> ti = frequentClosed.getLevels().get(i);
            int j = i + 1;
            while (j < maxItemsetLength) {
                List<Itemset> tip1 = frequentClosed.getLevels().get(j);
                this.findMaximal(ti, tip1, frequentClosed);
                ++j;
            }
            ++i;
        }
        if (this.writer != null) {
            for (List<Itemset> level : this.maximalItemsets.getLevels()) {
                int i2 = 0;
                while (i2 < level.size()) {
                    Itemset itemset2 = level.get(i2);
                    this.writer.write(String.valueOf(itemset2.toString()) + " #SUP: " + itemset2.getAbsoluteSupport());
                    if (this.showTransactionIdentifiers) {
                        BitSet bitset = itemset2.getTransactionsIds();
                        this.writer.append(" #TID:");
                        int tid = bitset.nextSetBit(0);
                        while (tid != -1) {
                            this.writer.append(" " + tid);
                            tid = bitset.nextSetBit(tid + 1);
                        }
                    }
                    this.writer.newLine();
                    ++i2;
                }
            }
            this.writer.close();
        }
        this.endTimestamp = System.currentTimeMillis();
        return this.maximalItemsets;
    }

    private void findMaximal(List<Itemset> ti, List<Itemset> tip1, Itemsets maximalItemsets) {
        for (Itemset itemsetJ : tip1) {
            Iterator<Itemset> iter = ti.iterator();
            while (iter.hasNext()) {
                Itemset itemsetI = iter.next();
                if (!itemsetJ.containsAll(itemsetI)) continue;
                iter.remove();
                maximalItemsets.decreaseItemsetCount();
            }
        }
    }

    public void setShowTransactionIdentifiers(boolean showTransactionIdentifiers) {
        this.showTransactionIdentifiers = showTransactionIdentifiers;
    }

    public void printStats(int transactionCount) {
        System.out.println("=============  CHARM-MFI - STATS =============");
        long temps = this.endTimestamp - this.startTimestamp;
        System.out.println(" Transactions count from database : " + transactionCount);
        System.out.println(" Frequent maximal itemsets count : " + this.maximalItemsets.getItemsetsCount());
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }

    public Itemsets getItemsets() {
        return this.maximalItemsets;
    }
}

