/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.cfpgrowth;

import ca.pfv.spmf.algorithms.frequentpatterns.cfpgrowth.MISNode;
import ca.pfv.spmf.algorithms.frequentpatterns.cfpgrowth.MISTree;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoCFPGrowth {
    private long startTimestamp;
    private long endTime;
    private int transactionCount = 0;
    private int itemsetCount;
    BufferedWriter writer = null;
    protected Itemsets patterns = null;
    final Comparator<Integer> itemComparator = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            int compare = AlgoCFPGrowth.this.MIS[o2] - AlgoCFPGrowth.this.MIS[o1];
            if (compare == 0) {
                return o1 - o2;
            }
            return compare;
        }
    };
    int[] MIS;
    int minMIS;
    private MemoryLogger memoryLogger = null;

    public Itemsets runAlgorithm(String input, String output, String MISIn) throws FileNotFoundException, IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.memoryLogger = new MemoryLogger();
        this.memoryLogger.checkMemory();
        if (output == null) {
            this.writer = null;
            this.patterns = new Itemsets("FREQUENT ITEMSETS");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        HashMap<Integer, Integer> mapSupport = new HashMap<Integer, Integer>();
        this.initMISfromFile(MISIn);
        this.itemsetCount = 0;
        MISTree tree = new MISTree();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            ArrayList<Integer> transaction = new ArrayList<Integer>();
            String[] stringArray = lineSplited;
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                Integer item = Integer.parseInt(itemString);
                Integer count = (Integer)mapSupport.get(item);
                if (count == null) {
                    mapSupport.put(item, 1);
                } else {
                    count = count + 1;
                    mapSupport.put(item, count);
                }
                transaction.add(item);
                ++n2;
            }
            ++this.transactionCount;
            Collections.sort(transaction, this.itemComparator);
            tree.addTransaction(transaction);
        }
        reader.close();
        tree.createHeaderList(this.itemComparator);
        boolean sw = false;
        for (Map.Entry entry : mapSupport.entrySet()) {
            if ((Integer)entry.getValue() >= this.minMIS) continue;
            tree.deleteFromHeaderList((Integer)entry.getKey(), this.itemComparator);
            tree.MISPruning((Integer)entry.getKey());
            sw = true;
        }
        if (sw) {
            tree.MISMerge(tree.root);
        }
        int[] prefixAlpha = new int[]{};
        if (tree.headerList.size() > 0) {
            this.cfpgrowth(tree, prefixAlpha, this.transactionCount, mapSupport);
        }
        this.memoryLogger.checkMemory();
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTime = System.currentTimeMillis();
        return this.patterns;
    }

    private void initMISfromFile(String input) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        this.minMIS = Integer.MAX_VALUE;
        int maxItemID = 0;
        HashMap<Integer, Integer> mapMIS = new HashMap<Integer, Integer>();
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            Integer item = Integer.parseInt(lineSplited[0]);
            Integer itemMIS = Integer.parseInt(lineSplited[1]);
            if (this.minMIS > itemMIS && itemMIS != 0) {
                this.minMIS = itemMIS;
            }
            mapMIS.put(item, itemMIS);
            if (item <= maxItemID) continue;
            maxItemID = item;
        }
        this.MIS = new int[maxItemID + 1];
        for (Map.Entry entry : mapMIS.entrySet()) {
            this.MIS[((Integer)entry.getKey()).intValue()] = (Integer)entry.getValue();
        }
        reader.close();
    }

    private void cfpgrowth(MISTree tree, int[] prefixAlpha, int prefixSupport, Map<Integer, Integer> mapSupport) throws IOException {
        if (tree.headerList.size() == 1) {
            MISNode node = tree.mapItemNodes.get(tree.headerList.get(0));
            if (node.nodeLink == null) {
                if (node.counter >= this.MIS[prefixAlpha[0]]) {
                    this.writeItemsetToFile(prefixAlpha, node.itemID, node.counter);
                }
            } else {
                this.cfpgrowthMoreThanOnePath(tree, prefixAlpha, prefixSupport, mapSupport);
            }
        } else {
            this.cfpgrowthMoreThanOnePath(tree, prefixAlpha, prefixSupport, mapSupport);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void cfpgrowthMoreThanOnePath(MISTree tree, int[] prefixAlpha, int prefixSupport, Map<Integer, Integer> mapSupport) throws IOException {
        int i = tree.headerList.size() - 1;
        while (i >= 0) {
            int mis;
            Integer item = tree.headerList.get(i);
            int support = mapSupport.get(item);
            int n = mis = prefixAlpha.length == 0 ? this.MIS[item] : this.MIS[prefixAlpha[0]];
            if (support >= mis) {
                int betaSupport;
                int n2 = betaSupport = prefixSupport < support ? prefixSupport : support;
                if (support >= mis) {
                    this.writeItemsetToFile(prefixAlpha, item, betaSupport);
                }
                ArrayList prefixPaths = new ArrayList();
                MISNode path = tree.mapItemNodes.get(item);
                while (path != null) {
                    if (path.parent.itemID != -1) {
                        void var13_16;
                        ArrayList<Object> prefixPath = new ArrayList<Object>();
                        prefixPath.add(path);
                        MISNode mISNode = path.parent;
                        while (var13_16.itemID != -1) {
                            prefixPath.add(var13_16);
                            MISNode mISNode2 = var13_16.parent;
                        }
                        prefixPaths.add(prefixPath);
                    }
                    path = path.nodeLink;
                }
                HashMap<Integer, Integer> mapSupportBeta = new HashMap<Integer, Integer>();
                for (List list : prefixPaths) {
                    int pathCount = ((MISNode)list.get((int)0)).counter;
                    int j = 1;
                    while (j < list.size()) {
                        MISNode node = (MISNode)list.get(j);
                        if (mapSupportBeta.get(node.itemID) == null) {
                            mapSupportBeta.put(node.itemID, pathCount);
                        } else {
                            mapSupportBeta.put(node.itemID, (Integer)mapSupportBeta.get(node.itemID) + pathCount);
                        }
                        ++j;
                    }
                }
                MISTree mISTree = new MISTree();
                for (List list : prefixPaths) {
                    mISTree.addPrefixPath(list, mapSupportBeta, this.minMIS);
                }
                mISTree.createHeaderList(this.itemComparator);
                if (mISTree.root.childs.size() > 0) {
                    int[] nArray = new int[prefixAlpha.length + 1];
                    System.arraycopy(prefixAlpha, 0, nArray, 0, prefixAlpha.length);
                    nArray[prefixAlpha.length] = item;
                    this.cfpgrowth(mISTree, nArray, betaSupport, mapSupportBeta);
                }
            }
            --i;
        }
    }

    private void writeItemsetToFile(int[] itemset2, int lastItem, int support) throws IOException {
        ++this.itemsetCount;
        if (this.writer != null) {
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < itemset2.length) {
                buffer.append(itemset2[i]);
                buffer.append(' ');
                ++i;
            }
            buffer.append(lastItem);
            buffer.append(" #SUP: ");
            buffer.append(support);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        } else {
            int[] itemsetWithLastItem = new int[itemset2.length + 1];
            System.arraycopy(itemset2, 0, itemsetWithLastItem, 0, itemset2.length);
            itemsetWithLastItem[itemset2.length] = lastItem;
            Arrays.sort(itemsetWithLastItem);
            Itemset itemsetObj = new Itemset(itemsetWithLastItem);
            itemsetObj.setAbsoluteSupport(support);
            this.patterns.addItemset(itemsetObj, itemsetObj.size());
        }
    }

    public void printStats() {
        System.out.println("=============  CFP-GROWTH++ - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.transactionCount);
        System.out.print(" Max memory usage: " + this.memoryLogger.getMaxMemory() + " mb \n");
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Total time " + temps + " ms");
        System.out.println("===================================================");
    }

    public int getDatabaseSize() {
        return this.transactionCount;
    }
}

