/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.biohuif;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoBio_HUIF_BA {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    final int pop_size = 100;
    final int max_iter = 2000;
    int transactionCount = 0;
    final double fmin = 0.0;
    final double fmax = 1.0;
    final double Amin = 0.0;
    final double Amax = 2.0;
    final double alpha = 0.8;
    final double gamma = 0.9;
    int gen;
    Map<Integer, Integer> mapItemToUtil;
    Map<Integer, Integer> mapItemToSup;
    Map<Integer, Integer> mapItemToTWU;
    Map<Integer, Integer> mapItemToTWU0;
    List<Integer> twuPattern;
    BufferedWriter writer = null;
    List<Double> percentHUIBA;
    BAIndividual gBest;
    List<BAIndividual> huiBA = new ArrayList<BAIndividual>();
    List<BAIndividual> population = new ArrayList<BAIndividual>();
    List<HUI> huiSets = new ArrayList<HUI>();
    List<List<Double>> V = new ArrayList<List<Double>>();
    List<Double> percentage = new ArrayList<Double>();
    List<List<Pair>> database = new ArrayList<List<Pair>>();
    List<Item> Items;

    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        block32: {
            String[] utilityValues;
            Object items;
            String[] split;
            String thisLine;
            BufferedReader myInput;
            block30: {
                this.maxMemory = 0.0;
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToUtil = new HashMap<Integer, Integer>();
                this.mapItemToSup = new HashMap<Integer, Integer>();
                this.mapItemToTWU = new HashMap<Integer, Integer>();
                this.mapItemToTWU0 = new HashMap<Integer, Integer>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            split = thisLine.split(":");
                            items = split[0].split(" ");
                            utilityValues = split[2].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < ((Object)items).length) {
                                Integer item = Integer.parseInt((String)items[i]);
                                Integer utility = Integer.parseInt(utilityValues[i]);
                                Integer util = this.mapItemToUtil.get(item);
                                util = util == null ? utility : util + utility;
                                this.mapItemToUtil.put(item, util);
                                Integer sup = this.mapItemToSup.get(item);
                                sup = sup == null ? 1 : sup + 1;
                                this.mapItemToSup.put(item, sup);
                                Integer twu = this.mapItemToTWU.get(item);
                                Integer twu0 = this.mapItemToTWU0.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                twu0 = twu0 == null ? transactionUtility : twu0 + transactionUtility;
                                this.mapItemToTWU.put(item, twu);
                                this.mapItemToTWU0.put(item, twu0);
                                ++i;
                            }
                            ++this.transactionCount;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        split = thisLine.split(":");
                        items = split[0].split(" ");
                        utilityValues = split[2].split(" ");
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        ArrayList<Integer> pattern = new ArrayList<Integer>();
                        int i = 0;
                        while (i < ((Object)items).length) {
                            Pair pair = new Pair();
                            pair.item = Integer.parseInt((String)items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            if (this.mapItemToTWU.get(pair.item) >= minUtility) {
                                revisedTransaction.add(pair);
                                pattern.add(pair.item);
                            } else {
                                this.mapItemToTWU0.remove(pair.item);
                            }
                            ++i;
                        }
                        this.database.add(revisedTransaction);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block32;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.twuPattern = new ArrayList<Integer>(this.mapItemToTWU0.keySet());
        Collections.sort(this.twuPattern);
        System.out.println("twuPattern:" + this.twuPattern.size());
        System.out.println(this.twuPattern);
        this.Items = new ArrayList<Item>();
        for (Integer tempitem : this.twuPattern) {
            this.Items.add(new Item(tempitem));
        }
        int i = 0;
        while (i < this.database.size()) {
            int j = 0;
            while (j < this.Items.size()) {
                int k = 0;
                while (k < this.database.get(i).size()) {
                    if (this.Items.get((int)j).item == this.database.get((int)i).get((int)k).item) {
                        this.Items.get((int)j).TIDS.set(i);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.checkMemory();
        if (this.twuPattern.size() > 0) {
            this.gBest = new BAIndividual();
            this.pop_Init(minUtility);
            this.gen = 0;
            while (this.gen < 2000) {
                this.next_Gen_BA(minUtility);
                if (this.huiBA.size() != 0) {
                    this.percentHUIBA = this.roulettePercentHUIBA();
                    int num = this.rouletteSelectHUIBA(this.percentHUIBA);
                    this.gBest.deepcopy(this.huiBA.get(num));
                }
                if (this.gen % 200 == 0) {
                    System.out.println("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\t" + this.gen + "-update end. HUIs No. is " + this.huiSets.size());
                }
                ++this.gen;
            }
        }
        this.writeOut();
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void pop_Init(double minUtility) {
        this.percentage = this.roulettePercent();
        System.out.println(this.percentage);
        int i = 0;
        while (i < 100) {
            BAIndividual tempBAIndividual = new BAIndividual();
            int j = 0;
            int k = (int)(Math.random() * (double)this.twuPattern.size());
            while (j < k) {
                int temp = this.rouletteSelect(this.percentage);
                if (tempBAIndividual.chrom.get(temp)) continue;
                ++j;
                tempBAIndividual.chrom.set(temp);
            }
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.pev_Check(tempBAIndividual, transList);
            tempBAIndividual.calculateFitness(k, transList);
            tempBAIndividual.freq = 0.0 + 1.0 * Math.random();
            tempBAIndividual.loudness = 0.0 + 2.0 * Math.random();
            tempBAIndividual.emissionrate = tempBAIndividual.initEmissionrate = Math.random();
            this.population.add(tempBAIndividual);
            if (this.population.get((int)i).fitness >= minUtility && this.population.get((int)i).chrom.cardinality() > 0) {
                this.insert(this.population.get(i));
                this.addHuiBA(this.population.get(i));
            }
            if (i == 0) {
                this.gBest.deepcopy(this.population.get(i));
            } else if (this.population.get((int)i).fitness >= this.gBest.fitness) {
                this.gBest.deepcopy(this.population.get(i));
            }
            ++i;
        }
    }

    private void next_Gen_BA(int minUtility) {
        int i = 0;
        while (i < 100) {
            int changeBit;
            int m;
            this.population.get((int)i).freq = 0.0 + 1.0 * Math.random();
            List<Integer> disList = this.bitDiff(this.gBest, this.population.get(i));
            int num = (int)((double)disList.size() * this.population.get((int)i).freq) + 1;
            if (disList.size() > 0) {
                m = 0;
                while (m < num) {
                    changeBit = (int)((double)disList.size() * Math.random());
                    if (this.population.get((int)i).chrom.get(disList.get(changeBit))) {
                        this.population.get((int)i).chrom.clear(disList.get(changeBit));
                    } else {
                        this.population.get((int)i).chrom.set(disList.get(changeBit));
                    }
                    ++m;
                }
            }
            m = 0;
            while (m < 1) {
                changeBit = (int)((double)this.twuPattern.size() * Math.random());
                if (this.population.get((int)i).chrom.get(changeBit)) {
                    this.population.get((int)i).chrom.clear(changeBit);
                } else {
                    this.population.get((int)i).chrom.set(changeBit);
                }
                ++m;
            }
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.pev_Check(this.population.get(i), transList);
            this.population.get(i).calculateFitness(this.population.get((int)i).chrom.cardinality(), transList);
            if (this.population.get((int)i).fitness >= (double)minUtility && this.population.get((int)i).chrom.cardinality() > 0) {
                this.insert(this.population.get(i));
                this.addHuiBA(this.population.get(i));
            }
            if (this.population.get((int)i).fitness > this.gBest.fitness) {
                this.gBest.deepcopy(this.population.get(i));
            }
            double rnd = Math.random();
            double sum = 0.0;
            m = 0;
            while (m < 100) {
                sum += this.population.get((int)m).loudness;
                ++m;
            }
            BAIndividual tmpBAIndividual = new BAIndividual();
            tmpBAIndividual.deepcopy(this.population.get(i));
            if (rnd > this.population.get((int)i).emissionrate) {
                int k = (int)(Math.random() * (double)this.twuPattern.size());
                if (tmpBAIndividual.chrom.get(k)) {
                    tmpBAIndividual.chrom.clear(k);
                } else {
                    tmpBAIndividual.chrom.set(k);
                }
            }
            transList = new ArrayList();
            this.pev_Check(tmpBAIndividual, transList);
            tmpBAIndividual.calculateFitness(tmpBAIndividual.chrom.cardinality(), transList);
            if (tmpBAIndividual.fitness >= (double)minUtility && tmpBAIndividual.chrom.cardinality() > 0) {
                this.insert(tmpBAIndividual);
                this.addHuiBA(tmpBAIndividual);
            }
            if (tmpBAIndividual.fitness > this.gBest.fitness) {
                this.gBest.deepcopy(tmpBAIndividual);
            }
            if (tmpBAIndividual.fitness < this.gBest.fitness && Math.random() < this.population.get((int)i).loudness) {
                this.population.get(i).deepcopy(tmpBAIndividual);
                this.population.get((int)i).loudness *= 0.8;
                this.population.get((int)i).emissionrate = this.population.get((int)i).initEmissionrate * (1.0 - Math.exp(-0.9 * (double)this.gen));
            }
            ++i;
        }
    }

    private List<Integer> bitDiff(BAIndividual gBest, BAIndividual tempBAIndividual) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        BitSet tmpBitSet = (BitSet)gBest.chrom.clone();
        tmpBitSet.xor(tempBAIndividual.chrom);
        int i = 0;
        while (i < tmpBitSet.length()) {
            if (tmpBitSet.get(i)) {
                list.add(i);
            }
            ++i;
        }
        return list;
    }

    public boolean pev_Check(BAIndividual tempBAIndividual, List<Integer> list) {
        ArrayList<Integer> templist = new ArrayList<Integer>();
        int i = 0;
        while (i < tempBAIndividual.chrom.length()) {
            if (tempBAIndividual.chrom.get(i)) {
                templist.add(i);
            }
            ++i;
        }
        if (templist.size() == 0) {
            return false;
        }
        BitSet tempBitSet = new BitSet(this.transactionCount);
        BitSet midBitSet = new BitSet(this.transactionCount);
        tempBitSet = (BitSet)this.Items.get((int)((Integer)templist.get((int)0)).intValue()).TIDS.clone();
        midBitSet = (BitSet)tempBitSet.clone();
        int i2 = 1;
        while (i2 < templist.size()) {
            tempBitSet.and(this.Items.get((int)((Integer)templist.get((int)i2)).intValue()).TIDS);
            if (tempBitSet.cardinality() != 0) {
                midBitSet = (BitSet)tempBitSet.clone();
            } else {
                tempBitSet = (BitSet)midBitSet.clone();
                tempBAIndividual.chrom.clear((Integer)templist.get(i2));
            }
            ++i2;
        }
        if (tempBitSet.cardinality() == 0) {
            return false;
        }
        int m = 0;
        while (m < this.transactionCount) {
            if (tempBitSet.get(m)) {
                list.add(m);
            }
            ++m;
        }
        return true;
    }

    private List<Double> roulettePercentHUIBA() {
        double sum = 0.0;
        double tempsum = 0.0;
        double percent = 0.0;
        ArrayList<Double> percentHUIBA = new ArrayList<Double>();
        int i = 0;
        while (i < this.huiBA.size()) {
            sum += this.huiBA.get((int)i).fitness;
            ++i;
        }
        i = 0;
        while (i < this.huiBA.size()) {
            percent = (tempsum += this.huiBA.get((int)i).fitness) / sum;
            percentHUIBA.add(percent);
            ++i;
        }
        return percentHUIBA;
    }

    private int rouletteSelectHUIBA(List<Double> percentage) {
        int temp = 0;
        double randNum = Math.random();
        int i = 0;
        while (i < percentage.size()) {
            if (i == 0) {
                if (randNum >= 0.0 && randNum <= percentage.get(0)) {
                    temp = 0;
                    break;
                }
            } else if (randNum > percentage.get(i - 1) && randNum <= percentage.get(i)) {
                temp = i;
                break;
            }
            ++i;
        }
        return temp;
    }

    private void addHuiBA(BAIndividual tempBAIndividual) {
        BAIndividual tmpBAIndividual = new BAIndividual();
        tmpBAIndividual.deepcopy(tempBAIndividual);
        if (this.huiBA.size() != 0) {
            int i = 0;
            while (i < this.huiBA.size()) {
                BitSet tmpBitSet = (BitSet)tmpBAIndividual.chrom.clone();
                tmpBitSet.xor(this.huiBA.get((int)i).chrom);
                if (tmpBitSet.cardinality() == 0) {
                    return;
                }
                ++i;
            }
        }
        this.huiBA.add(tmpBAIndividual);
    }

    private void insert(BAIndividual tempBAIndividual) {
        StringBuilder temp = new StringBuilder();
        int i = 0;
        while (i < this.twuPattern.size()) {
            if (tempBAIndividual.chrom.get(i)) {
                temp.append(this.twuPattern.get(i));
                temp.append(' ');
            }
            ++i;
        }
        if (this.huiSets.size() == 0) {
            this.huiSets.add(new HUI(temp.toString(), tempBAIndividual.fitness));
        } else {
            i = 0;
            while (i < this.huiSets.size()) {
                if (temp.toString().equals(this.huiSets.get((int)i).itemset)) break;
                ++i;
            }
            if (i == this.huiSets.size()) {
                this.huiSets.add(new HUI(temp.toString(), tempBAIndividual.fitness));
            }
        }
    }

    private List<Double> roulettePercent() {
        double sum = 0.0;
        double tempSum = 0.0;
        int i = 0;
        while (i < this.twuPattern.size()) {
            sum += (double)this.mapItemToTWU.get(this.twuPattern.get(i)).intValue();
            ++i;
        }
        i = 0;
        while (i < this.twuPattern.size()) {
            double tempPercent = (tempSum += (double)this.mapItemToTWU.get(this.twuPattern.get(i)).intValue()) / (sum + 0.0);
            this.percentage.add(tempPercent);
            ++i;
        }
        return this.percentage;
    }

    private int rouletteSelect(List<Double> percentage) {
        int temp = 0;
        double randNum = Math.random();
        int i = 0;
        while (i < percentage.size()) {
            if (i == 0) {
                if (randNum >= 0.0 && randNum <= percentage.get(0)) {
                    temp = 0;
                    break;
                }
            } else if (randNum > percentage.get(i - 1) && randNum <= percentage.get(i)) {
                temp = i;
                break;
            }
            ++i;
        }
        return temp;
    }

    private void writeOut() throws IOException {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.huiSets.size()) {
            buffer.append(this.huiSets.get((int)i).itemset);
            buffer.append("#UTIL: ");
            buffer.append(this.huiSets.get((int)i).fitness);
            if (i != this.huiSets.size() - 1) {
                buffer.append(System.lineSeparator());
            }
            ++i;
        }
        this.writer.write(buffer.toString());
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  HUIF-BA ALGORITHM v.2.36 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiSets.size());
        System.out.println("===================================================");
    }

    class BAIndividual {
        BitSet chrom;
        int velocity;
        double fitness;
        double freq;
        double loudness;
        double initEmissionrate;
        double emissionrate;

        public BAIndividual() {
            this.chrom = new BitSet(AlgoBio_HUIF_BA.this.twuPattern.size());
            this.velocity = 2;
        }

        public void deepcopy(BAIndividual tempBAIndividual) {
            this.chrom = (BitSet)tempBAIndividual.chrom.clone();
            this.velocity = tempBAIndividual.velocity;
            this.fitness = tempBAIndividual.fitness;
            this.freq = tempBAIndividual.freq;
            this.loudness = tempBAIndividual.loudness;
            this.initEmissionrate = tempBAIndividual.initEmissionrate;
            this.emissionrate = tempBAIndividual.emissionrate;
        }

        public void calculateFitness(int k, List<Integer> templist) {
            if (k == 0) {
                return;
            }
            int fitness = 0;
            int m = 0;
            while (m < templist.size()) {
                int p = templist.get(m);
                int i = 0;
                int q = 0;
                int temp = 0;
                int sum = 0;
                while (q < AlgoBio_HUIF_BA.this.database.get(p).size() && i < this.chrom.length()) {
                    if (this.chrom.get(i)) {
                        if (AlgoBio_HUIF_BA.this.database.get((int)p).get((int)q).item == AlgoBio_HUIF_BA.this.twuPattern.get(i)) {
                            sum += AlgoBio_HUIF_BA.this.database.get((int)p).get((int)q).utility;
                            ++i;
                            ++q;
                            ++temp;
                            continue;
                        }
                        ++q;
                        continue;
                    }
                    ++i;
                }
                if (temp == k) {
                    fitness += sum;
                }
                ++m;
            }
            this.fitness = fitness;
        }
    }

    class HUI {
        String itemset;
        double fitness;

        public HUI(String itemset2, double fitness) {
            this.fitness = fitness;
            this.itemset = itemset2;
        }
    }

    class Item {
        int item;
        BitSet TIDS;

        public Item() {
            this.TIDS = new BitSet(AlgoBio_HUIF_BA.this.transactionCount);
        }

        public Item(int item) {
            this.TIDS = new BitSet(AlgoBio_HUIF_BA.this.transactionCount);
            this.item = item;
        }
    }

    class ItemCompareBasedSup
    implements Comparator {
        ItemCompareBasedSup() {
        }

        public int compare(Object item1, Object item2) {
            if (item1 instanceof Integer) {
                return -(AlgoBio_HUIF_BA.this.mapItemToSup.get((Integer)item1) - AlgoBio_HUIF_BA.this.mapItemToSup.get((Integer)item2));
            }
            return -(AlgoBio_HUIF_BA.this.mapItemToSup.get(((Pair)item1).item) - AlgoBio_HUIF_BA.this.mapItemToSup.get(((Pair)item2).item));
        }
    }

    class ItemCompareBasedTWU
    implements Comparator {
        ItemCompareBasedTWU() {
        }

        public int compare(Object item1, Object item2) {
            if (item1 instanceof Integer) {
                return -(AlgoBio_HUIF_BA.this.mapItemToTWU.get((Integer)item1) - AlgoBio_HUIF_BA.this.mapItemToTWU.get((Integer)item2));
            }
            return -(AlgoBio_HUIF_BA.this.mapItemToTWU.get(((Pair)item1).item) - AlgoBio_HUIF_BA.this.mapItemToTWU.get(((Pair)item2).item));
        }
    }

    class ItemCompareBasedUtil
    implements Comparator {
        ItemCompareBasedUtil() {
        }

        public int compare(Object item1, Object item2) {
            if (item1 instanceof Integer) {
                return AlgoBio_HUIF_BA.this.mapItemToUtil.get((Integer)item1) - AlgoBio_HUIF_BA.this.mapItemToUtil.get((Integer)item2);
            }
            return AlgoBio_HUIF_BA.this.mapItemToUtil.get(((Pair)item1).item) - AlgoBio_HUIF_BA.this.mapItemToUtil.get(((Pair)item2).item);
        }
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

