/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.aprioriTID;

import ca.pfv.spmf.patterns.itemset_array_integers_with_tids_bitset.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoAprioriTID_Bitset {
    protected int k;
    Map<Integer, BitSet> mapItemTIDS = new HashMap<Integer, BitSet>();
    int minSuppRelative;
    int maxItemsetSize = Integer.MAX_VALUE;
    long startTimestamp = 0L;
    long endTimeStamp = 0L;
    BufferedWriter writer = null;
    private int itemsetCount;
    private int tidcount = 0;
    boolean showTransactionIdentifiers = false;

    public void runAlgorithm(String input, String output, double minsup) throws NumberFormatException, IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.itemsetCount = 0;
        this.writer = new BufferedWriter(new FileWriter(output));
        this.tidcount = 0;
        this.mapItemTIDS = new HashMap<Integer, BitSet>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            MemoryLogger.getInstance().checkMemory();
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] stringArray = lineSplited = line.split(" ");
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String stringItem = stringArray[n2];
                int item = Integer.parseInt(stringItem);
                BitSet tids = this.mapItemTIDS.get(item);
                if (tids == null) {
                    tids = new BitSet();
                    this.mapItemTIDS.put(item, tids);
                }
                tids.set(this.tidcount);
                ++n2;
            }
            ++this.tidcount;
        }
        reader.close();
        this.minSuppRelative = (int)Math.ceil(minsup * (double)this.tidcount);
        this.k = 1;
        List<Itemset> level = new ArrayList<Itemset>();
        Iterator<Map.Entry<Integer, BitSet>> iterator = this.mapItemTIDS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, BitSet> entry = iterator.next();
            int cardinality = entry.getValue().cardinality();
            if (cardinality >= this.minSuppRelative && this.maxItemsetSize >= 1) {
                Integer item = entry.getKey();
                Itemset itemset2 = new Itemset(item);
                itemset2.setTIDs(this.mapItemTIDS.get(item), cardinality);
                level.add(itemset2);
                this.saveItemsetToFile(itemset2);
                continue;
            }
            iterator.remove();
        }
        Collections.sort(level, new Comparator<Itemset>(){

            @Override
            public int compare(Itemset o1, Itemset o2) {
                return o1.get(0) - o2.get(0);
            }
        });
        this.k = 2;
        while (!level.isEmpty() && this.k <= this.maxItemsetSize) {
            level = this.generateCandidateSizeK(level);
            ++this.k;
        }
        this.writer.close();
        this.endTimeStamp = System.currentTimeMillis();
    }

    protected List<Itemset> generateCandidateSizeK(List<Itemset> levelK_1) throws IOException {
        ArrayList<Itemset> candidates = new ArrayList<Itemset>();
        int i = 0;
        while (i < levelK_1.size()) {
            Itemset itemset1 = levelK_1.get(i);
            int j = i + 1;
            block1: while (j < levelK_1.size()) {
                block8: {
                    Itemset itemset2 = levelK_1.get(j);
                    int k = 0;
                    while (k < itemset1.size()) {
                        if (k == itemset1.size() - 1) {
                            if (itemset1.getItems()[k] >= itemset2.get(k)) {
                                break block1;
                            }
                        } else {
                            if (itemset1.getItems()[k] >= itemset2.get(k)) {
                                if (itemset1.getItems()[k] > itemset2.get(k)) break block1;
                            }
                            break block8;
                        }
                        ++k;
                    }
                    Integer missing = itemset2.get(itemset2.size() - 1);
                    BitSet list = (BitSet)itemset1.getTransactionsIds().clone();
                    list.and(itemset2.getTransactionsIds());
                    int cardinality = list.cardinality();
                    if (cardinality >= this.minSuppRelative) {
                        int[] newItemset = new int[itemset1.size() + 1];
                        System.arraycopy(itemset1.itemset, 0, newItemset, 0, itemset1.size());
                        newItemset[itemset1.size()] = itemset2.getItems()[itemset2.size() - 1];
                        Itemset candidate = new Itemset(newItemset);
                        candidate.setTIDs(list, cardinality);
                        candidates.add(candidate);
                        this.saveItemsetToFile(candidate);
                    }
                }
                ++j;
            }
            ++i;
        }
        return candidates;
    }

    public void setMaxItemsetSize(int maxItemsetSize) {
        this.maxItemsetSize = maxItemsetSize;
    }

    void saveItemsetToFile(Itemset itemset2) throws IOException {
        this.writer.write(String.valueOf(itemset2.toString()) + " #SUP: " + itemset2.cardinality);
        if (this.showTransactionIdentifiers) {
            this.writer.append(" #TID:");
            BitSet transactionIDs = itemset2.getTransactionsIds();
            int tid = transactionIDs.nextSetBit(0);
            while (tid != -1) {
                this.writer.append(" " + tid);
                tid = transactionIDs.nextSetBit(tid + 1);
            }
        }
        this.writer.newLine();
        ++this.itemsetCount;
    }

    public void setShowTransactionIdentifiers(boolean showTransactionIdentifiers) {
        this.showTransactionIdentifiers = showTransactionIdentifiers;
    }

    public void printStats() {
        System.out.println("=============  APRIORI TID BITSET v2.12 - STATS =============");
        System.out.println(" Transactions count from database : " + this.tidcount);
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ " + (this.endTimeStamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }

    public void setMaximumPatternLength(int length) {
        this.maxItemsetSize = length;
    }
}

