/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.UFH;

import ca.pfv.spmf.algorithms.frequentpatterns.UFH.EFIM_UP_Tree_Transaction_SPMF;
import ca.pfv.spmf.algorithms.frequentpatterns.UFH.Item_SPMF;
import ca.pfv.spmf.algorithms.frequentpatterns.UFH.UPNode_SPMF;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UPTree_SPMF {
    List<Integer> headerList = null;
    boolean hasMoreThanOnePath = false;
    Map<Integer, UPNode_SPMF> mapItemNodes = new HashMap<Integer, UPNode_SPMF>();
    UPNode_SPMF root = new UPNode_SPMF();
    Map<Integer, UPNode_SPMF> mapItemLastNode = new HashMap<Integer, UPNode_SPMF>();

    public void addTransaction(List<Item_SPMF> transaction, int RTU) {
        UPNode_SPMF currentNode = this.root;
        int i = 0;
        int RemainingUtility = 0;
        int size = transaction.size();
        i = 0;
        while (i < size) {
            int k = i + 1;
            while (k < transaction.size()) {
                RemainingUtility += transaction.get(k).getUtility();
                ++k;
            }
            int item = transaction.get(i).getName();
            int utility = transaction.get(i).getUtility();
            UPNode_SPMF child = currentNode.getChildWithID(item);
            if (child == null) {
                int nodeUtility = RTU - RemainingUtility;
                RemainingUtility = 0;
                currentNode = this.insertNewNode(currentNode, item, nodeUtility, -1, true, utility);
            } else {
                int currentNU = child.nodeUtility;
                int nodeUtility = currentNU + (RTU - RemainingUtility);
                RemainingUtility = 0;
                ++child.count;
                child.nodeUtility = nodeUtility;
                currentNode = child;
                if (child.min_node_utility > utility) {
                    child.min_node_utility = utility;
                }
            }
            ++i;
        }
    }

    public void addTransaction(EFIM_UP_Tree_Transaction_SPMF transaction, int RTU) {
        UPNode_SPMF currentNode = this.root;
        int i = 0;
        int RemainingUtility = 0;
        i = transaction.getItems().length - 1;
        while (i >= 0) {
            int k = i - 1;
            while (k >= 0) {
                RemainingUtility += transaction.getUtilities()[k];
                --k;
            }
            int item = transaction.getItems()[i];
            int utility = transaction.getUtilities()[i];
            UPNode_SPMF child = currentNode.getChildWithID(item);
            if (child == null) {
                int nodeUtility = RTU - RemainingUtility;
                RemainingUtility = 0;
                currentNode = this.insertNewNode(currentNode, item, nodeUtility, -1, true, utility);
            } else {
                int currentNU = child.nodeUtility;
                int nodeUtility = currentNU + (RTU - RemainingUtility);
                RemainingUtility = 0;
                ++child.count;
                child.nodeUtility = nodeUtility;
                currentNode = child;
                if (child.min_node_utility > utility) {
                    child.min_node_utility = utility;
                }
            }
            --i;
        }
    }

    public void addLocalTransaction(List<UPNode_SPMF> localPath, int pathUtility, Map<Integer, Integer> mapMinimumItemUtility, int pathCount) {
        UPNode_SPMF currentlocalNode = this.root;
        int i = 0;
        int RemainingUtility = 0;
        int size = localPath.size();
        i = size - 1;
        while (i >= 0) {
            int k = i - 1;
            while (k >= 0) {
                UPNode_SPMF search = localPath.get(k);
                RemainingUtility += search.min_node_utility * pathCount;
                --k;
            }
            int item = localPath.get((int)i).itemID;
            UPNode_SPMF child = currentlocalNode.getChildWithID(item);
            if (child == null) {
                int nodeUtility = pathUtility - RemainingUtility;
                RemainingUtility = 0;
                currentlocalNode = this.insertNewNode(currentlocalNode, item, nodeUtility, pathCount, false, localPath.get((int)i).min_node_utility);
            } else {
                int currentNU = child.nodeUtility;
                int nodeUtility = currentNU + (pathUtility - RemainingUtility);
                RemainingUtility = 0;
                child.count += pathCount;
                child.nodeUtility = nodeUtility;
                currentlocalNode = child;
                if (child.min_node_utility > localPath.get((int)i).min_node_utility || child.min_node_utility == 0) {
                    child.min_node_utility = localPath.get((int)i).min_node_utility;
                }
            }
            --i;
        }
    }

    private UPNode_SPMF insertNewNode(UPNode_SPMF currentlocalNode, int item, int nodeUtility, int pathCount, boolean global, int min_utility) {
        UPNode_SPMF localheadernode;
        UPNode_SPMF newNode = new UPNode_SPMF();
        newNode.itemID = item;
        newNode.nodeUtility = nodeUtility;
        newNode.min_node_utility = min_utility;
        newNode.count = global ? 1 : pathCount;
        newNode.parent = currentlocalNode;
        currentlocalNode.childs.add(newNode);
        if (!this.hasMoreThanOnePath && currentlocalNode.childs.size() > 1) {
            this.hasMoreThanOnePath = true;
        }
        if ((localheadernode = this.mapItemNodes.get(item)) == null) {
            this.mapItemNodes.put(item, newNode);
            this.mapItemLastNode.put(item, newNode);
        } else {
            UPNode_SPMF lastNode = this.mapItemLastNode.get(item);
            lastNode.nodeLink = newNode;
            this.mapItemLastNode.put(item, newNode);
        }
        return newNode;
    }

    void createHeaderList(final Map<Integer, Integer> mapItemToEstimatedUtility, final int[] n) {
        this.headerList = new ArrayList<Integer>(this.mapItemNodes.keySet());
        Collections.sort(this.headerList, new Comparator<Integer>(){

            @Override
            public int compare(Integer id1, Integer id2) {
                if ((Integer)mapItemToEstimatedUtility.get(n[id1]) > (Integer)mapItemToEstimatedUtility.get(n[id2])) {
                    return -1;
                }
                if ((Integer)mapItemToEstimatedUtility.get(n[id1]) < (Integer)mapItemToEstimatedUtility.get(n[id2])) {
                    return 1;
                }
                if (n[id1] > n[id2]) {
                    return -1;
                }
                return 1;
            }
        });
    }

    public String toString() {
        String output = "";
        output = String.valueOf(output) + "HEADER TABLE: " + this.mapItemNodes + " \n";
        output = String.valueOf(output) + "hasMoreThanOnePath: " + this.hasMoreThanOnePath + " \n";
        return String.valueOf(output) + this.toString("", this.root);
    }

    public String toString(String indent, UPNode_SPMF node) {
        String output = String.valueOf(indent) + node.toString() + "\n";
        String childsOutput = "";
        for (UPNode_SPMF child : node.childs) {
            childsOutput = String.valueOf(childsOutput) + this.toString(String.valueOf(indent) + " ", child);
        }
        return String.valueOf(output) + childsOutput;
    }
}

