/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.UFH;

import java.util.Map;

public class EFIM_UP_Tree_Transaction_SPMF {
    public static int[] tempItems = new int[2000];
    public static int[] tempUtilities = new int[2000];
    int offset;
    int[] items;
    int[] utilities;
    int transactionUtility;
    int prefixUtility;

    public EFIM_UP_Tree_Transaction_SPMF(int[] items, int[] utilities, int transactionUtility) {
        this.items = items;
        this.utilities = utilities;
        this.transactionUtility = transactionUtility;
        this.offset = 0;
        this.prefixUtility = 0;
    }

    public EFIM_UP_Tree_Transaction_SPMF(EFIM_UP_Tree_Transaction_SPMF transaction, int offsetE) {
        this.items = transaction.getItems();
        this.utilities = transaction.getUtilities();
        int utilityE = this.utilities[offsetE];
        this.prefixUtility = transaction.prefixUtility + utilityE;
        this.transactionUtility = transaction.transactionUtility - utilityE;
        int i = transaction.offset;
        while (i < offsetE) {
            this.transactionUtility -= transaction.utilities[i];
            ++i;
        }
        this.offset = offsetE + 1;
    }

    public EFIM_UP_Tree_Transaction_SPMF(EFIM_UP_Tree_Transaction_SPMF transaction) {
        this.items = transaction.getItems();
        this.utilities = transaction.getUtilities();
        this.prefixUtility = transaction.prefixUtility;
        this.transactionUtility = transaction.transactionUtility;
        this.offset = transaction.offset;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int i = this.offset;
        while (i < this.items.length) {
            buffer.append(this.items[i]);
            buffer.append("[");
            buffer.append(this.utilities[i]);
            buffer.append("] ");
            ++i;
        }
        buffer.append(" Remaining Utility:" + this.transactionUtility);
        buffer.append(" Prefix Utility:" + this.prefixUtility);
        return buffer.toString();
    }

    public int[] getItems() {
        return this.items;
    }

    public int[] getUtilities() {
        return this.utilities;
    }

    public int getLastPosition() {
        return this.items.length - 1;
    }

    public void removeUnpromisingItems(int[] oldNamesToNewNames) {
        int i = 0;
        int j = 0;
        while (j < this.items.length) {
            int item = this.items[j];
            int newName = oldNamesToNewNames[item];
            if (newName != 0) {
                EFIM_UP_Tree_Transaction_SPMF.tempItems[i] = newName;
                EFIM_UP_Tree_Transaction_SPMF.tempUtilities[i] = this.utilities[j];
                ++i;
            } else {
                this.transactionUtility -= this.utilities[j];
            }
            ++j;
        }
        this.items = new int[i];
        System.arraycopy(tempItems, 0, this.items, 0, i);
        this.utilities = new int[i];
        System.arraycopy(tempUtilities, 0, this.utilities, 0, i);
        EFIM_UP_Tree_Transaction_SPMF.insertionSort(this.items, this.utilities);
    }

    public void removeUnpromisingItems(Map<Integer, Integer> mapItemToTWU, int threshold) {
        int i = 0;
        int j = 0;
        while (j < this.items.length) {
            int item = this.items[j];
            if (mapItemToTWU.get(item) >= threshold) {
                EFIM_UP_Tree_Transaction_SPMF.tempItems[i] = item;
                EFIM_UP_Tree_Transaction_SPMF.tempUtilities[i] = this.utilities[j];
                ++i;
            } else {
                this.transactionUtility -= this.utilities[j];
            }
            ++j;
        }
        this.items = new int[i];
        System.arraycopy(tempItems, 0, this.items, 0, i);
        this.utilities = new int[i];
        System.arraycopy(tempUtilities, 0, this.utilities, 0, i);
        EFIM_UP_Tree_Transaction_SPMF.insertionSort(this.items, this.utilities);
    }

    public static void insertionSort(int[] items, int[] utitilies) {
        int j = 1;
        while (j < items.length) {
            int itemJ = items[j];
            int utilityJ = utitilies[j];
            int i = j - 1;
            while (i >= 0 && items[i] > itemJ) {
                items[i + 1] = items[i];
                utitilies[i + 1] = utitilies[i];
                --i;
            }
            items[i + 1] = itemJ;
            utitilies[i + 1] = utilityJ;
            ++j;
        }
    }
}

