/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.HUIM_GA;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoHUIM_GA {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    final int pop_size = 20;
    final int iterations = 10000;
    Map<Integer, Integer> mapItemToTWU;
    Map<Integer, Integer> mapItemToTWU0;
    List<Integer> twuPattern;
    BufferedWriter writer = null;
    List<ChroNode> population = new ArrayList<ChroNode>();
    List<ChroNode> subPopulation = new ArrayList<ChroNode>();
    List<HUI> huiSets = new ArrayList<HUI>();
    List<List<Pair>> database = new ArrayList<List<Pair>>();
    List<Double> percentage = new ArrayList<Double>();

    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        block30: {
            String[] items;
            String[] split;
            String thisLine;
            BufferedReader myInput;
            block28: {
                this.maxMemory = 0.0;
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToTWU = new HashMap<Integer, Integer>();
                this.mapItemToTWU0 = new HashMap<Integer, Integer>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            split = thisLine.split(":");
                            items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer twu = this.mapItemToTWU.get(item);
                                Integer twu0 = this.mapItemToTWU0.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                twu0 = twu0 == null ? transactionUtility : twu0 + transactionUtility;
                                this.mapItemToTWU.put(item, twu);
                                this.mapItemToTWU0.put(item, twu0);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        split = thisLine.split(":");
                        items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        ArrayList<Integer> pattern = new ArrayList<Integer>();
                        int i = 0;
                        while (i < items.length) {
                            Pair pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            if (this.mapItemToTWU.get(pair.item) >= minUtility) {
                                revisedTransaction.add(pair);
                                pattern.add(pair.item);
                            } else {
                                this.mapItemToTWU0.remove(pair.item);
                            }
                            ++i;
                        }
                        this.database.add(revisedTransaction);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.twuPattern = new ArrayList<Integer>(this.mapItemToTWU0.keySet());
        Collections.sort(this.twuPattern);
        this.checkMemory();
        if (this.twuPattern.size() > 0) {
            double pMax;
            double pMin;
            int m = this.database.size();
            int n = this.twuPattern.size();
            int temp1 = 0;
            int temp2 = 0;
            this.generatePop(minUtility);
            if (m > n) {
                pMin = 1.0 / ((double)m + 0.0);
                pMax = 1.0 / ((double)n + 0.0);
            } else {
                pMin = 1.0 / ((double)n + 0.0);
                pMax = 1.0 / ((double)m + 0.0);
            }
            int i = 0;
            while (i < 10000) {
                this.calculateRfitness();
                while (this.subPopulation.size() < 20) {
                    temp1 = this.selectChromosome();
                    temp2 = this.selectChromosome();
                    while (temp1 == temp2) {
                        temp2 = this.selectChromosome();
                    }
                    this.crossover(temp1, temp2, minUtility);
                }
                this.subPopulation = this.rankedMutation(pMax, pMin, i, minUtility);
                this.subPopulation.addAll(this.population);
                this.rankData(this.subPopulation);
                int j = 0;
                while (j < this.population.size()) {
                    this.population.set(j, this.subPopulation.get(j));
                    ++j;
                }
                this.subPopulation.clear();
                ++i;
            }
        }
        this.writeOut();
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void generatePop(int minUtility) {
        int i = 0;
        this.percentage = this.roulettePercent();
        while (i < 20) {
            ChroNode tempNode = new ChroNode(this.twuPattern.size());
            int j = 0;
            int k = (int)(Math.random() * (double)this.twuPattern.size());
            while (j < k) {
                int temp = this.select(this.percentage);
                if (tempNode.chromosome.get(temp) != 0) continue;
                ++j;
                tempNode.chromosome.set(temp, 1);
            }
            tempNode.fitness = this.fitCalculate(tempNode.chromosome, k);
            tempNode.rank = 0;
            this.population.add(tempNode);
            if (tempNode.fitness >= minUtility) {
                this.insert(tempNode);
            }
            ++i;
        }
    }

    private List<Double> roulettePercent() {
        int sum = 0;
        int tempSum = 0;
        int i = 0;
        while (i < this.twuPattern.size()) {
            sum += this.mapItemToTWU.get(this.twuPattern.get(i)).intValue();
            ++i;
        }
        i = 0;
        while (i < this.twuPattern.size()) {
            double tempPercent = (double)(tempSum += this.mapItemToTWU.get(this.twuPattern.get(i)).intValue()) / ((double)sum + 0.0);
            this.percentage.add(tempPercent);
            ++i;
        }
        return this.percentage;
    }

    private int select(List<Double> percentage) {
        int temp = 0;
        double randNum = Math.random();
        int i = 0;
        while (i < percentage.size()) {
            if (i == 0) {
                if (randNum >= 0.0 && randNum <= percentage.get(0)) {
                    temp = 0;
                    break;
                }
            } else if (randNum > percentage.get(i - 1) && randNum <= percentage.get(i)) {
                temp = i;
                break;
            }
            ++i;
        }
        return temp;
    }

    private void crossover(int temp1, int temp2, int minUtility) {
        int i = 0;
        int tempA = 0;
        int tempB = 0;
        ArrayList<Integer> temp1Chro = new ArrayList<Integer>();
        ArrayList<Integer> temp2Chro = new ArrayList<Integer>();
        ChroNode tempNode = new ChroNode();
        int position = (int)(Math.random() * (double)this.twuPattern.size());
        i = 0;
        while (i < this.twuPattern.size()) {
            if (i <= position) {
                temp1Chro.add(this.population.get((int)temp2).chromosome.get(i));
                if ((Integer)temp1Chro.get(i) == 1) {
                    ++tempA;
                }
                temp2Chro.add(this.population.get((int)temp1).chromosome.get(i));
                if ((Integer)temp2Chro.get(i) == 1) {
                    ++tempB;
                }
            } else {
                temp1Chro.add(this.population.get((int)temp1).chromosome.get(i));
                if ((Integer)temp1Chro.get(i) == 1) {
                    ++tempA;
                }
                temp2Chro.add(this.population.get((int)temp2).chromosome.get(i));
                if ((Integer)temp2Chro.get(i) == 1) {
                    ++tempB;
                }
            }
            ++i;
        }
        tempNode.chromosome = temp1Chro;
        tempNode.fitness = this.fitCalculate(temp1Chro, tempA);
        tempNode.rank = 0;
        this.subPopulation.add(tempNode);
        if (tempNode.fitness >= minUtility) {
            this.insert(tempNode);
        }
        tempNode.chromosome = temp2Chro;
        tempNode.fitness = this.fitCalculate(temp2Chro, tempB);
        tempNode.rank = 0;
        this.subPopulation.add(tempNode);
        if (tempNode.fitness >= minUtility) {
            this.insert(tempNode);
        }
    }

    private void rankData(List<ChroNode> tempPop) {
        int i = 0;
        while (i < tempPop.size() - 1) {
            int p = i;
            int j = i + 1;
            while (j < tempPop.size()) {
                if (tempPop.get((int)p).fitness < tempPop.get((int)j).fitness) {
                    p = j;
                }
                ++j;
            }
            if (i != p) {
                int temp = tempPop.get((int)i).fitness;
                tempPop.get((int)i).fitness = tempPop.get((int)p).fitness;
                tempPop.get((int)p).fitness = temp;
                int q = 0;
                while (q < this.twuPattern.size()) {
                    temp = tempPop.get((int)i).chromosome.get(q);
                    tempPop.get((int)i).chromosome.set(q, tempPop.get((int)p).chromosome.get(q));
                    tempPop.get((int)p).chromosome.set(q, temp);
                    ++q;
                }
            }
            tempPop.get((int)i).rank = i + 1;
            ++i;
        }
        tempPop.get((int)i).rank = i + 1;
    }

    private List<Integer> getRank() {
        ArrayList<Integer> rank = new ArrayList<Integer>();
        int i = 0;
        while (i < this.subPopulation.size()) {
            int temp = 0;
            int j = 0;
            while (j < this.subPopulation.size()) {
                if (i != j && this.subPopulation.get((int)i).fitness <= this.subPopulation.get((int)j).fitness) {
                    ++temp;
                }
                ++j;
            }
            rank.add(temp + 1);
            ++i;
        }
        return rank;
    }

    private List<ChroNode> rankedMutation(double pMax, double pMin, int currentIteration, int minUtility) {
        List<Integer> record = this.getRank();
        int i = 0;
        while (i < 20) {
            double pm = (pMax - (pMax - pMin) * (double)currentIteration / 10000.0) * (double)record.get(i).intValue() / (double)this.subPopulation.size();
            double rankNum = Math.random();
            if (rankNum < pm) {
                int temp = (int)(Math.random() * (double)this.twuPattern.size());
                if (this.subPopulation.get((int)i).chromosome.get(temp) == 1) {
                    this.subPopulation.get((int)i).chromosome.set(temp, 0);
                } else {
                    this.subPopulation.get((int)i).chromosome.set(temp, 1);
                }
                int k = 0;
                int j = 0;
                while (j < this.twuPattern.size()) {
                    if (this.subPopulation.get((int)i).chromosome.get(j) == 1) {
                        ++k;
                    }
                    ++j;
                }
                this.subPopulation.get((int)i).fitness = this.fitCalculate(this.subPopulation.get((int)i).chromosome, k);
                if (this.subPopulation.get((int)i).fitness >= minUtility) {
                    this.insert(this.subPopulation.get(i));
                }
            }
            ++i;
        }
        return this.subPopulation;
    }

    private void insert(ChroNode tempChroNode) {
        StringBuilder temp = new StringBuilder();
        int i = 0;
        while (i < this.twuPattern.size()) {
            if (tempChroNode.chromosome.get(i) == 1) {
                temp.append(this.twuPattern.get(i));
                temp.append(' ');
            }
            ++i;
        }
        if (this.huiSets.size() == 0) {
            this.huiSets.add(new HUI(temp.toString(), tempChroNode.fitness));
        } else {
            i = 0;
            while (i < this.huiSets.size()) {
                if (temp.toString().equals(this.huiSets.get((int)i).itemset)) break;
                ++i;
            }
            if (i == this.huiSets.size()) {
                this.huiSets.add(new HUI(temp.toString(), tempChroNode.fitness));
            }
        }
    }

    private int fitCalculate(List<Integer> tempChroNode, int k) {
        if (k == 0) {
            return 0;
        }
        int fitness = 0;
        int p = 0;
        while (p < this.database.size()) {
            int i = 0;
            int j = 0;
            int q = 0;
            int temp = 0;
            int sum = 0;
            while (j < k && q < this.database.get(p).size() && i < tempChroNode.size()) {
                if (tempChroNode.get(i) == 1) {
                    if (this.database.get((int)p).get((int)q).item < this.twuPattern.get(i)) {
                        ++q;
                        continue;
                    }
                    if (this.database.get((int)p).get((int)q).item == this.twuPattern.get(i)) {
                        sum += this.database.get((int)p).get((int)q).utility;
                        ++j;
                        ++q;
                        ++temp;
                        ++i;
                        continue;
                    }
                    if (this.database.get((int)p).get((int)q).item <= this.twuPattern.get(i)) continue;
                    ++j;
                    ++i;
                    continue;
                }
                ++i;
            }
            if (temp == k) {
                fitness += sum;
            }
            ++p;
        }
        return fitness;
    }

    public void calculateRfitness() {
        int sum = 0;
        int temp = 0;
        int i = 0;
        while (i < this.population.size()) {
            sum += this.population.get((int)i).fitness;
            ++i;
        }
        i = 0;
        while (i < this.population.size()) {
            this.population.get((int)i).rfitness = (double)(temp += this.population.get((int)i).fitness) / ((double)sum + 0.0);
            ++i;
        }
    }

    private int selectChromosome() {
        int temp = 0;
        double randNum = Math.random();
        int i = 0;
        while (i < this.population.size()) {
            if (i == 0) {
                if (randNum >= 0.0 && randNum <= this.population.get((int)0).rfitness) {
                    temp = 0;
                    break;
                }
            } else if (randNum > this.population.get((int)(i - 1)).rfitness && randNum <= this.population.get((int)i).rfitness) {
                temp = i;
                break;
            }
            ++i;
        }
        return temp;
    }

    private void writeOut() throws IOException {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.huiSets.size()) {
            buffer.append(this.huiSets.get((int)i).itemset);
            buffer.append("#UTIL: ");
            buffer.append(this.huiSets.get((int)i).fitness);
            buffer.append(System.lineSeparator());
            ++i;
        }
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  HUIM-GA ALGORITHM v.2.11 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiSets.size());
        System.out.println("===================================================");
    }

    class ChroNode {
        List<Integer> chromosome = new ArrayList<Integer>();
        int fitness;
        double rfitness;
        int rank;

        public ChroNode() {
        }

        public ChroNode(int length) {
            int i = 0;
            while (i < length) {
                this.chromosome.add(i, 0);
                ++i;
            }
        }
    }

    class HUI {
        String itemset;
        int fitness;

        public HUI(String itemset2, int fitness) {
            this.itemset = itemset2;
            this.fitness = fitness;
        }
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

