/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.HUIM_BPSO_tree;

import ca.pfv.spmf.algorithms.frequentpatterns.HUIM_BPSO_tree.treeNode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoHUIM_BPSO_tree {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    final int pop_size = 20;
    final int iterations = 2000;
    final int c1 = 2;
    final int c2 = 2;
    final double w = 0.9;
    Map<Integer, Integer> mapItemToTWU;
    Map<Integer, Integer> mapItemToTWU0;
    List<Integer> twuPattern;
    BufferedWriter writer = null;
    Particle gBest = new Particle();
    List<Particle> pBest = new ArrayList<Particle>();
    List<Particle> population = new ArrayList<Particle>();
    List<HUI> huiSets = new ArrayList<HUI>();
    List<List<Double>> V = new ArrayList<List<Double>>();
    List<List<Pair>> database = new ArrayList<List<Pair>>();
    List<List<Integer>> maximalPatterns = new ArrayList<List<Integer>>();
    treeNode orNorTree;

    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        block26: {
            String[] items;
            String[] split;
            String thisLine;
            BufferedReader myInput;
            block24: {
                this.maxMemory = 0.0;
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToTWU = new HashMap<Integer, Integer>();
                this.mapItemToTWU0 = new HashMap<Integer, Integer>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            split = thisLine.split(":");
                            items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer twu = this.mapItemToTWU.get(item);
                                Integer twu0 = this.mapItemToTWU0.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                twu0 = twu0 == null ? transactionUtility : twu0 + transactionUtility;
                                this.mapItemToTWU.put(item, twu);
                                this.mapItemToTWU0.put(item, twu0);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        split = thisLine.split(":");
                        items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        ArrayList<Integer> pattern = new ArrayList<Integer>();
                        int i = 0;
                        while (i < items.length) {
                            Pair pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            if (this.mapItemToTWU.get(pair.item) >= minUtility) {
                                revisedTransaction.add(pair);
                                pattern.add(pair.item);
                            } else {
                                this.mapItemToTWU0.remove(pair.item);
                            }
                            ++i;
                        }
                        this.database.add(revisedTransaction);
                        this.maximalJudge(pattern);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.twuPattern = new ArrayList<Integer>(this.mapItemToTWU0.keySet());
        Collections.sort(this.twuPattern);
        int i = 0;
        while (i < 20) {
            this.pBest.add(new Particle(this.twuPattern.size()));
            ++i;
        }
        this.gBest = new Particle(this.twuPattern.size());
        this.checkMemory();
        if (this.twuPattern.size() > 0) {
            this.orNorTree = this.initialTree(this.twuPattern);
            this.generatePop(minUtility);
            i = 0;
            while (i < 2000) {
                this.update(minUtility);
                ++i;
            }
        }
        this.writeOut();
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void maximalJudge(List<Integer> pattern) {
        if (this.maximalPatterns.size() == 0) {
            this.maximalPatterns.add(pattern);
        } else {
            int i = 0;
            while (i < this.maximalPatterns.size()) {
                List<Integer> tempPattern = this.maximalPatterns.get(i);
                int j = 0;
                int k = 0;
                int temp = 0;
                while (j < pattern.size() && k < tempPattern.size()) {
                    if (pattern.get(j) < tempPattern.get(k)) {
                        ++j;
                        continue;
                    }
                    if (pattern.get(j) > tempPattern.get(k)) {
                        ++k;
                        continue;
                    }
                    ++j;
                    ++k;
                    ++temp;
                }
                if (temp == pattern.size() || temp == tempPattern.size()) {
                    if (pattern.size() <= tempPattern.size()) break;
                    this.maximalPatterns.remove(i);
                    this.maximalPatterns.add(pattern);
                    break;
                }
                ++i;
            }
            if (i == this.maximalPatterns.size()) {
                this.maximalPatterns.add(pattern);
            }
        }
    }

    private treeNode initialTree(List<Integer> htwuiList) {
        treeNode root = new treeNode(htwuiList.get(0));
        int i = 0;
        while (i < this.maximalPatterns.size()) {
            treeNode currentNode = root;
            List<Integer> tempPattern = this.maximalPatterns.get(i);
            int j = 0;
            int k = 0;
            while (k < htwuiList.size()) {
                treeNode leafNode;
                if (j < tempPattern.size()) {
                    if (tempPattern.get(j) > htwuiList.get(k)) {
                        if (currentNode.NOR == null) {
                            leafNode = k + 1 < htwuiList.size() ? new treeNode(htwuiList.get(k + 1)) : new treeNode(-1);
                            currentNode.NOR = leafNode;
                        }
                        ++k;
                        currentNode = currentNode.NOR;
                        continue;
                    }
                    if (currentNode.OR == null) {
                        leafNode = k + 1 < htwuiList.size() ? new treeNode(htwuiList.get(k + 1)) : new treeNode(-1);
                        currentNode.OR = leafNode;
                    }
                    ++k;
                    ++j;
                    currentNode = currentNode.OR;
                    continue;
                }
                if (currentNode.NOR == null) {
                    leafNode = k + 1 < htwuiList.size() ? new treeNode(htwuiList.get(k + 1)) : new treeNode(-1);
                    currentNode.NOR = leafNode;
                }
                currentNode = currentNode.NOR;
                ++k;
            }
            ++i;
        }
        return root;
    }

    private void generatePop(int minUtility) {
        int i = 0;
        while (i < 20) {
            Particle tempParticle = new Particle(this.twuPattern.size());
            tempParticle = this.particleInitial(tempParticle);
            int k = 0;
            int j = 0;
            while (j < this.twuPattern.size()) {
                if (tempParticle.X.get(j) == 1) {
                    ++k;
                }
                ++j;
            }
            tempParticle.fitness = this.fitCalculate(tempParticle.X, k);
            this.population.add(i, tempParticle);
            this.pBest.get(i).copyParticle(tempParticle);
            if (this.population.get((int)i).fitness >= minUtility) {
                this.insert(this.population.get(i));
            }
            if (i == 0) {
                this.gBest.copyParticle(this.pBest.get(i));
            } else if (this.pBest.get((int)i).fitness > this.gBest.fitness) {
                this.gBest.copyParticle(this.pBest.get(i));
            }
            ArrayList<Double> tempV = new ArrayList<Double>();
            j = 0;
            while (j < this.twuPattern.size()) {
                tempV.add(j, Math.random());
                ++j;
            }
            this.V.add(i, tempV);
            ++i;
        }
    }

    private void update(int minUtility) {
        int i = 0;
        while (i < 20) {
            int k = 0;
            double r1 = Math.random();
            double r2 = Math.random();
            int j = 0;
            while (j < this.twuPattern.size()) {
                double temp = this.V.get(i).get(j) + r1 * (double)(this.pBest.get((int)i).X.get(j) - this.population.get((int)i).X.get(j)) + r2 * (double)(this.gBest.X.get(j) - this.population.get((int)i).X.get(j));
                this.V.get(i).set(j, temp);
                if (this.V.get(i).get(j) < -2.0) {
                    this.V.get(i).set(j, -2.0);
                } else if (this.V.get(i).get(j) > 2.0) {
                    this.V.get(i).set(j, 2.0);
                }
                ++j;
            }
            this.population.set(i, this.particleUpdate(this.population.get(i), i));
            j = 0;
            while (j < this.twuPattern.size()) {
                if (this.population.get((int)i).X.get(j) == 1) {
                    ++k;
                }
                ++j;
            }
            this.population.get((int)i).fitness = this.fitCalculate(this.population.get((int)i).X, k);
            if (this.population.get((int)i).fitness > this.pBest.get((int)i).fitness) {
                this.pBest.get(i).copyParticle(this.population.get(i));
                if (this.pBest.get((int)i).fitness > this.gBest.fitness) {
                    this.gBest.copyParticle(this.pBest.get(i));
                }
            }
            if (this.population.get((int)i).fitness >= minUtility) {
                this.insert(this.population.get(i));
            }
            ++i;
        }
    }

    private Particle particleInitial(Particle tempNode) {
        treeNode currentNode = this.orNorTree;
        int i = 0;
        while (i < this.twuPattern.size()) {
            boolean temp1;
            if (currentNode.OR == null) {
                tempNode.X.set(i, 0);
                currentNode = currentNode.NOR;
            } else if (currentNode.NOR == null) {
                boolean bl = temp1 = Math.random() > 0.5;
                if (temp1) {
                    tempNode.X.set(i, 1);
                    currentNode = currentNode.OR;
                } else {
                    tempNode.X.set(i, 0);
                    currentNode = currentNode.OR;
                }
            } else {
                boolean temp;
                boolean bl = temp = Math.random() > 0.5;
                if (temp) {
                    boolean bl2 = temp1 = Math.random() > 0.5;
                    if (temp1) {
                        tempNode.X.set(i, 1);
                        currentNode = currentNode.OR;
                    } else {
                        tempNode.X.set(i, 0);
                        currentNode = currentNode.OR;
                    }
                } else {
                    tempNode.X.set(i, 0);
                    currentNode = currentNode.NOR;
                }
            }
            ++i;
        }
        return tempNode;
    }

    private Particle particleUpdate(Particle tempParticle, int i) {
        treeNode currentParticle = this.orNorTree;
        int j = 0;
        while (j < this.twuPattern.size()) {
            double temp2;
            double temp1;
            if (currentParticle.OR == null) {
                tempParticle.X.set(j, 0);
                currentParticle = currentParticle.NOR;
            } else if (currentParticle.NOR == null) {
                temp1 = Math.random();
                if (temp1 < (temp2 = 1.0 / (1.0 + Math.exp(-this.V.get(i).get(j).doubleValue())))) {
                    tempParticle.X.set(j, 1);
                    currentParticle = currentParticle.OR;
                } else {
                    tempParticle.X.set(j, 0);
                    currentParticle = currentParticle.OR;
                }
            } else {
                boolean temp;
                boolean bl = temp = Math.random() > 0.5;
                if (temp) {
                    temp1 = Math.random();
                    if (temp1 < (temp2 = 1.0 / (1.0 + Math.exp(-this.V.get(i).get(j).doubleValue())))) {
                        tempParticle.X.set(j, 1);
                        currentParticle = currentParticle.OR;
                    } else {
                        tempParticle.X.set(j, 0);
                        currentParticle = currentParticle.OR;
                    }
                } else {
                    tempParticle.X.set(j, 0);
                    currentParticle = currentParticle.NOR;
                }
            }
            ++j;
        }
        return tempParticle;
    }

    private void insert(Particle tempParticle) {
        StringBuilder temp = new StringBuilder();
        int i = 0;
        while (i < this.twuPattern.size()) {
            if (tempParticle.X.get(i) == 1) {
                temp.append(this.twuPattern.get(i));
                temp.append(' ');
            }
            ++i;
        }
        if (this.huiSets.size() == 0) {
            this.huiSets.add(new HUI(temp.toString(), tempParticle.fitness));
        } else {
            i = 0;
            while (i < this.huiSets.size()) {
                if (temp.toString().equals(this.huiSets.get((int)i).itemset)) break;
                ++i;
            }
            if (i == this.huiSets.size()) {
                this.huiSets.add(new HUI(temp.toString(), tempParticle.fitness));
            }
        }
    }

    private int fitCalculate(List<Integer> tempParticle, int k) {
        if (k == 0) {
            return 0;
        }
        int fitness = 0;
        int p = 0;
        while (p < this.database.size()) {
            int i = 0;
            int j = 0;
            int q = 0;
            int temp = 0;
            int sum = 0;
            while (j < k && q < this.database.get(p).size() && i < tempParticle.size()) {
                if (tempParticle.get(i) == 1) {
                    if (this.database.get((int)p).get((int)q).item < this.twuPattern.get(i)) {
                        ++q;
                        continue;
                    }
                    if (this.database.get((int)p).get((int)q).item == this.twuPattern.get(i)) {
                        sum += this.database.get((int)p).get((int)q).utility;
                        ++j;
                        ++q;
                        ++temp;
                        ++i;
                        continue;
                    }
                    if (this.database.get((int)p).get((int)q).item <= this.twuPattern.get(i)) continue;
                    ++j;
                    ++i;
                    continue;
                }
                ++i;
            }
            if (temp == k) {
                fitness += sum;
            }
            ++p;
        }
        return fitness;
    }

    private void writeOut() throws IOException {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.huiSets.size()) {
            buffer.append(this.huiSets.get((int)i).itemset);
            buffer.append("#UTIL: ");
            buffer.append(this.huiSets.get((int)i).fitness);
            buffer.append(System.lineSeparator());
            ++i;
        }
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  HUIM-BPSO-tree ALGORITHM v.2.11 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiSets.size());
        System.out.println("===================================================");
    }

    class HUI {
        String itemset;
        int fitness;

        public HUI(String itemset2, int fitness) {
            this.itemset = itemset2;
            this.fitness = fitness;
        }
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }

    class Particle {
        List<Integer> X = new ArrayList<Integer>();
        int fitness;

        public Particle() {
        }

        public Particle(int length) {
            int i = 0;
            while (i < length) {
                this.X.add(i, 0);
                ++i;
            }
        }

        public void copyParticle(Particle particle1) {
            int i = 0;
            while (i < particle1.X.size()) {
                this.X.set(i, (int)particle1.X.get(i));
                ++i;
            }
            this.fitness = particle1.fitness;
        }
    }
}

