/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.tup.tup_preinsertion;

import ca.pfv.spmf.algorithms.episodes.tup.tup_preinsertion.CustomComparator_preinsertion;
import ca.pfv.spmf.algorithms.episodes.tup.tup_preinsertion.Database_preinsertion;
import ca.pfv.spmf.algorithms.episodes.tup.tup_preinsertion.Episode_preinsertion;
import ca.pfv.spmf.algorithms.episodes.tup.tup_preinsertion.Sequence_preinsertion;
import ca.pfv.spmf.algorithms.episodes.tup.tup_preinsertion.SupportOperations_preinsertion;
import ca.pfv.spmf.algorithms.episodes.tup.tup_preinsertion.TUPPGlobalVariables;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;

public class AlgoTUP_preinsertion {
    private long startTimestamp = 0L;
    private long endTimestamp = 0L;
    private static double minUtility = 0.0;
    public static List<Episode_preinsertion> allEpi;
    private Database_preinsertion db;
    private static int maxTimeDuration;

    public Queue<Episode_preinsertion> runAlgorithm(String inputfile, int maximumTimeDuration, int k) {
        this.startTimestamp = System.currentTimeMillis();
        minUtility = 0.0;
        TUPPGlobalVariables.k = k;
        TUPPGlobalVariables.idComparator = new CustomComparator_preinsertion();
        TUPPGlobalVariables.topKBuffer = new PriorityQueue<Episode_preinsertion>(k, TUPPGlobalVariables.idComparator);
        this.setMaxTimeDuration(maximumTimeDuration + 1);
        this.readData(inputfile);
        TUPPGlobalVariables.topKBuffer.clear();
        allEpi = new ArrayList<Episode_preinsertion>(Episode_preinsertion.allEpisodes());
        int i = 0;
        while (i < allEpi.size()) {
            Episode_preinsertion episode = allEpi.get(i);
            episode.oneLengthEwu();
            ++i;
        }
        int j = 0;
        while (j < allEpi.size()) {
            Episode_preinsertion e = allEpi.get(j);
            if (e.getEwu() >= AlgoTUP_preinsertion.getUtility()) {
                SupportOperations_preinsertion.callSimultHUE(e);
                SupportOperations_preinsertion.callSerialHUE(e);
            }
            ++j;
        }
        this.endTimestamp = System.currentTimeMillis();
        return TUPPGlobalVariables.topKBuffer;
    }

    public void printStats() {
        System.out.println("=============  TUP(Preinsertion) v2.23- STATS =============");
        System.out.println(" k = " + TUPPGlobalVariables.k);
        System.out.println(" Number of episodes found = " + TUPPGlobalVariables.topKBuffer.size());
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }

    private void readData(String inputfile) {
        try {
            String line;
            HashMap externalUtill = new HashMap();
            FileReader fReader = new FileReader(inputfile);
            BufferedReader reader = new BufferedReader(fReader);
            int seqCount = 0;
            this.db = new Database_preinsertion();
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] split = line.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                Sequence_preinsertion seq = new Sequence_preinsertion();
                seq.addID(++seqCount);
                seq.fromString(items, utilityValues);
                this.db.addSequence(seqCount, seq);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static double getUtility() {
        return minUtility;
    }

    public static void setUtility(double minUtil) {
        minUtility = minUtil;
    }

    public static double getExternalUtility(String name, HashMap<String, Double> externalUtill) {
        double temp = 0.0;
        try {
            temp = externalUtill.get(name);
        }
        catch (Exception e) {
            System.out.println("Ex: " + name);
            throw e;
        }
        return temp;
    }

    public void setMaxTimeDuration(int m) {
        maxTimeDuration = m;
    }

    public static int getMaxTimeDuration() {
        return maxTimeDuration;
    }

    public void writeResultTofile(String path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        for (Episode_preinsertion episode : TUPPGlobalVariables.topKBuffer) {
            String episodeName = episode.toString();
            episodeName = episodeName.substring(1, episodeName.length() - 1);
            episodeName = episodeName.replaceAll(",", " -1");
            StringBuilder buffer = new StringBuilder();
            buffer.append(episodeName);
            buffer.append(" -1 #UTIL: ");
            buffer.append(episode.getUtility());
            writer.write(buffer.toString());
            writer.newLine();
        }
        writer.close();
    }
}

