/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.tup.tup_combined;

import ca.pfv.spmf.algorithms.episodes.tup.tup_combined.AlgoTUP_Combined;
import ca.pfv.spmf.algorithms.episodes.tup.tup_combined.Database_preinsertion_EWU;
import ca.pfv.spmf.algorithms.episodes.tup.tup_combined.Sequence_preinsertion_EWU;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Episode_preinsertion_EWU {
    ArrayList<String> name = new ArrayList();
    public double utility = 0.0;
    public double ewu = 0.0;
    public static List<String> singleLengthEpi = new ArrayList<String>();
    private Map<Occurrence, Double> occUtilityMap = new HashMap<Occurrence, Double>();
    List<Occurrence> occ = new ArrayList<Occurrence>();
    List<Occurrence> minOcc = new ArrayList<Occurrence>();
    public static List<Episode_preinsertion_EWU> episodes = new ArrayList<Episode_preinsertion_EWU>();

    public Episode_preinsertion_EWU(ArrayList<String> name) {
        this.name = name;
    }

    public static void setEpisodeSet(List<Episode_preinsertion_EWU> allEpisode) {
        episodes = allEpisode;
    }

    public Map<Occurrence, Double> getMap() {
        return this.occUtilityMap;
    }

    public void addOccAndUtill(Occurrence minOcc, Double utill) {
        Map<Occurrence, Double> map = this.getMap();
        map.put(minOcc, utill);
    }

    public double getUtility(Occurrence minOcc) {
        return this.getMap().get(minOcc);
    }

    public double getUtility() {
        return this.utility;
    }

    public void setUtility(double utility) {
        this.utility = utility;
    }

    public double getEwu() {
        return this.ewu;
    }

    public void setEwu(double ewu) {
        this.ewu = ewu;
    }

    public ArrayList<String> getName() {
        return this.name;
    }

    public List<Occurrence> getOcc() {
        if (this.occ == null) {
            this.occ = new ArrayList<Occurrence>();
        }
        return this.occ;
    }

    public void setOcc(List<Occurrence> occ) {
        this.occ = occ;
    }

    public void addOccurrence(Occurrence occ) {
        this.getOcc().add(occ);
    }

    public void addMinOcc(Occurrence occ) {
        this.getMinOcc().add(occ);
    }

    public List<Occurrence> getMinOcc() {
        if (this.minOcc == null) {
            this.minOcc = new ArrayList<Occurrence>();
        }
        return this.minOcc;
    }

    public void setMinOccSerial(ArrayList<Occurrence> occList, Map<Occurrence, Double> occUtillMap) {
        ArrayList finalMinOccList = new ArrayList();
        boolean flag = false;
        if (this.getName().size() == 1) {
            this.minOcc = occList;
        } else {
            boolean lastIndex = false;
            int i = 0;
            while (i < occList.size()) {
                int size = occList.size();
                flag = false;
                Occurrence minOcc = occList.get(i);
                int start = minOcc.startTime;
                int end = minOcc.endTime;
                if (start < end) {
                    int j = 1;
                    while (j < size) {
                        int inStart = occList.get((int)((i + j) % size)).startTime;
                        int inEnd = occList.get((int)((i + j) % size)).endTime;
                        if (start <= inStart && inEnd <= end) {
                            occList.remove(i);
                            --i;
                            flag = true;
                            break;
                        }
                        ++j;
                    }
                    if (!flag) {
                        this.addMinOcc(minOcc);
                        double utility = occUtillMap.get(minOcc);
                        this.addOccAndUtill(minOcc, utility);
                        this.addUtility(utility);
                    }
                }
                ++i;
            }
        }
    }

    public static List<Episode_preinsertion_EWU> allEpisodes() {
        if (episodes == null) {
            episodes = new ArrayList<Episode_preinsertion_EWU>();
        }
        return episodes;
    }

    public static void addEpisode(Episode_preinsertion_EWU e) {
        Episode_preinsertion_EWU.allEpisodes().add(e);
    }

    public static Episode_preinsertion_EWU getEpisode(int i) {
        return episodes.get(i);
    }

    public String toString() {
        String str = "" + this.name;
        return str;
    }

    public void addUtility(double utility) {
        this.utility += utility;
    }

    public static Episode_preinsertion_EWU fromString(String l) {
        int index = Episode_preinsertion_EWU.contains(l);
        if (index != -1) {
            return Episode_preinsertion_EWU.allEpisodes().get(index);
        }
        ArrayList<String> nameStr = new ArrayList<String>();
        nameStr.add(l);
        Episode_preinsertion_EWU oneLengthEpi = new Episode_preinsertion_EWU(nameStr);
        Episode_preinsertion_EWU.addEpisode(oneLengthEpi);
        return oneLengthEpi;
    }

    public void oneLengthEwu() {
        List<Occurrence> minOccList = this.getMinOcc();
        double ewu = 0.0;
        for (Occurrence minOcc : minOccList) {
            int i = minOcc.endTime;
            while (i <= minOcc.startTime + AlgoTUP_Combined.getMaxTimeDuration() - 1) {
                Sequence_preinsertion_EWU s = Database_preinsertion_EWU.getSequence(i);
                if (s != null) {
                    ewu += s.getSeqUtility();
                }
                ++i;
            }
        }
        this.setEwu(ewu);
    }

    public double calculateEwu(List<Occurrence> epiMinOcc) {
        double ewu = 0.0;
        ArrayList<String> name = this.getName();
        String lastEpi = name.get(name.size() - 1);
        String[] events = lastEpi.split(" ");
        String lastEvent = events[events.length - 1];
        double finalEwu = 0.0;
        double firstPartEwu = this.getUtility();
        double leftFirstUtility = 0.0;
        for (Occurrence occ : epiMinOcc) {
            int end;
            double secondEwu = 0.0;
            int start = occ.startTime;
            int j = end = occ.endTime;
            while (j <= start + AlgoTUP_Combined.getMaxTimeDuration() - 1) {
                Sequence_preinsertion_EWU s = Database_preinsertion_EWU.getSequence(j);
                if (s != null) {
                    secondEwu += s.getSeqUtility();
                }
                ++j;
            }
            finalEwu += secondEwu;
            Sequence_preinsertion_EWU seq = Database_preinsertion_EWU.getSequence(end);
            int lastEpiUtility = 0;
            int i = 0;
            while (i < events.length) {
                int index = seq.contains(events[i]);
                lastEpiUtility = (int)((double)lastEpiUtility + seq.getUtill(index));
                ++i;
            }
            leftFirstUtility += (double)lastEpiUtility;
        }
        ewu = finalEwu += (firstPartEwu -= leftFirstUtility);
        return ewu;
    }

    public boolean equals(String epiName) {
        ArrayList<String> name = this.getName();
        int i = 0;
        while (i < name.size()) {
            if (name.get(i).equals(epiName) || name.get(i).contains(epiName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int contains(String epi) {
        int i = 0;
        while (i < episodes.size()) {
            Episode_preinsertion_EWU e = episodes.get(i);
            if (e.getName().get(0).equals(epi)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean simultEpiPresent() {
        String epiName = this.getName().get(0);
        Object[] tokens = epiName.split(" ");
        Arrays.sort(tokens);
        int i = 0;
        while (i < singleLengthEpi.size()) {
            String epiPresent = singleLengthEpi.get(i);
            Object[] tokensPresent = epiPresent.split(" ");
            if (tokens.length == tokensPresent.length) {
                Arrays.sort(tokensPresent);
                if (Arrays.equals(tokens, tokensPresent)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public String getFormattedName() {
        String episodeName = this.name.toString();
        episodeName = episodeName.substring(1, episodeName.length() - 1);
        episodeName = episodeName.replaceAll(",", " -1");
        StringBuilder buffer = new StringBuilder();
        buffer.append(episodeName);
        buffer.append(" -1");
        return buffer.toString();
    }

    public class Occurrence {
        public int startTime;
        public int endTime;

        public Occurrence(int startTime, int endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public boolean equals(Occurrence o) {
            return this.startTime == o.startTime && this.endTime == o.endTime;
        }

        public String toString() {
            String str = String.valueOf(this.startTime) + " " + this.endTime;
            return str;
        }
    }
}

