/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.tup.tup_combined;

import ca.pfv.spmf.algorithms.episodes.tup.tup_combined.CustomComparator_preinsertion_EWU;
import ca.pfv.spmf.algorithms.episodes.tup.tup_combined.Database_preinsertion_EWU;
import ca.pfv.spmf.algorithms.episodes.tup.tup_combined.EWUComparator_preinsertion_EWU;
import ca.pfv.spmf.algorithms.episodes.tup.tup_combined.Episode_preinsertion_EWU;
import ca.pfv.spmf.algorithms.episodes.tup.tup_combined.Sequence_preinsertion_EWU;
import ca.pfv.spmf.algorithms.episodes.tup.tup_combined.SupportOperations_preinsertion_EWU;
import ca.pfv.spmf.algorithms.episodes.tup.tup_combined.TUPCGlobalVariables;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;

public class AlgoTUP_Combined {
    private long startTimestamp = 0L;
    private long endTimestamp = 0L;
    private static double minUtility = 0.0;
    public static List<Episode_preinsertion_EWU> allEpi;
    private Database_preinsertion_EWU db;
    private static int maxTimeDuration;

    public Queue<Episode_preinsertion_EWU> runAlgorithm(String inputfile, int maxTimeDuration, int k) {
        minUtility = 0.0;
        TUPCGlobalVariables.k = k;
        TUPCGlobalVariables.idComparator = new CustomComparator_preinsertion_EWU();
        TUPCGlobalVariables.topKBuffer = new PriorityQueue<Episode_preinsertion_EWU>(k, TUPCGlobalVariables.idComparator);
        this.startTimestamp = System.currentTimeMillis();
        this.setMaxTimeDuration(maxTimeDuration + 1);
        this.readData(inputfile, inputfile);
        TUPCGlobalVariables.topKBuffer.clear();
        allEpi = new ArrayList<Episode_preinsertion_EWU>(Episode_preinsertion_EWU.allEpisodes());
        EWUComparator_preinsertion_EWU Comparator2 = new EWUComparator_preinsertion_EWU();
        PriorityQueue<Episode_preinsertion_EWU> EwuQueue = new PriorityQueue<Episode_preinsertion_EWU>(allEpi.size(), Comparator2);
        int i = 0;
        while (i < allEpi.size()) {
            Episode_preinsertion_EWU episode = allEpi.get(i);
            episode.oneLengthEwu();
            EwuQueue.add(episode);
            ++i;
        }
        int j = 0;
        while (j < allEpi.size()) {
            Episode_preinsertion_EWU e = (Episode_preinsertion_EWU)EwuQueue.poll();
            if (e.getEwu() >= AlgoTUP_Combined.getUtility()) {
                SupportOperations_preinsertion_EWU.callSimultHUE(e);
                SupportOperations_preinsertion_EWU.callSerialHUE(e);
            }
            ++j;
        }
        this.endTimestamp = System.currentTimeMillis();
        return TUPCGlobalVariables.topKBuffer;
    }

    public void printStats() {
        System.out.println("=============  TUP(Combined) v2.23 - STATS =============");
        System.out.println(" k = " + TUPCGlobalVariables.k);
        System.out.println(" Number of episodes found = " + TUPCGlobalVariables.topKBuffer.size());
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }

    private void readData(String transactionFile, String utilityfile) {
        try {
            String line;
            BufferedReader extUtil = new BufferedReader(new FileReader(utilityfile));
            FileReader fReader = new FileReader(transactionFile);
            BufferedReader reader = new BufferedReader(fReader);
            int seqCount = 0;
            this.db = new Database_preinsertion_EWU();
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] split = line.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                Sequence_preinsertion_EWU seq = new Sequence_preinsertion_EWU();
                seq.addID(++seqCount);
                seq.fromString(items, utilityValues);
                this.db.addSequence(seqCount, seq);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static double getUtility() {
        return minUtility;
    }

    public static void setUtility(double minUtil) {
        minUtility = minUtil;
    }

    public static double getExternalUtility(String name, HashMap<String, Double> externalUtill) {
        double temp = 0.0;
        try {
            temp = externalUtill.get(name);
        }
        catch (Exception e) {
            System.out.println("Ex: " + name);
            throw e;
        }
        return temp;
    }

    public void setMaxTimeDuration(int m) {
        maxTimeDuration = m;
    }

    public static int getMaxTimeDuration() {
        return maxTimeDuration;
    }

    public void writeResultTofile(String path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        for (Episode_preinsertion_EWU episode : TUPCGlobalVariables.topKBuffer) {
            String episodeName = episode.toString();
            episodeName = episodeName.substring(1, episodeName.length() - 1);
            episodeName = episodeName.replaceAll(",", " -1");
            StringBuilder buffer = new StringBuilder();
            buffer.append(episodeName);
            buffer.append(" -1 #UTIL: ");
            buffer.append(episode.getUtility());
            writer.write(buffer.toString());
            writer.newLine();
        }
        writer.close();
    }
}

