/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.standardepisoderules;

import java.text.DecimalFormat;
import java.util.List;

public class EpisodeRule {
    public List<int[]> antecedent;
    public List<int[]> consequent;
    private int totalCount;
    private int antiCount;

    public EpisodeRule(List<int[]> antiEvents, List<int[]> conseEvents, int totalCount, int antiCount) {
        this.antecedent = antiEvents;
        this.consequent = conseEvents;
        this.totalCount = totalCount;
        this.antiCount = antiCount;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public List<int[]> getAntiEvents() {
        return this.antecedent;
    }

    public List<int[]> getConseEvents() {
        return this.consequent;
    }

    public int getAntiCount() {
        return this.antiCount;
    }

    public String toString() {
        DecimalFormat formater = new DecimalFormat("#.###");
        StringBuilder buffer = new StringBuilder();
        List<int[]> antecedent = this.getAntiEvents();
        int j = 0;
        while (j < antecedent.size()) {
            int[] eventSet = antecedent.get(j);
            buffer.append('{');
            int i = 0;
            while (i < eventSet.length) {
                buffer.append(eventSet[i]);
                if (i != eventSet.length - 1) {
                    buffer.append(',');
                } else {
                    buffer.append('}');
                }
                ++i;
            }
            ++j;
        }
        buffer.append(" ==> ");
        List<int[]> consequent = this.getConseEvents();
        int j2 = 0;
        while (j2 < consequent.size()) {
            int[] eventSet = consequent.get(j2);
            buffer.append('{');
            int i = 0;
            while (i < eventSet.length) {
                buffer.append(eventSet[i]);
                if (i != eventSet.length - 1) {
                    buffer.append(',');
                } else {
                    buffer.append('}');
                }
                ++i;
            }
            ++j2;
        }
        buffer.append(" #SUP: ");
        buffer.append(this.getTotalCount());
        buffer.append(" #CONF: ");
        double confidence = (double)this.getTotalCount() / (double)this.getAntiCount();
        buffer.append(formater.format(confidence));
        buffer.append(System.lineSeparator());
        return buffer.toString();
    }
}

