/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.poerm;

import ca.pfv.spmf.algorithms.episodes.poerm.RuleInterval;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class POERRule {
    private List<Integer> antiEpisode;
    private List<Integer> conseEpisode;
    private List<RuleInterval> intervals;
    private int antiCount;
    private int confidence;
    private DecimalFormat formatter = new DecimalFormat("#.####");

    public POERRule(List<Integer> antiEpisode, List<Integer> conseEpisode, List<RuleInterval> intervals, int antiCount, int confident) {
        this.setAntiEpisode(antiEpisode);
        this.setConseEpisode(conseEpisode);
        this.setIntervals(intervals);
        this.setAntiCount(antiCount);
        this.setConfident(confident);
    }

    public int match(List<int[]> antecedent) {
        boolean i = false;
        ArrayList<Integer> intersection = new ArrayList<Integer>();
        intersection.addAll(this.antiEpisode);
        ArrayList<Integer> otherList = new ArrayList<Integer>();
        int j = 0;
        while (j < antecedent.size()) {
            int[] nowItemSet = antecedent.get(j);
            int k = 0;
            while (k < nowItemSet.length) {
                otherList.add(nowItemSet[k]);
                ++k;
            }
            ++j;
        }
        intersection.retainAll(otherList);
        if (intersection.size() == this.antiEpisode.size()) {
            return this.antiEpisode.size();
        }
        return 0;
    }

    public String toString() {
        String episodeRule = "";
        List<Integer> antiEpisode = this.getAntiEpisode();
        List<Integer> conseEpisode = this.getConseEpisode();
        for (Integer anti : antiEpisode) {
            episodeRule = String.valueOf(episodeRule) + anti + " ";
        }
        episodeRule = String.valueOf(episodeRule) + "==> ";
        for (Integer conse : conseEpisode) {
            episodeRule = String.valueOf(episodeRule) + conse + " ";
        }
        return "rule: " + episodeRule + "#SUP: " + this.getRuleCount() + " #CONF: " + this.formatter.format((double)this.getRuleCount() / (double)this.getAntiCount());
    }

    public int compareTo(POERRule o) {
        if (o == this) {
            return 0;
        }
        long compare = this.antiCount - o.antiCount;
        if (compare > 0L) {
            return 1;
        }
        if (compare < 0L) {
            return -1;
        }
        return 0;
    }

    public List<Integer> getAntiEpisode() {
        return this.antiEpisode;
    }

    public void setAntiEpisode(List<Integer> antiEpisode) {
        this.antiEpisode = antiEpisode;
    }

    public List<Integer> getConseEpisode() {
        return this.conseEpisode;
    }

    public void setConseEpisode(List<Integer> conseEpisode) {
        this.conseEpisode = conseEpisode;
    }

    public List<RuleInterval> getIntervals() {
        return this.intervals;
    }

    public void setIntervals(List<RuleInterval> intervals) {
        this.intervals = intervals;
    }

    public int getRuleCount() {
        return this.confidence;
    }

    public void setConfident(int confident) {
        this.confidence = confident;
    }

    public int getAntiCount() {
        return this.antiCount;
    }

    public void setAntiCount(int antiCount) {
        this.antiCount = antiCount;
    }
}

