/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.poerm;

import ca.pfv.spmf.algorithms.episodes.poerm.EventSetAppear;
import ca.pfv.spmf.algorithms.episodes.poerm.Interval;
import ca.pfv.spmf.algorithms.episodes.poerm.POERParas;
import ca.pfv.spmf.algorithms.episodes.poerm.POERRule;
import ca.pfv.spmf.algorithms.episodes.poerm.POERRuleOccur;
import ca.pfv.spmf.algorithms.episodes.poerm.RuleInterval;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoPOERMHeadFrequency {
    private String inputFile;
    private long startTime;
    private long endTime;
    private long deltaTime;
    private int end = 0;
    private POERParas parameter = null;
    private Map<Integer, List<Integer>> XFreS;
    private Map<Integer, List<Integer>> YFreS;
    private Map<Integer, List<Interval>> thisAppear;
    private List<EventSetAppear> XFreAppear;
    private List<EventSetAppear> YFreAppear;
    private List<POERRule> ruleAppear;
    DecimalFormat formatter = new DecimalFormat("#.####");
    private double maxMemory;
    private int maxWindowNum;

    public double getMaxMemory() {
        return this.maxMemory;
    }

    public int getMaxWindowNum() {
        return this.maxWindowNum;
    }

    public List<POERRule> runAlgorithm(String inputFile, int minSupport, int xSpan, int ySpan, double minConfidence, int winlen, boolean selfIncrement) {
        this.XFreS = new HashMap<Integer, List<Integer>>();
        this.YFreS = new HashMap<Integer, List<Integer>>();
        this.thisAppear = new HashMap<Integer, List<Interval>>();
        this.XFreAppear = new ArrayList<EventSetAppear>();
        this.YFreAppear = new ArrayList<EventSetAppear>();
        this.ruleAppear = new ArrayList<POERRule>();
        this.inputFile = inputFile;
        this.parameter = new POERParas(minSupport, xSpan, ySpan, minConfidence, winlen, selfIncrement);
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.preProcess(this.inputFile);
        this.miningXEventSet();
        this.findRule(this.YFreS, this.parameter.getYSpan(), this.parameter.getWinlen());
        this.endTime = System.currentTimeMillis();
        this.deltaTime = this.endTime - this.startTime;
        MemoryLogger.getInstance().checkMemory();
        this.maxMemory = MemoryLogger.getInstance().getMaxMemory();
        return this.ruleAppear;
    }

    /*
     * Unable to fully structure code
     */
    private void preProcess(String input) {
        try {
            block15: {
                eventSet = new HashMap<Integer, Integer>();
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(input), "UTF-8"));
                line = null;
                timestamp = 1;
                preTimestamp = -1;
                maxWindow = this.parameter.getXSpan() + this.parameter.getYSpan() + this.parameter.getWinlen();
                this.maxWindowNum = 0;
                if (!this.parameter.isSelfIncrement()) ** GOTO lbl92
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                    array = line.split(" ");
                    eSet = new ArrayList<Integer>();
                    eSet2 = new ArrayList<Integer>();
                    var15_23 = array;
                    var14_21 = array.length;
                    var13_19 = 0;
                    while (var13_19 < var14_21) {
                        event = var15_23[var13_19];
                        num = Integer.parseInt(event);
                        support = eventSet.get(num);
                        if (support != null) {
                            eventSet.put(num, support + 1);
                            this.thisAppear.get(num).add(new Interval(timestamp, timestamp));
                        } else {
                            eventSet.put(num, 1);
                            interval = new ArrayList<Interval>();
                            interval.add(new Interval(timestamp, timestamp));
                            this.thisAppear.put(num, interval);
                        }
                        eSet.add(num);
                        eSet2.add(num);
                        ++var13_19;
                    }
                    if (eSet.size() > 0) {
                        this.XFreS.put(timestamp, eSet2);
                    }
                    if (preTimestamp == -1) {
                        preTimestamp = timestamp;
                    }
                    if (timestamp - preTimestamp > maxWindow) {
                        preTimestamp = timestamp;
                        ++this.maxWindowNum;
                    }
                    ++timestamp;
                }
                break block15;
lbl-1000:
                // 1 sources

                {
                    if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                    lineSplited = line.split("\\|");
                    timestamp = Integer.parseInt(lineSplited[1]);
                    array = lineSplited[0].split(" ");
                    eSet = new ArrayList<Integer>();
                    eSet2 = new ArrayList<Integer>();
                    var16_26 = array;
                    var15_24 = array.length;
                    var14_22 = 0;
                    while (var14_22 < var15_24) {
                        event = var16_26[var14_22];
                        num = Integer.parseInt(event);
                        support = eventSet.get(num);
                        if (support != null) {
                            eventSet.put(num, support + 1);
                            this.thisAppear.get(num).add(new Interval(timestamp, timestamp));
                        } else {
                            eventSet.put(num, 1);
                            interval = new ArrayList<Interval>();
                            interval.add(new Interval(timestamp, timestamp));
                            this.thisAppear.put(num, interval);
                        }
                        eSet.add(num);
                        eSet2.add(num);
                        ++var14_22;
                    }
                    if (eSet.size() > 0) {
                        this.XFreS.put(timestamp, eSet2);
                    }
                    if (preTimestamp == -1) {
                        preTimestamp = timestamp;
                    }
                    if (timestamp - preTimestamp <= maxWindow) continue;
                    preTimestamp = timestamp;
                    ++this.maxWindowNum;
lbl92:
                    // 4 sources

                    ** while ((line = reader.readLine()) != null)
                }
            }
            MemoryLogger.getInstance().checkMemory();
            this.loadFrequent(eventSet);
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadFrequent(Map<Integer, Integer> eventSet) {
        for (Map.Entry<Integer, List<Integer>> entry : this.XFreS.entrySet()) {
            List<Integer> eSet = entry.getValue();
            ArrayList<Integer> XnewList = new ArrayList<Integer>();
            ArrayList<Integer> YnewList = new ArrayList<Integer>();
            for (Integer e : eSet) {
                int support = eventSet.get(e);
                if (!((double)support >= (double)this.parameter.getMinSupport() * this.parameter.getMinConfidence())) continue;
                YnewList.add(e);
                if (support < this.parameter.getMinSupport()) continue;
                XnewList.add(e);
            }
            this.XFreS.put(entry.getKey(), XnewList);
            this.YFreS.put(entry.getKey(), YnewList);
        }
        for (Map.Entry<Integer, Object> entry : eventSet.entrySet()) {
            Integer key = entry.getKey();
            Integer val = (Integer)entry.getValue();
            ArrayList<Integer> numKey = new ArrayList<Integer>();
            numKey.add(key);
            if (!((double)val.intValue() >= (double)this.parameter.getMinSupport() * this.parameter.getMinConfidence())) continue;
            List<Interval> value = this.thisAppear.get(key);
            this.YFreAppear.add(new EventSetAppear(numKey, value));
            if (val < this.parameter.getMinSupport()) continue;
            this.XFreAppear.add(new EventSetAppear(numKey, value));
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void miningXEventSet() {
        try {
            int index = 0;
            int end = this.XFreAppear.size();
            while (index < end) {
                this.thisAppear.clear();
                EventSetAppear episodeAppear = this.XFreAppear.get(index);
                ++index;
                List<Integer> episode = episodeAppear.getEventSet();
                Integer compareKey = episode.get(episode.size() - 1);
                List<Interval> appear = episodeAppear.getIntervals();
                for (Interval interval : appear) {
                    ArrayList<Interval> appearTime;
                    List<Integer> eventSet;
                    Integer intStart = interval.start;
                    Integer intEnd = interval.end;
                    int j = intEnd - this.parameter.getXSpan() + 1;
                    while (j < intStart) {
                        if (this.XFreS.containsKey(j)) {
                            eventSet = this.XFreS.get(j);
                            for (Integer eventItem : eventSet) {
                                if (eventItem <= compareKey) continue;
                                if (this.thisAppear.containsKey(eventItem)) {
                                    this.thisAppear.get(eventItem).add(new Interval(j, intEnd));
                                    continue;
                                }
                                appearTime = new ArrayList<Interval>();
                                appearTime.add(new Interval(j, intEnd));
                                this.thisAppear.put(eventItem, appearTime);
                            }
                        }
                        ++j;
                    }
                    j = intEnd + 1;
                    while (j < intStart + this.parameter.getXSpan()) {
                        if (this.XFreS.containsKey(j)) {
                            eventSet = this.XFreS.get(j);
                            for (Integer eventItem : eventSet) {
                                if (eventItem <= compareKey) continue;
                                if (this.thisAppear.containsKey(eventItem)) {
                                    this.thisAppear.get(eventItem).add(new Interval(intStart, j));
                                    continue;
                                }
                                appearTime = new ArrayList();
                                appearTime.add(new Interval(intStart, j));
                                this.thisAppear.put(eventItem, appearTime);
                            }
                        }
                        ++j;
                    }
                    j = intStart;
                    while (j <= intEnd) {
                        if (this.XFreS.containsKey(j)) {
                            eventSet = this.XFreS.get(j);
                            for (Integer eventItem : eventSet) {
                                if (eventItem <= compareKey) continue;
                                if (this.thisAppear.containsKey(eventItem)) {
                                    this.thisAppear.get(eventItem).add(new Interval(intStart, intEnd));
                                    continue;
                                }
                                appearTime = new ArrayList();
                                appearTime.add(new Interval(intStart, intEnd));
                                this.thisAppear.put(eventItem, appearTime);
                            }
                        }
                        ++j;
                    }
                }
                for (Map.Entry entry : this.thisAppear.entrySet()) {
                    Integer key = (Integer)entry.getKey();
                    List value = (List)entry.getValue();
                    value.sort(new myComparator2());
                    ArrayList<Interval> newValue = new ArrayList<Interval>();
                    int i = 0;
                    while (i < value.size()) {
                        if (i == 0 || ((Interval)value.get((int)i)).start != ((Interval)newValue.get((int)(newValue.size() - 1))).start) {
                            newValue.add((Interval)value.get(i));
                        }
                        ++i;
                    }
                    ArrayList<Integer> newKey = new ArrayList<Integer>(episode);
                    newKey.add(key);
                    if (newValue.size() * this.parameter.getXSpan() < this.parameter.getMinSupport()) continue;
                    this.XFreAppear.add(new EventSetAppear(newKey, newValue));
                }
                end = this.XFreAppear.size();
                MemoryLogger.getInstance().checkMemory();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void findRule(Map<Integer, List<Integer>> itemFreS, int window_size, int span) {
        HashMap conseRecodeMap = new HashMap();
        for (EventSetAppear anitemset : this.XFreAppear) {
            List<Integer> anitKey = anitemset.getEventSet();
            List<Interval> anitValues = anitemset.getIntervals();
            int anitCount = anitValues.size();
            if (anitCount < this.parameter.getMinSupport()) continue;
            conseRecodeMap.clear();
            for (Interval interval : anitValues) {
                int i = 1 + interval.end;
                while (i < span + interval.start) {
                    if (itemFreS.containsKey(i) && itemFreS.get(i).size() != 0) {
                        RuleInterval thisInterval = new RuleInterval(interval.start, interval.end, i, i);
                        List<Integer> itemSet = itemFreS.get(i);
                        for (Integer item : itemSet) {
                            if (conseRecodeMap.containsKey(item)) {
                                ((ArrayList)conseRecodeMap.get(item)).add(thisInterval);
                                continue;
                            }
                            ArrayList<RuleInterval> intervalList = new ArrayList<RuleInterval>();
                            intervalList.add(thisInterval);
                            conseRecodeMap.put(item, intervalList);
                        }
                    }
                    ++i;
                }
            }
            for (Map.Entry entry : conseRecodeMap.entrySet()) {
                void var19_24;
                Integer key = (Integer)entry.getKey();
                ArrayList<POERRuleOccur> ruleOccur = new ArrayList<POERRuleOccur>();
                List occurList = (List)entry.getValue();
                if ((double)occurList.size() < (double)anitCount * this.parameter.getMinConfidence()) continue;
                int realRuleStart = -1;
                int realRuleCount = 0;
                for (RuleInterval occur : occurList) {
                    if (occur.antiStart <= realRuleStart) continue;
                    ++realRuleCount;
                    realRuleStart = occur.antiStart;
                }
                ArrayList<Integer> conseEpi = new ArrayList<Integer>();
                conseEpi.add(key);
                if ((double)realRuleCount >= (double)anitCount * this.parameter.getMinConfidence()) {
                    this.ruleAppear.add(new POERRule(anitKey, conseEpi, occurList, anitCount, realRuleCount));
                }
                HashMap tempRuleMap = new HashMap();
                for (RuleInterval ruleInterval : occurList) {
                    int intervalStart = Math.max(ruleInterval.antiEnd + 1, ruleInterval.end - this.parameter.getYSpan() + 1);
                    int intervalEnd = Math.min(ruleInterval.antiStart + this.parameter.getWinlen(), ruleInterval.start + this.parameter.getYSpan());
                    int i = intervalStart;
                    while (i < intervalEnd) {
                        if (itemFreS.containsKey(i) && itemFreS.get(i).size() != 0) {
                            RuleInterval ruleInteval = i > ruleInterval.end ? new RuleInterval(ruleInterval.antiStart, ruleInterval.antiEnd, ruleInterval.start, i) : (i < ruleInterval.start ? new RuleInterval(ruleInterval.antiStart, ruleInterval.antiEnd, i, ruleInterval.end) : new RuleInterval(ruleInterval.antiStart, ruleInterval.antiEnd, ruleInterval.start, ruleInterval.end));
                            if (ruleInteval.end - ruleInteval.start < this.parameter.getYSpan()) {
                                List<Integer> list = itemFreS.get(i);
                                for (Integer eventItem : list) {
                                    if (eventItem <= key) continue;
                                    if (tempRuleMap.containsKey(eventItem)) {
                                        ((List)tempRuleMap.get(eventItem)).add(ruleInteval);
                                        continue;
                                    }
                                    ArrayList<RuleInterval> appearTime = new ArrayList<RuleInterval>();
                                    appearTime.add(ruleInteval);
                                    tempRuleMap.put(eventItem, appearTime);
                                }
                            }
                        }
                        ++i;
                    }
                }
                for (Map.Entry entry2 : tempRuleMap.entrySet()) {
                    List tempRuleMapInterval;
                    Integer tempRuleMapKey = (Integer)entry2.getKey();
                    if (tempRuleMapKey == 14) {
                        System.out.println("aaa");
                    }
                    if ((double)(tempRuleMapInterval = (List)entry2.getValue()).size() < (double)anitCount * this.parameter.getMinConfidence()) continue;
                    int tempRealRuleStart = -1;
                    int tempRealRuleCount = 0;
                    for (RuleInterval ruleInterval : tempRuleMapInterval) {
                        if (ruleInterval.antiStart <= tempRealRuleStart) continue;
                        ++tempRealRuleCount;
                        tempRealRuleStart = ruleInterval.antiStart;
                    }
                    if ((double)tempRealRuleCount < (double)anitCount * this.parameter.getMinConfidence()) continue;
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    arrayList.add(key);
                    arrayList.add(tempRuleMapKey);
                    if ((double)tempRealRuleCount >= (double)anitCount * this.parameter.getMinConfidence()) {
                        this.ruleAppear.add(new POERRule(anitKey, arrayList, tempRuleMapInterval, anitCount, tempRealRuleCount));
                        ruleOccur.add(new POERRuleOccur(arrayList, tempRuleMapInterval));
                    }
                    MemoryLogger.getInstance().checkMemory();
                }
                boolean bl = false;
                int breadthSearthEnd = ruleOccur.size();
                while (var19_24 < breadthSearthEnd) {
                    tempRuleMap.clear();
                    POERRuleOccur oneOccurRule = (POERRuleOccur)ruleOccur.get((int)var19_24);
                    ++var19_24;
                    List<Integer> episode = oneOccurRule.getEpisode();
                    Integer compareKey = episode.get(episode.size() - 1);
                    List<RuleInterval> oneOccurRuleInters = oneOccurRule.getIntervals();
                    for (RuleInterval ruleInterval : oneOccurRuleInters) {
                        int intervalStart = Math.max(ruleInterval.antiEnd + 1, ruleInterval.end - this.parameter.getYSpan() + 1);
                        int intervalEnd = Math.min(ruleInterval.antiStart + this.parameter.getWinlen(), ruleInterval.start + this.parameter.getYSpan());
                        int i = intervalStart;
                        while (i < intervalEnd) {
                            if (i + this.parameter.getYSpan() >= ruleInterval.end && itemFreS.containsKey(i) && itemFreS.get(i).size() != 0) {
                                List<Integer> eventSet = itemFreS.get(i);
                                RuleInterval ruleInteval = i > ruleInterval.end ? new RuleInterval(ruleInterval.antiStart, ruleInterval.antiEnd, ruleInterval.start, i) : (i < ruleInterval.start ? new RuleInterval(ruleInterval.antiStart, ruleInterval.antiEnd, i, ruleInterval.end) : new RuleInterval(ruleInterval.antiStart, ruleInterval.antiEnd, ruleInterval.start, ruleInterval.end));
                                if (ruleInterval.end - ruleInterval.start < this.parameter.getYSpan()) {
                                    for (Integer eventItem : eventSet) {
                                        if (eventItem <= compareKey) continue;
                                        if (tempRuleMap.containsKey(eventItem)) {
                                            ((List)tempRuleMap.get(eventItem)).add(ruleInteval);
                                            continue;
                                        }
                                        ArrayList<RuleInterval> appearTime = new ArrayList<RuleInterval>();
                                        appearTime.add(ruleInteval);
                                        tempRuleMap.put(eventItem, appearTime);
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    for (Map.Entry entry3 : tempRuleMap.entrySet()) {
                        Integer tempRuleMapKey = (Integer)entry3.getKey();
                        List tempRuleMapInterval = (List)entry3.getValue();
                        if ((double)tempRuleMapInterval.size() < (double)anitCount * this.parameter.getMinConfidence()) continue;
                        int tempRealRuleStart = -1;
                        int tempRealRuleCount = 0;
                        for (RuleInterval tempRuleMapInter : tempRuleMapInterval) {
                            if (tempRuleMapInter.antiStart <= tempRealRuleStart) continue;
                            ++tempRealRuleCount;
                            tempRealRuleStart = tempRuleMapInter.antiStart;
                        }
                        ArrayList<Integer> conseEpisode = new ArrayList<Integer>();
                        conseEpisode.addAll(episode);
                        conseEpisode.add(tempRuleMapKey);
                        if (!((double)tempRealRuleCount >= (double)anitCount * this.parameter.getMinConfidence())) continue;
                        this.ruleAppear.add(new POERRule(anitKey, conseEpisode, tempRuleMapInterval, anitCount, tempRealRuleCount));
                        ruleOccur.add(new POERRuleOccur(conseEpisode, tempRuleMapInterval));
                    }
                    MemoryLogger.getInstance().checkMemory();
                    breadthSearthEnd = ruleOccur.size();
                }
            }
        }
    }

    public void printRule() {
        this.ruleAppear.sort(new myComparator4());
        int i = 0;
        for (POERRule poerrule : this.ruleAppear) {
            String episodeRule = "";
            List<Integer> antiEpisode = poerrule.getAntiEpisode();
            List<Integer> conseEpisode = poerrule.getConseEpisode();
            for (Integer anti : antiEpisode) {
                episodeRule = String.valueOf(episodeRule) + anti + " ";
            }
            episodeRule = String.valueOf(episodeRule) + "==> ";
            for (Integer conse : conseEpisode) {
                episodeRule = String.valueOf(episodeRule) + conse + " ";
            }
            System.out.println("rule: " + episodeRule + "#SUP:" + poerrule.getRuleCount() + " #CONF: " + this.formatter.format((double)poerrule.getRuleCount() / (double)poerrule.getAntiCount()));
            if (++i > 500) break;
        }
    }

    public void writeRule2File(String filename) {
        try {
            MemoryLogger.getInstance().checkMemory();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, false)));
            StringBuilder buffer = new StringBuilder();
            for (POERRule poerrule : this.ruleAppear) {
                for (Integer anti : poerrule.getAntiEpisode()) {
                    buffer.append(anti);
                    buffer.append(' ');
                }
                buffer.append("==> ");
                for (Integer conse : poerrule.getConseEpisode()) {
                    buffer.append(conse);
                    buffer.append(' ');
                }
                buffer.append("#SUP: ");
                buffer.append(poerrule.getAntiCount());
                buffer.append(" #CONF: ");
                buffer.append(String.valueOf(this.formatter.format((double)poerrule.getRuleCount() / (double)poerrule.getAntiCount())) + System.lineSeparator());
            }
            bw.write(buffer.toString());
            bw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printStats() {
        System.out.println("=============  POERMH v.2.51 - STATS =============");
        System.out.println(" Rule count : " + this.ruleAppear.size());
        System.out.println(" Maximum memory usage : " + this.formatter.format(this.maxMemory) + " mb");
        System.out.println(" Total time ~ : " + this.deltaTime + " ms");
        System.out.println("===================================================");
    }

    public class myComparator
    implements Comparator<Interval> {
        @Override
        public int compare(Interval a, Interval b) {
            if (a.end == b.end) {
                return a.start - b.start;
            }
            return a.end - b.end;
        }
    }

    public class myComparator2
    implements Comparator<Interval> {
        @Override
        public int compare(Interval a, Interval b) {
            if (a.start == b.start) {
                return a.end - b.end;
            }
            return a.start - b.start;
        }
    }

    public class myComparator4
    implements Comparator<POERRule> {
        @Override
        public int compare(POERRule a, POERRule b) {
            if (b.getRuleCount() == a.getRuleCount()) {
                return a.getAntiCount() - b.getAntiCount();
            }
            return b.getRuleCount() - a.getRuleCount();
        }
    }
}

