/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.minepiplus;

import ca.pfv.spmf.algorithms.episodes.general.FrequentEpisodes;
import ca.pfv.spmf.algorithms.episodes.minepiplus.EpisodeMP;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoMINEPIPlus {
    private long startTimestamp;
    private long endTimestamp;
    private int candidateCount = 0;
    private boolean selfIncrement;
    protected FrequentEpisodes freEpisodes = null;
    private List<EpisodeMP> f1;
    private List<List<int[]>> f1BoundList;
    private int minSupport;
    private int maxWindow;

    public FrequentEpisodes runAlgorithm(String input, String output, int minSupport, int maxWindow, boolean selfIncrement) throws IOException {
        MemoryLogger.getInstance().reset();
        this.minSupport = minSupport;
        this.maxWindow = maxWindow;
        this.selfIncrement = selfIncrement;
        this.startTimestamp = System.currentTimeMillis();
        this.freEpisodes = new FrequentEpisodes();
        this.scanDatabaseToDetermineFrequentSingleEpisode(input);
        int i = 0;
        while (i < this.f1.size()) {
            this.serialJoins(this.f1.get(i), this.f1BoundList.get(i), this.f1.get(i).getLastItem(), 1);
            ++i;
        }
        this.endTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        if (output != null) {
            this.freEpisodes.saveToFile(output);
        }
        return this.freEpisodes;
    }

    public void serialJoins(EpisodeMP alpha, List<int[]> alphaBoundlist, int lastItem, int levelNum) {
        int j = 0;
        while (j < this.f1.size()) {
            EpisodeMP beta;
            List<int[]> tempBoundlist;
            int support;
            EpisodeMP fj = this.f1.get(j);
            if (fj.getLastItem() > lastItem && (support = this.getEntityCount(tempBoundlist = this.equalJoin(alphaBoundlist, this.f1BoundList.get(j)))) >= this.minSupport) {
                beta = alpha.iExtension(fj.getLastItem(), support);
                this.freEpisodes.addFrequentEpisode(beta, levelNum);
                this.serialJoins(beta, tempBoundlist, fj.getLastItem(), levelNum);
            }
            if ((support = this.getEntityCount(tempBoundlist = this.temporalJoin(alphaBoundlist, this.f1BoundList.get(j)))) >= this.minSupport) {
                beta = alpha.sExtension(fj.getLastItem(), support);
                this.freEpisodes.addFrequentEpisode(beta, levelNum + 1);
                this.serialJoins(beta, tempBoundlist, fj.getLastItem(), levelNum + 1);
            }
            ++j;
        }
    }

    private int getEntityCount(List<int[]> tempBoundlist) {
        if (tempBoundlist.size() <= 0) {
            return 0;
        }
        int support = 1;
        int lastStarTime = tempBoundlist.get(0)[0];
        int i = 0;
        while (i < tempBoundlist.size()) {
            if (lastStarTime != tempBoundlist.get(i)[0]) {
                ++support;
                lastStarTime = tempBoundlist.get(i)[0];
            }
            ++i;
        }
        return support;
    }

    private List<int[]> temporalJoin(List<int[]> alphaBoundlist, List<int[]> fjBoundlist) {
        ++this.candidateCount;
        ArrayList<int[]> tempBoundlist = new ArrayList<int[]>();
        int i = 0;
        while (i < alphaBoundlist.size()) {
            int j = 0;
            while (j < fjBoundlist.size()) {
                if (fjBoundlist.get(j)[1] > alphaBoundlist.get(i)[1]) {
                    if (fjBoundlist.get(j)[1] - alphaBoundlist.get(i)[0] >= this.maxWindow) break;
                    int[] boundlist = new int[]{alphaBoundlist.get(i)[0], fjBoundlist.get(j)[1]};
                    tempBoundlist.add(boundlist);
                }
                ++j;
            }
            ++i;
        }
        return tempBoundlist;
    }

    private List<int[]> equalJoin(List<int[]> alphaBoundlist, List<int[]> fjBoundlist) {
        ++this.candidateCount;
        ArrayList<int[]> tempBoundlist = new ArrayList<int[]>();
        int i = 0;
        while (i < alphaBoundlist.size()) {
            int j = 0;
            while (j < fjBoundlist.size()) {
                if (alphaBoundlist.get(i)[1] < fjBoundlist.get(j)[1]) break;
                if (alphaBoundlist.get(i)[1] == fjBoundlist.get(j)[1]) {
                    tempBoundlist.add(alphaBoundlist.get(i));
                    break;
                }
                ++j;
            }
            ++i;
        }
        return tempBoundlist;
    }

    private void scanDatabaseToDetermineFrequentSingleEpisode(String input) throws IOException {
        int n;
        String[] lineSplited;
        String line;
        int currentTID;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        HashMap<Integer, ArrayList<int[]>> mapSingleEventCount = new HashMap<Integer, ArrayList<int[]>>();
        if (this.selfIncrement) {
            currentTID = 0;
            while ((line = reader.readLine()) != null) {
                ++currentTID;
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] stringArray = lineSplited = line.split(" ");
                n = lineSplited.length;
                int n2 = 0;
                while (n2 < n) {
                    String itemString = stringArray[n2];
                    Integer itemName = Integer.parseInt(itemString);
                    ArrayList<int[]> bouldList = (ArrayList<int[]>)mapSingleEventCount.get(itemName);
                    if (bouldList == null) {
                        bouldList = new ArrayList<int[]>();
                        bouldList.add(new int[]{currentTID, currentTID});
                        mapSingleEventCount.put(itemName, bouldList);
                        ++this.candidateCount;
                    } else {
                        bouldList.add(new int[]{currentTID, currentTID});
                        mapSingleEventCount.put(itemName, bouldList);
                    }
                    ++n2;
                }
            }
        } else {
            currentTID = 1;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                lineSplited = line.split("\\|");
                String[] lineItems = lineSplited[0].split(" ");
                currentTID = Integer.parseInt(lineSplited[1]);
                String[] stringArray = lineItems;
                int n3 = lineItems.length;
                n = 0;
                while (n < n3) {
                    String itemString = stringArray[n];
                    Integer itemName = Integer.parseInt(itemString);
                    ArrayList<int[]> bouldList = (ArrayList<int[]>)mapSingleEventCount.get(itemName);
                    if (bouldList == null) {
                        bouldList = new ArrayList<int[]>();
                        bouldList.add(new int[]{currentTID, currentTID});
                        mapSingleEventCount.put(itemName, bouldList);
                        ++this.candidateCount;
                    } else {
                        bouldList.add(new int[]{currentTID, currentTID});
                        mapSingleEventCount.put(itemName, bouldList);
                    }
                    ++n;
                }
            }
        }
        this.freEpisodes = new FrequentEpisodes();
        this.f1 = new ArrayList<EpisodeMP>();
        this.f1BoundList = new ArrayList<List<int[]>>();
        for (Map.Entry entry : mapSingleEventCount.entrySet()) {
            List bouldList = (List)entry.getValue();
            if (bouldList.size() < this.minSupport) continue;
            int[] symbol = new int[]{(Integer)entry.getKey()};
            ArrayList<int[]> event = new ArrayList<int[]>(symbol){
                {
                    this.add(nArray);
                }
            };
            EpisodeMP episode = new EpisodeMP((List<int[]>)event, bouldList.size());
            this.freEpisodes.addFrequentEpisode(episode, 1);
            this.f1.add(episode);
            this.f1BoundList.add(bouldList);
        }
    }

    public void printStats() {
        System.out.println("=============  MINEPI+_S (head episode) - STATS =============");
        System.out.println(" Candidates count : " + this.candidateCount);
        System.out.println(" The algorithm stopped at size : " + this.freEpisodes.getTotalLevelNum());
        System.out.println(" Frequent episodes count : " + this.freEpisodes.getFrequentEpisodesCount());
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ : " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

