/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.minepi;

import ca.pfv.spmf.algorithms.episodes.minepi.Candidates;
import ca.pfv.spmf.algorithms.episodes.minepi.Event;
import ca.pfv.spmf.algorithms.episodes.minepi.FrequentEpisodes;
import ca.pfv.spmf.algorithms.episodes.minepi.SerialEpisode;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoMINEPI {
    private int k = 0;
    private long startTimestamp;
    private long endTimestamp;
    private int candidateCount = 0;
    private List<Event> sequence;
    private boolean selfIncrement;
    private FrequentEpisodes frequentEpisodes = null;
    private int minSupport;
    private int maxWindow;

    public FrequentEpisodes runAlgorithm(String input, String output, int minSupport, int maxWindow, boolean selfIncrement) throws IOException {
        MemoryLogger.getInstance().reset();
        this.minSupport = minSupport;
        this.maxWindow = maxWindow;
        this.selfIncrement = selfIncrement;
        this.startTimestamp = System.currentTimeMillis();
        this.sequence = new ArrayList<Event>();
        this.frequentEpisodes = new FrequentEpisodes();
        this.scanDatabaseToDetermineFrequentSingleEpisode(input);
        ++this.k;
        Candidates candidates = this.frequentEpisodes.genCandidateByLevel(this.k);
        while (candidates != null && !candidates.isEmpty()) {
            this.candidateCount += candidates.getCandidateCount();
            ++this.k;
            candidates.getFrequentKepisodes(this.sequence, this.minSupport, this.maxWindow, this.frequentEpisodes);
            candidates = this.frequentEpisodes.genCandidateByLevel(this.k);
        }
        this.endTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        if (output != null) {
            this.frequentEpisodes.out2file(output);
        }
        return this.frequentEpisodes;
    }

    private void scanDatabaseToDetermineFrequentSingleEpisode(String input) throws IOException {
        int n;
        String[] lineSplited;
        Event simulEvent;
        String line;
        int currentTID;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        HashMap<Integer, Integer> mapSingleEventCount = new HashMap<Integer, Integer>();
        if (this.selfIncrement) {
            currentTID = 0;
            while ((line = reader.readLine()) != null) {
                ++currentTID;
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                simulEvent = new Event();
                String[] stringArray = lineSplited = line.split(" ");
                n = lineSplited.length;
                int n2 = 0;
                while (n2 < n) {
                    String itemString = stringArray[n2];
                    Integer itemName = Integer.parseInt(itemString);
                    simulEvent.addEvent(itemName);
                    Integer count = (Integer)mapSingleEventCount.get(itemName);
                    if (count == null) {
                        mapSingleEventCount.put(itemName, 1);
                        ++this.candidateCount;
                    } else {
                        count = count + 1;
                        mapSingleEventCount.put(itemName, count);
                    }
                    ++n2;
                }
                simulEvent.setTime(currentTID);
                this.sequence.add(simulEvent);
            }
        } else {
            currentTID = 1;
            while ((line = reader.readLine()) != null) {
                String[] lineItems;
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                simulEvent = new Event();
                lineSplited = line.split("\\|");
                String[] stringArray = lineItems = lineSplited[0].split(" ");
                int n3 = lineItems.length;
                n = 0;
                while (n < n3) {
                    String itemString = stringArray[n];
                    Integer itemName = Integer.parseInt(itemString);
                    simulEvent.addEvent(itemName);
                    Integer count = (Integer)mapSingleEventCount.get(itemName);
                    if (count == null) {
                        mapSingleEventCount.put(itemName, 1);
                        ++this.candidateCount;
                    } else {
                        count = count + 1;
                        mapSingleEventCount.put(itemName, count);
                    }
                    ++n;
                }
                currentTID = Integer.parseInt(lineSplited[1]);
                simulEvent.setTime(currentTID);
                this.sequence.add(simulEvent);
            }
        }
        reader.close();
        for (Map.Entry entry : mapSingleEventCount.entrySet()) {
            if ((Integer)entry.getValue() < this.minSupport) continue;
            SerialEpisode episode = new SerialEpisode(new int[]{(Integer)entry.getKey()}, (Integer)entry.getValue());
            this.frequentEpisodes.addFrequentEpisode(episode, 1);
        }
        this.frequentEpisodes.initFirstLevelBlockStart();
    }

    public void printStats() {
        System.out.println("=============  MINEPI - STATS =============");
        System.out.println(" Candidates count : " + this.candidateCount);
        System.out.println(" The algorithm stopped at size : " + this.k);
        System.out.println(" Frequent episodes count : " + this.frequentEpisodes.getFrequentEpisodesCount());
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ : " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

