/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.huespan;

import ca.pfv.spmf.algorithms.episodes.huespan.HighUtilityEpisode;
import ca.pfv.spmf.algorithms.episodes.huespan.HighUtilityEpisodesOfSizeK;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HighUtilityEpisodes {
    private final List<HighUtilityEpisodesOfSizeK> hues = new ArrayList<HighUtilityEpisodesOfSizeK>();
    private int episodeCount = 0;

    HighUtilityEpisodes() {
        this.hues.add(new HighUtilityEpisodesOfSizeK());
    }

    public void addHighUtilityEpisode(HighUtilityEpisode HUE, int k) {
        while (this.hues.size() <= k) {
            this.hues.add(new HighUtilityEpisodesOfSizeK());
        }
        this.hues.get(k).addHighUtilityEpisodeOfSizeK(HUE);
        ++this.episodeCount;
    }

    public int getTotalSize() {
        return this.hues.size();
    }

    public int getHighUtilityEpisodeCount() {
        return this.episodeCount;
    }

    public void printHighUtilityEpisodes() {
        System.out.println(" ------- High Utility Episodes -------");
        int patternCount = 0;
        int numLevel = 0;
        for (HighUtilityEpisodesOfSizeK HUEofSizeK : this.hues) {
            System.out.println("  The size of episode is : " + numLevel + " \r\n");
            for (HighUtilityEpisode episode : HUEofSizeK.getHighUtilityEpisodesOfSizeK()) {
                System.out.print("  pattern " + patternCount + ":  ");
                System.out.println(episode.toString());
                ++patternCount;
            }
            ++numLevel;
        }
        System.out.println(" --------------------------------");
    }

    public void saveToFile(String output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        StringBuilder buffer = new StringBuilder();
        int numLevel = 0;
        for (HighUtilityEpisodesOfSizeK HUEofSizeK : this.hues) {
            buffer.append("  The size of episode is : " + numLevel + " \r\n");
            for (HighUtilityEpisode episode : HUEofSizeK.getHighUtilityEpisodesOfSizeK()) {
                buffer.append(episode.toString());
                buffer.append("\r\n");
            }
            buffer.append("\r\n");
            ++numLevel;
        }
        writer.write(buffer.toString());
        writer.close();
    }
}

