/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.clustering.dbscan;

import ca.pfv.spmf.algorithms.clustering.dbscan.DoubleArrayDBS;
import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceEuclidian;
import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceFunction;
import ca.pfv.spmf.datastructures.kdtree.KDTree;
import ca.pfv.spmf.patterns.cluster.Cluster;
import ca.pfv.spmf.patterns.cluster.ClustersEvaluation;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AlgoDBSCAN {
    protected List<Cluster> clusters = null;
    protected long startTimestamp;
    protected long endTimestamp;
    long numberOfNoisePoints;
    DistanceFunction distanceFunction = new DistanceEuclidian();
    KDTree kdtree;
    List<DoubleArray> bufferNeighboors1 = null;
    List<DoubleArray> bufferNeighboors2 = null;
    private List<String> attributeNames = null;

    public List<Cluster> runAlgorithm(String inputFile, int minPts, double epsilon, String separator) throws NumberFormatException, IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.numberOfNoisePoints = 0L;
        ArrayList<DoubleArray> points = new ArrayList<DoubleArray>();
        BufferedReader reader = new BufferedReader(new FileReader(inputFile));
        this.attributeNames = new ArrayList<String>();
        String currentInstanceName = null;
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%') continue;
            if (line.charAt(0) == '@') {
                if (line.startsWith("@NAME=")) {
                    currentInstanceName = line.substring(6, line.length());
                }
                if (!line.startsWith("@ATTRIBUTEDEF=")) continue;
                String attributeName = line.substring(14, line.length());
                this.attributeNames.add(attributeName);
                continue;
            }
            String nameToUse = currentInstanceName == null ? "Instance" + points.size() : currentInstanceName;
            currentInstanceName = null;
            String[] lineSplited = line.split(separator);
            double[] vector = new double[lineSplited.length];
            int i = 0;
            while (i < lineSplited.length) {
                double value;
                vector[i] = value = Double.parseDouble(lineSplited[i]);
                ++i;
            }
            points.add(new DoubleArrayDBS(vector, nameToUse));
        }
        reader.close();
        if (this.attributeNames.size() == 0 && points.size() > 0) {
            int dimensionCount = ((DoubleArray)points.get((int)0)).data.length;
            int i = 0;
            while (i < dimensionCount) {
                this.attributeNames.add("Attribute" + i);
                ++i;
            }
        }
        this.kdtree = new KDTree();
        this.kdtree.buildtree(points);
        this.clusters = new ArrayList<Cluster>();
        this.bufferNeighboors1 = new ArrayList<DoubleArray>();
        this.bufferNeighboors2 = new ArrayList<DoubleArray>();
        for (DoubleArray point : points) {
            DoubleArrayDBS pointDBS = (DoubleArrayDBS)point;
            if (pointDBS.visited) continue;
            pointDBS.visited = true;
            this.bufferNeighboors1.clear();
            this.kdtree.pointsWithinRadiusOf(pointDBS, epsilon, this.bufferNeighboors1);
            if (this.bufferNeighboors1.size() < minPts - 1) continue;
            this.expandCluster(pointDBS, this.bufferNeighboors1, epsilon, minPts);
        }
        for (DoubleArray point : points) {
            if (((DoubleArrayDBS)point).cluster != null) continue;
            ++this.numberOfNoisePoints;
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        this.bufferNeighboors1 = null;
        this.bufferNeighboors2 = null;
        this.kdtree = null;
        return this.clusters;
    }

    private void expandCluster(DoubleArrayDBS currentPoint, List<DoubleArray> neighboors, double epsilon, int minPts) {
        Cluster cluster = new Cluster();
        this.clusters.add(cluster);
        cluster.addVector(currentPoint);
        currentPoint.cluster = cluster;
        int i = 0;
        while (i < neighboors.size()) {
            DoubleArrayDBS newPointDBS = (DoubleArrayDBS)neighboors.get(i);
            if (!newPointDBS.visited) {
                newPointDBS.visited = true;
                this.bufferNeighboors2.clear();
                this.kdtree.pointsWithinRadiusOf(newPointDBS, epsilon, this.bufferNeighboors2);
                if (this.bufferNeighboors2.size() >= minPts - 1) {
                    neighboors.addAll(this.bufferNeighboors2);
                }
            }
            if (newPointDBS.cluster == null) {
                cluster.addVector(newPointDBS);
                newPointDBS.cluster = cluster;
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void saveToFile(String output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        for (String attributeName : this.attributeNames) {
            writer.write("@ATTRIBUTEDEF=" + attributeName);
            writer.newLine();
        }
        int i = 0;
        while (i < this.clusters.size()) {
            if (this.clusters.get(i).getVectors().size() >= 1) {
                writer.write(this.clusters.get(i).toString());
                if (i < this.clusters.size() - 1) {
                    writer.newLine();
                }
            }
            ++i;
        }
        writer.close();
    }

    public void printStatistics() {
        System.out.println("========== DBSCAN - SPMF 2.09 - STATS ============");
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory() + " mb ");
        System.out.println(" SSE (Sum of Squared Errors) (lower is better) : " + ClustersEvaluation.getSSE(this.clusters, this.distanceFunction));
        System.out.println(" Number of noise points: " + this.numberOfNoisePoints);
        System.out.println(" Number of clusters: " + this.clusters.size());
        System.out.println("=====================================");
    }
}

