/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.mac;

import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.mac.RuleMAC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Eclat {
    private double minsupRelative;
    private double minConf;
    private Dataset dataset;
    private List<RuleMAC> rules = new ArrayList<RuleMAC>();
    private Map<Short, Set<Integer>> klassesTIDS;

    public Eclat(Dataset dataset, double minSup, double minConf) {
        this.dataset = dataset;
        this.minConf = minConf;
        this.minsupRelative = Math.ceil(minSup * (double)dataset.getInstances().size());
    }

    public List<RuleMAC> run() {
        final Map<Short, Set<Integer>> mapItemTIDS = this.generateSingletons();
        ArrayList<Short> frequentItems = new ArrayList<Short>();
        for (Map.Entry<Short, Set<Integer>> entry : mapItemTIDS.entrySet()) {
            Set<Integer> tidset2 = entry.getValue();
            long support = tidset2.size();
            if (!((double)support >= this.minsupRelative)) continue;
            Short item = entry.getKey();
            frequentItems.add(item);
        }
        Collections.sort(frequentItems, new Comparator<Short>(){

            @Override
            public int compare(Short arg0, Short arg1) {
                return ((Set)mapItemTIDS.get(arg0)).size() - ((Set)mapItemTIDS.get(arg1)).size();
            }
        });
        List<RuleMAC> k2 = this.generateK2(frequentItems, mapItemTIDS);
        int i = 0;
        while (i < k2.size()) {
            RuleMAC itemI = k2.get(i);
            ArrayList<RuleMAC> prefixedItemsI = new ArrayList<RuleMAC>();
            int j = i + 1;
            while (j < k2.size()) {
                Set<Integer> tidsetIJ;
                RuleMAC itemJ = k2.get(j);
                if (itemI.getKlass() == itemJ.getKlass() && (double)(tidsetIJ = Eclat.intersection(itemI.getTidsetRule(), itemJ.getTidsetRule())).size() >= this.minsupRelative) {
                    Short[] newAntecedent = Eclat.union(itemI.getAntecedent(), itemJ.getAntecedent());
                    Set<Integer> tidsetAntecedent = Eclat.intersection(itemI.getTidsetAntecedent(), itemJ.getTidsetAntecedent());
                    RuleMAC rule = new RuleMAC(newAntecedent, tidsetAntecedent, itemI.getKlass(), tidsetIJ);
                    prefixedItemsI.add(rule);
                }
                ++j;
            }
            if (!prefixedItemsI.isEmpty()) {
                this.processPrefixedItems(itemI, prefixedItemsI);
            }
            ++i;
        }
        return this.rules;
    }

    private List<RuleMAC> generateK2(List<Short> frequentItems, Map<Short, Set<Integer>> mapItemTIDS) {
        ArrayList<RuleMAC> k2 = new ArrayList<RuleMAC>();
        for (Short itemI : frequentItems) {
            Set<Integer> tidsetI = mapItemTIDS.get(itemI);
            for (Map.Entry<Short, Set<Integer>> klass : this.klassesTIDS.entrySet()) {
                Set<Integer> tidsetIJ = Eclat.intersection(tidsetI, klass.getValue());
                RuleMAC rule = new RuleMAC(new Short[]{itemI}, tidsetI, klass.getKey(), tidsetIJ);
                this.saveRule(rule);
                k2.add(rule);
            }
        }
        return k2;
    }

    private Map<Short, Set<Integer>> generateSingletons() {
        HashMap<Short, Set<Integer>> itemTids = new HashMap<Short, Set<Integer>>();
        this.klassesTIDS = new HashMap<Short, Set<Integer>>();
        List<Instance> instances = this.dataset.getInstances();
        int tid = 0;
        while (tid < instances.size()) {
            Instance instance = instances.get(tid);
            int j = 0;
            while (j < this.dataset.getAttributes().size()) {
                Short itemJ = instance.getItems()[j];
                HashSet<Integer> tidset2 = (HashSet<Integer>)itemTids.get(itemJ);
                if (tidset2 == null) {
                    tidset2 = new HashSet<Integer>();
                    itemTids.put(itemJ, tidset2);
                }
                tidset2.add(tid);
                ++j;
            }
            Short klass = instance.getKlass();
            Set<Integer> tidset3 = this.klassesTIDS.get(klass);
            if (tidset3 == null) {
                tidset3 = new HashSet<Integer>();
                this.klassesTIDS.put(klass, tidset3);
            }
            tidset3.add(tid);
            ++tid;
        }
        return itemTids;
    }

    private void processPrefixedItems(RuleMAC rule, List<RuleMAC> prefixedItems) {
        if (prefixedItems.size() == 1) {
            RuleMAC itemI = prefixedItems.get(0);
            Short[] newAntecedent = Eclat.union(rule.getAntecedent(), itemI.getAntecedent());
            Set<Integer> newTidset = Eclat.intersection(rule.getTidsetRule(), itemI.getTidsetRule());
            Set<Integer> newTidsetAntecedent = Eclat.intersection(rule.getTidsetAntecedent(), itemI.getTidsetAntecedent());
            this.saveRule(new RuleMAC(newAntecedent, newTidsetAntecedent, rule.getKlass(), newTidset));
        } else if (prefixedItems.size() == 2) {
            Set<Integer> tidsetIJ;
            long supportIJ;
            RuleMAC itemI = prefixedItems.get(0);
            Short[] newAntecedent = Eclat.union(rule.getAntecedent(), itemI.getAntecedent());
            Set<Integer> newTidset = Eclat.intersection(rule.getTidsetRule(), itemI.getTidsetRule());
            Set<Integer> newTidsetAntecedent = Eclat.intersection(rule.getTidsetAntecedent(), itemI.getTidsetAntecedent());
            this.saveRule(new RuleMAC(newAntecedent, newTidsetAntecedent, rule.getKlass(), newTidset));
            RuleMAC itemJ = prefixedItems.get(1);
            Short[] newAntecedent2 = Eclat.union(rule.getAntecedent(), itemJ.getAntecedent());
            Set<Integer> newTidset2 = Eclat.intersection(rule.getTidsetRule(), itemJ.getTidsetRule());
            Set<Integer> newTidsetAntecedent2 = Eclat.intersection(rule.getTidsetAntecedent(), itemJ.getTidsetAntecedent());
            this.saveRule(new RuleMAC(newAntecedent2, newTidsetAntecedent2, rule.getKlass(), newTidset2));
            Short[] unionAntecedent = Eclat.union(newAntecedent, itemJ.getAntecedent());
            if (unionAntecedent.length <= this.dataset.getAttributes().size() && (double)(supportIJ = (long)(tidsetIJ = Eclat.intersection(newTidset, itemJ.getTidsetRule())).size()) >= this.minsupRelative) {
                Set<Integer> antecedentTidsetIJ = Eclat.intersection(newTidsetAntecedent, itemJ.getTidsetAntecedent());
                this.saveRule(new RuleMAC(unionAntecedent, antecedentTidsetIJ, rule.getKlass(), tidsetIJ));
            }
        } else {
            int i = 0;
            while (i < prefixedItems.size()) {
                RuleMAC itemI = prefixedItems.get(i);
                Short[] newAntecedent = Eclat.union(rule.getAntecedent(), itemI.getAntecedent());
                Set<Integer> newTidset = Eclat.intersection(rule.getTidsetRule(), itemI.getTidsetRule());
                Set<Integer> newTidsetAntecedent = Eclat.intersection(rule.getTidsetAntecedent(), itemI.getTidsetAntecedent());
                this.saveRule(new RuleMAC(newAntecedent, newTidsetAntecedent, rule.getKlass(), newTidset));
                ArrayList<RuleMAC> prefixedItemsSuffix = new ArrayList<RuleMAC>();
                int j = i + 1;
                while (j < prefixedItems.size()) {
                    RuleMAC suffixJ = prefixedItems.get(j);
                    Set<Integer> tidsetIJ = Eclat.intersection(newTidset, suffixJ.getTidsetRule());
                    long supportIJ = tidsetIJ.size();
                    if ((double)supportIJ >= this.minsupRelative) {
                        Short[] new2Antecedent = Eclat.union(newAntecedent, suffixJ.getAntecedent());
                        Set<Integer> tidsetAntecedent = Eclat.intersection(newTidsetAntecedent, suffixJ.getTidsetAntecedent());
                        prefixedItemsSuffix.add(new RuleMAC(new2Antecedent, tidsetAntecedent, rule.getKlass(), tidsetIJ));
                    }
                    ++j;
                }
                if (!prefixedItemsSuffix.isEmpty()) {
                    this.processPrefixedItems(new RuleMAC(newAntecedent, newTidsetAntecedent, rule.getKlass(), newTidset), prefixedItemsSuffix);
                }
                ++i;
            }
        }
    }

    public static Short[] union(Short[] antecedent1, List<Short> antecedent2) {
        ArrayList<Short> newArrayList = new ArrayList<Short>(antecedent2);
        Short[] shortArray = antecedent1;
        int n = antecedent1.length;
        int n2 = 0;
        while (n2 < n) {
            Short item = shortArray[n2];
            if (!antecedent2.contains(item)) {
                newArrayList.add(item);
            }
            ++n2;
        }
        return newArrayList.toArray(antecedent1);
    }

    public static Set<Integer> intersection(Set<Integer> setI, Set<Integer> setJ) {
        HashSet<Integer> result = new HashSet<Integer>();
        if (setI.size() > setJ.size()) {
            for (Integer tid : setJ) {
                if (!setI.contains(tid)) continue;
                result.add(tid);
            }
        } else {
            for (Integer tid : setI) {
                if (!setJ.contains(tid)) continue;
                result.add(tid);
            }
        }
        return result;
    }

    public static Short[] union(List<Short> antecedent, List<Short> antecedent2) {
        HashSet<Short> set = new HashSet<Short>(antecedent.size());
        set.addAll(antecedent);
        set.addAll(antecedent2);
        Short[] union = new Short[]{};
        union = set.toArray(union);
        return union;
    }

    private void saveRule(RuleMAC rule) {
        if (rule.getConfidence() >= this.minConf) {
            this.rules.add(rule);
        }
    }
}

