/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.logisticregression;

import ca.pfv.spmf.algorithms.classifiers.logisticregression.InstanceContinuous;
import ca.pfv.spmf.tools.MemoryLogger;
import java.util.Arrays;
import java.util.List;

public class AlgoBinaryLogisticRegression {
    double[] weights = null;
    double bias;
    int iterationCount = 1000;
    double learningRate = 0.1;
    int totalNumberIterations = 0;
    long totalTime = 0L;
    double totalMemory = 0.0;

    AlgoBinaryLogisticRegression() {
    }

    boolean predictBoolean(InstanceContinuous instance) {
        return this.weightedSum(instance.values) > 0.5;
    }

    double predictDouble(InstanceContinuous instance) {
        return this.weightedSum(instance.values);
    }

    public void setIterationCount(int count) {
        this.iterationCount = count;
    }

    public void setLearningRate(double rate) {
        this.learningRate = rate;
    }

    double sigmoid(double z) {
        return 1.0 / (1.0 + Math.pow(Math.E, -1.0 * z));
    }

    private double weightedSum(double[] instance) {
        double sum = this.bias;
        int i = 0;
        while (i < this.weights.length) {
            sum += instance[i] * this.weights[i];
            ++i;
        }
        return this.sigmoid(sum);
    }

    void train(List<InstanceContinuous> instances, List<Boolean> targetOutputs) {
        this.totalNumberIterations = 0;
        this.totalTime = System.currentTimeMillis();
        MemoryLogger.getInstance().reset();
        int featureCount = instances.get((int)0).values.length;
        this.weights = new double[featureCount];
        this.bias = Math.random();
        double[] weightChanges = new double[featureCount];
        double learningRateDivided = this.learningRate / (double)instances.size();
        double stopMax = this.learningRate / 3.0;
        double stopMin = -stopMax;
        int j = 0;
        while (j < this.iterationCount) {
            Arrays.fill(weightChanges, 0.0);
            double biasChange = 0.0;
            int k = 0;
            while (k < instances.size()) {
                double[] instanceKValues = instances.get((int)k).values;
                double targetClass = targetOutputs.get(k) != false ? 1.0 : 0.0;
                double predictedClass = this.weightedSum(instanceKValues);
                int i = 0;
                while (i < featureCount) {
                    int n = i;
                    weightChanges[n] = weightChanges[n] - (predictedClass - targetClass) * instanceKValues[i];
                    ++i;
                }
                biasChange -= predictedClass - targetClass;
                ++k;
            }
            int i = 0;
            while (i < featureCount) {
                int n = i;
                this.weights[n] = this.weights[n] + learningRateDivided * weightChanges[i];
                ++i;
            }
            this.bias += learningRateDivided * biasChange;
            ++this.totalNumberIterations;
            if (biasChange < stopMax && biasChange > stopMin) break;
            ++j;
        }
        MemoryLogger.getInstance().checkMemory();
        this.totalTime = System.currentTimeMillis() - this.totalTime;
        this.totalMemory = MemoryLogger.getInstance().getMaxMemory();
    }

    public void printStats() {
        System.out.println("=============  BinaryLogisticRegression v.2.53 - STATS =============");
        System.out.println(" Stopped at " + this.totalNumberIterations + " iterations.");
        System.out.println(" Total time ~ " + this.totalTime + " ms");
        System.out.println(" Maximum memory usage : " + this.totalMemory + " mb");
        System.out.println("===================================================");
    }
}

