/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.l3;

import ca.pfv.spmf.algorithms.classifiers.cmar.FPGrowthForCMAR;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.l3.RuleL3;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class FPGrowthForL3
extends FPGrowthForCMAR {
    private Map<Short, Long> supportByKlass = new HashMap<Short, Long>();

    public FPGrowthForL3(Dataset training, double minSup, double minConf) {
        super(training, minSup, minConf);
        for (Map.Entry<Short, Long> entry : training.getMapClassToFrequency().entrySet()) {
            this.supportByKlass.put(entry.getKey(), (long)Math.ceil((double)entry.getValue().longValue() * minSup));
        }
    }

    @Override
    protected void generateRules(short[] itemset2, int itemsetLength, long support, Map<Short, Long> counterByKlass) {
        short[] itemsetOutputBuffer = new short[itemsetLength];
        System.arraycopy(itemset2, 0, itemsetOutputBuffer, 0, itemsetLength);
        Arrays.sort(itemsetOutputBuffer, 0, itemsetLength);
        for (Map.Entry<Short, Long> entry : counterByKlass.entrySet()) {
            RuleL3 rule = new RuleL3(itemsetOutputBuffer, entry.getKey());
            rule.setSupportAntecedent(support);
            rule.setSupportRule(entry.getValue());
            rule.setSupportKlass(this.dataset.getMapClassToFrequency().get(rule.getKlass()));
            if (rule.getSupportRule() < this.supportByKlass.get(rule.getKlass()) || !(rule.getConfidence() >= this.minConf)) continue;
            this.rules.add(rule);
        }
    }
}

