/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.knn;

import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.Classifier;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ClassifierKNN
extends Classifier
implements Serializable {
    private static final long serialVersionUID = 3234449944366L;
    private Dataset dataset;
    private int k;

    public ClassifierKNN(Dataset dataset, int k) {
        this.dataset = dataset;
        this.k = k;
    }

    @Override
    public String getName() {
        return "KNN";
    }

    @Override
    public short predict(Instance instanceX) {
        Object[] arrayInstance = new InstanceMatch[this.dataset.getInstances().size()];
        int i = 0;
        while (i < this.dataset.getInstances().size()) {
            Instance instanceY = this.dataset.getInstances().get(i);
            int sameItemCount = this.findNumberCommonItems(instanceX, instanceY);
            arrayInstance[i] = new InstanceMatch(instanceY, sameItemCount);
            ++i;
        }
        Arrays.sort(arrayInstance);
        HashMap<Short, Long> mapItemCount = new HashMap<Short, Long>();
        int previousMatches = Integer.MAX_VALUE;
        int i2 = 0;
        while (true) {
            Short classValue = ((InstanceMatch)arrayInstance[i2]).instance.getKlass();
            Long count = mapItemCount.getOrDefault(classValue, 0L);
            mapItemCount.put(classValue, count + 1L);
            if (++i2 == arrayInstance.length || i2 >= this.k && ((InstanceMatch)arrayInstance[i2]).nbMatches < previousMatches) break;
            previousMatches = ((InstanceMatch)arrayInstance[i2]).nbMatches;
        }
        long highestCount = 0L;
        Short highestName = null;
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Long)entry.getValue() <= highestCount) continue;
            highestCount = (Long)entry.getValue();
            highestName = (Short)entry.getKey();
        }
        return highestName;
    }

    private int findNumberCommonItems(Instance instanceX, Instance instanceY) {
        int count = 0;
        Short[] itemsX = instanceX.getItems();
        Short[] itemsY = instanceY.getItems();
        int i = 0;
        while (i < itemsX.length) {
            if (itemsX[i].equals(itemsY[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private class InstanceMatch
    implements Comparable<InstanceMatch> {
        Instance instance;
        int nbMatches;

        InstanceMatch(Instance instance, int nbMatches) {
            this.instance = instance;
            this.nbMatches = nbMatches;
        }

        @Override
        public int compareTo(InstanceMatch other) {
            return other.nbMatches - this.nbMatches;
        }
    }
}

