/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.general;

import ca.pfv.spmf.algorithms.classifiers.general.ConfusionMatrix;
import ca.pfv.spmf.algorithms.classifiers.general.Evaluator;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;

public class OverallResults {
    List<Long> runtimeToTrain = new ArrayList<Long>();
    List<Double> memoryToTrain = new ArrayList<Double>();
    List<Double> avgRuleCount = new ArrayList<Double>();
    List<ConfusionMatrix> listMatrixOnTraining = new ArrayList<ConfusionMatrix>();
    List<Long> runtimeOnTraining = new ArrayList<Long>();
    List<Double> memoryUsageOnTraining = new ArrayList<Double>();
    List<ConfusionMatrix> listMatrixOnTesting = new ArrayList<ConfusionMatrix>();
    List<List<Short>> predictedClasseOnTesting = new ArrayList<List<Short>>();
    List<Long> runtimeOnTesting = new ArrayList<Long>();
    List<Double> memoryUsageOnTesting = new ArrayList<Double>();
    Format df = new DecimalFormat("#.####");
    List<String> names = new ArrayList<String>();
    int algorithmCount;

    public OverallResults(List<String> names) {
        this.names = names;
        this.algorithmCount = names.size();
        this.runtimeToTrain = new ArrayList<Long>();
        this.memoryToTrain = new ArrayList<Double>(this.algorithmCount);
        this.listMatrixOnTraining = new ArrayList<ConfusionMatrix>(this.algorithmCount);
        this.runtimeOnTraining = new ArrayList<Long>(this.algorithmCount);
        this.memoryUsageOnTraining = new ArrayList<Double>(this.algorithmCount);
        this.listMatrixOnTesting = new ArrayList<ConfusionMatrix>(this.algorithmCount);
        this.predictedClasseOnTesting = new ArrayList<List<Short>>(this.algorithmCount);
        this.runtimeOnTesting = new ArrayList<Long>(this.algorithmCount);
        this.memoryUsageOnTesting = new ArrayList<Double>(this.algorithmCount);
    }

    public void addResults(Evaluator.ClassificationResults resultsOnTraining, Evaluator.ClassificationResults resultsOnTesting, Evaluator.TrainingResults trainResults) {
        if (trainResults != null) {
            this.runtimeToTrain.add(trainResults.runtime);
            this.memoryToTrain.add(trainResults.memory);
            this.avgRuleCount.add(trainResults.avgRuleCount);
        }
        if (resultsOnTraining != null) {
            this.listMatrixOnTraining.add(resultsOnTraining.matrix);
            this.runtimeOnTraining.add(resultsOnTraining.runtime);
            this.memoryUsageOnTraining.add(resultsOnTraining.memory);
        }
        if (resultsOnTesting != null) {
            this.listMatrixOnTesting.add(resultsOnTesting.matrix);
            this.predictedClasseOnTesting.add(resultsOnTesting.predictedClasses);
            this.runtimeOnTesting.add(resultsOnTesting.runtime);
            this.memoryUsageOnTesting.add(resultsOnTesting.memory);
        }
    }

    public void saveMetricsResultsToFile(String toTrainpath, String onTrainingPath, String onTestingPath) {
        try {
            PrintWriter metricsWriter;
            if (toTrainpath != null) {
                metricsWriter = new PrintWriter(toTrainpath, "UTF-8");
                metricsWriter.write(this.trainingMetricsToString(this.runtimeToTrain, this.memoryToTrain));
                metricsWriter.close();
            }
            if (onTrainingPath != null) {
                metricsWriter = new PrintWriter(onTrainingPath, "UTF-8");
                metricsWriter.write(this.metricsToString(this.listMatrixOnTraining, this.runtimeOnTraining, this.memoryUsageOnTraining));
                metricsWriter.close();
            }
            if (onTestingPath != null) {
                metricsWriter = new PrintWriter(onTestingPath, "UTF-8");
                metricsWriter.write(this.metricsToString(this.listMatrixOnTesting, this.runtimeOnTesting, this.memoryUsageOnTesting));
                metricsWriter.close();
            }
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void printStats() {
        System.out.println("=== MODEL TRAINING RESULTS ===");
        System.out.println(this.trainingMetricsToString(this.runtimeToTrain, this.memoryToTrain));
        System.out.println("==== CLASSIFICATION RESULTS ON TRAINING DATA =====");
        System.out.println(this.metricsToString(this.listMatrixOnTraining, this.runtimeOnTraining, this.memoryUsageOnTraining));
        System.out.println();
        System.out.println("==== CLASSIFICATION RESULTS ON TESTING DATA =====");
        System.out.println(this.metricsToString(this.listMatrixOnTesting, this.runtimeOnTesting, this.memoryUsageOnTesting));
    }

    private String trainingMetricsToString(List<Long> runtimes, List<Double> memoryUsages) {
        StringBuilder builder = new StringBuilder();
        builder.append("#NAME:\t");
        int i = 0;
        while (i < this.algorithmCount) {
            builder.append("\t" + this.names.get(i));
            ++i;
        }
        builder.append(System.lineSeparator());
        builder.append("#RULECOUNT:");
        i = 0;
        while (i < this.algorithmCount) {
            builder.append("\t" + this.df.format(this.avgRuleCount.get(i)));
            ++i;
        }
        builder.append(System.lineSeparator());
        builder.append("#TIMEms:");
        i = 0;
        while (i < this.algorithmCount) {
            builder.append("\t" + runtimes.get(i));
            ++i;
        }
        builder.append(System.lineSeparator());
        builder.append("#MEMORYmb:");
        i = 0;
        while (i < this.algorithmCount) {
            builder.append("\t" + this.df.format(memoryUsages.get(i)));
            ++i;
        }
        builder.append(System.lineSeparator());
        return builder.toString();
    }

    private String metricsToString(List<ConfusionMatrix> listMatrix, List<Long> runtimes, List<Double> memoryUsages) {
        StringBuilder builder = new StringBuilder();
        builder.append("#NAME:\t");
        int i = 0;
        while (i < this.algorithmCount) {
            builder.append("\t" + this.names.get(i));
            ++i;
        }
        builder.append(System.lineSeparator());
        builder.append("#ACCURACY:");
        i = 0;
        while (i < this.algorithmCount) {
            builder.append("\t" + this.df.format(listMatrix.get(i).getAccuracy()));
            ++i;
        }
        builder.append(System.lineSeparator());
        builder.append("#RECALL:");
        i = 0;
        while (i < this.algorithmCount) {
            builder.append("\t" + this.df.format(listMatrix.get(i).getAverageRecall()));
            ++i;
        }
        builder.append(System.lineSeparator());
        builder.append("#PRECISION:");
        i = 0;
        while (i < this.algorithmCount) {
            builder.append("\t" + this.df.format(listMatrix.get(i).getAveragePrecision()));
            ++i;
        }
        builder.append(System.lineSeparator());
        builder.append("#KAPPA:");
        i = 0;
        while (i < this.algorithmCount) {
            builder.append("\t" + this.df.format(listMatrix.get(i).getKappa()));
            ++i;
        }
        builder.append(System.lineSeparator());
        builder.append("#FMICRO:");
        i = 0;
        while (i < this.algorithmCount) {
            builder.append("\t" + this.df.format(listMatrix.get(i).getMicroFMeasure()));
            ++i;
        }
        builder.append(System.lineSeparator());
        builder.append("#FMACRO:");
        i = 0;
        while (i < this.algorithmCount) {
            builder.append("\t" + this.df.format(listMatrix.get(i).getMacroFMeasure()));
            ++i;
        }
        builder.append(System.lineSeparator());
        builder.append("#TIMEms:");
        i = 0;
        while (i < this.algorithmCount) {
            builder.append("\t" + runtimes.get(i));
            ++i;
        }
        builder.append(System.lineSeparator());
        builder.append("#MEMORYmb:");
        i = 0;
        while (i < this.algorithmCount) {
            builder.append("\t" + this.df.format(memoryUsages.get(i)));
            ++i;
        }
        builder.append(System.lineSeparator());
        builder.append("#NOPREDICTION:");
        i = 0;
        while (i < this.algorithmCount) {
            builder.append("\t" + listMatrix.get(i).getNopredictions());
            ++i;
        }
        return builder.toString();
    }
}

