/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.general;

import ca.pfv.spmf.algorithms.classifiers.general.Classifier;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ConfusionMatrix {
    long total = 0L;
    long correct = 0L;
    long nopredictions = 0L;
    Map<Short, Map<Short, Long>> matrix;
    Set<Short> allRealklasss = new TreeSet<Short>();
    Set<Short> allPredictedklasss = new TreeSet<Short>();

    public ConfusionMatrix() {
        this.matrix = new TreeMap<Short, Map<Short, Long>>();
    }

    public double getAverageRecall() {
        double result = 0.0;
        for (Short klass : this.allRealklasss) {
            result += this.getRecallForKlass(klass);
        }
        return result / (double)this.allRealklasss.size();
    }

    public double getAveragePrecision() {
        double result = 0.0;
        for (Short klass : this.allRealklasss) {
            result += this.getPrecisionForKlass(klass);
        }
        return result / (double)this.allRealklasss.size();
    }

    public double getMicroFMeasure() {
        long allTruePositives = 0L;
        long allTruePositivesAndFalsePositives = 0L;
        long allTruePositivesAndFalseNegatives = 0L;
        for (Map.Entry<Short, Map<Short, Long>> x : this.matrix.entrySet()) {
            Long value;
            Short klass = x.getKey();
            Map<Short, Long> map = this.matrix.get(klass);
            if (map != null && (value = map.get(klass)) != null) {
                allTruePositives += value.longValue();
            }
            allTruePositivesAndFalsePositives += this.getColSum(klass);
            allTruePositivesAndFalseNegatives += this.getRowSum(klass);
        }
        double precision = (double)allTruePositives / (double)allTruePositivesAndFalsePositives;
        double recall = (double)allTruePositives / (double)allTruePositivesAndFalseNegatives;
        return 2.0 * precision * recall / (precision + recall);
    }

    public double getMacroFMeasure() {
        double totalFMeasure = 0.0;
        for (Short klass : this.allRealklasss) {
            double p = this.getPrecisionForKlass(klass);
            double r = this.getRecallForKlass(klass);
            double fm = 0.0;
            if (p + r > 0.0) {
                fm = 2.0 * p * r / (p + r);
            }
            totalFMeasure += fm;
        }
        return totalFMeasure / (double)this.allRealklasss.size();
    }

    private double getRecallForKlass(Short klass) {
        Long value;
        long fnTp = 0L;
        double recall = 0.0;
        long tp = 0L;
        Map<Short, Long> map = this.matrix.get(klass);
        if (map != null && (value = map.get(klass)) != null) {
            tp = value;
            fnTp = this.getRowSum(klass);
        }
        if (fnTp > 0L) {
            recall = (double)tp / (double)fnTp;
        }
        return recall;
    }

    public void add(Short realValue, Short observedValue) {
        Long value;
        this.allRealklasss.add(realValue);
        this.allPredictedklasss.add(observedValue);
        Map<Short, Long> map = this.matrix.get(realValue);
        if (map == null) {
            map = new TreeMap<Short, Long>();
            this.matrix.put(realValue, map);
        }
        if ((value = map.get(observedValue)) == null) {
            map.put(observedValue, 1L);
        } else {
            map.put(observedValue, value + 1L);
        }
        ++this.total;
        if (realValue.equals(Classifier.NOPREDICTION)) {
            ++this.nopredictions;
        }
        if (realValue.equals(observedValue)) {
            ++this.correct;
        }
    }

    public double getAccuracy() {
        return (double)this.correct / (double)this.total;
    }

    public double getKappa() {
        double p0 = this.getAccuracy();
        double pe = 0.0;
        for (Short klass : this.allRealklasss) {
            double rowSum = this.getRowSum(klass);
            double colSum = this.getColSum(klass);
            pe += rowSum * colSum / (double)this.total;
        }
        return (p0 - (pe /= (double)this.total)) / (1.0 - pe);
    }

    private double getPrecisionForKlass(Short klass) {
        Long value;
        double precision = 0.0;
        long tp = 0L;
        long fpTp = 0L;
        Map<Short, Long> map = this.matrix.get(klass);
        if (map != null && (value = this.matrix.get(klass).get(klass)) != null) {
            tp = value;
            fpTp = this.getColSum(klass);
        }
        if (fpTp > 0L) {
            precision = (double)tp / (double)fpTp;
        }
        return precision;
    }

    private long getColSum(Short klass) {
        long result = 0L;
        for (Map.Entry<Short, Map<Short, Long>> entry : this.matrix.entrySet()) {
            Map<Short, Long> row = entry.getValue();
            Long val = row.get(klass);
            if (val == null) continue;
            result += val.longValue();
        }
        return result;
    }

    private long getRowSum(Short klass) {
        long result = 0L;
        for (Map.Entry<Short, Long> entry : this.matrix.get(klass).entrySet()) {
            result += entry.getValue().longValue();
        }
        return result;
    }

    protected float getNopredictions() {
        return (float)this.nopredictions / (float)this.total;
    }
}

