/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.decisiontree.id3;

import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.ClassNode;
import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.ClassifierID3;
import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.DecisionNode;
import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.DecisionTree;
import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.Node;
import ca.pfv.spmf.algorithms.classifiers.general.ClassificationAlgorithm;
import ca.pfv.spmf.algorithms.classifiers.general.Classifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoID3
extends ClassificationAlgorithm {
    private List<Short> targetAttributeValues;
    private long startTime;
    private long endTime;

    private Node id3(int[] remainingAttributes, List<Instance> list, Map<Short, Long> mapClassToSupport) {
        Map<Short, Long> targetValuesFrequency = mapClassToSupport == null ? this.calculateFrequencyOfClassValues(list) : mapClassToSupport;
        if (remainingAttributes.length == 0) {
            long highestCount = 0L;
            Short highestName = null;
            for (Map.Entry<Short, Long> entry : targetValuesFrequency.entrySet()) {
                if (entry.getValue() <= highestCount) continue;
                highestCount = entry.getValue();
                highestName = entry.getKey();
            }
            ClassNode classNode = new ClassNode();
            classNode.className = highestName;
            return classNode;
        }
        if (targetValuesFrequency.entrySet().size() == 1) {
            ClassNode classNode = new ClassNode();
            classNode.className = targetValuesFrequency.entrySet().iterator().next().getKey();
            return classNode;
        }
        double globalEntropy = 0.0;
        for (Short value : this.targetAttributeValues) {
            Long frequencyInt = targetValuesFrequency.get(value);
            if (frequencyInt == null) continue;
            double frequencyDouble = (double)frequencyInt.longValue() / (double)list.size();
            globalEntropy -= frequencyDouble * Math.log(frequencyDouble) / Math.log(2.0);
        }
        int attributeWithHighestGain = 0;
        double highestGain = -99999.0;
        int[] nArray = remainingAttributes;
        int n = remainingAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            int attribute = nArray[n2];
            double gain = this.calculateGain(attribute, list, globalEntropy);
            if (gain >= highestGain) {
                highestGain = gain;
                attributeWithHighestGain = attribute;
            }
            ++n2;
        }
        if (highestGain == 0.0) {
            ClassNode classNode = new ClassNode();
            long topFrequency = 0L;
            Short className = null;
            for (Map.Entry<Short, Long> entry : targetValuesFrequency.entrySet()) {
                if (entry.getValue() <= topFrequency) continue;
                topFrequency = entry.getValue();
                className = entry.getKey();
            }
            classNode.className = className;
            return classNode;
        }
        DecisionNode decisionNode = new DecisionNode();
        decisionNode.attribute = attributeWithHighestGain;
        int[] newRemainingAttribute = new int[remainingAttributes.length - 1];
        int pos = 0;
        int i = 0;
        while (i < remainingAttributes.length) {
            if (remainingAttributes[i] != attributeWithHighestGain) {
                newRemainingAttribute[pos++] = remainingAttributes[i];
            }
            ++i;
        }
        HashMap<Short, ArrayList<Instance>> partitions = new HashMap<Short, ArrayList<Instance>>();
        for (Instance instance : list) {
            Short value = instance.getItems()[attributeWithHighestGain];
            ArrayList<Instance> listInstances = (ArrayList<Instance>)partitions.get(value);
            if (listInstances == null) {
                listInstances = new ArrayList<Instance>();
                partitions.put(value, listInstances);
            }
            listInstances.add(instance);
        }
        decisionNode.nodes = new Node[partitions.size()];
        decisionNode.attributeValues = new Short[partitions.size()];
        int index = 0;
        for (Map.Entry partition : partitions.entrySet()) {
            decisionNode.attributeValues[index] = (Short)partition.getKey();
            decisionNode.nodes[index] = this.id3(newRemainingAttribute, (List)partition.getValue(), null);
            ++index;
        }
        return decisionNode;
    }

    private double calculateGain(int attributePos, List<Instance> instances, double globalEntropy) {
        Map<Short, Long> valuesFrequency = this.calculateFrequencyOfAttributeValues(instances, attributePos);
        double sum = 0.0;
        for (Map.Entry<Short, Long> entry : valuesFrequency.entrySet()) {
            sum += (double)entry.getValue().longValue() / (double)instances.size() * this.calculateEntropyIfValue(instances, attributePos, entry.getKey());
        }
        return globalEntropy - sum;
    }

    private double calculateEntropyIfValue(List<Instance> instances, int attributeIF, Short valueIF) {
        int instancesCount = 0;
        HashMap<Short, Integer> valuesFrequency = new HashMap<Short, Integer>();
        for (Instance instance : instances) {
            if (!instance.getItems()[attributeIF].equals(valueIF)) continue;
            Short targetValue = instance.getKlass();
            if (valuesFrequency.get(targetValue) == null) {
                valuesFrequency.put(targetValue, 1);
            } else {
                valuesFrequency.put(targetValue, (Integer)valuesFrequency.get(targetValue) + 1);
            }
            ++instancesCount;
        }
        double entropy = 0.0;
        for (Short value : this.targetAttributeValues) {
            Integer count = (Integer)valuesFrequency.get(value);
            if (count == null) continue;
            double frequency = (double)count.intValue() / (double)instancesCount;
            entropy -= frequency * Math.log(frequency) / Math.log(2.0);
        }
        return entropy;
    }

    private Map<Short, Long> calculateFrequencyOfAttributeValues(List<Instance> instances, int attributePos) {
        HashMap<Short, Long> targetValuesFrequency = new HashMap<Short, Long>();
        for (Instance instance : instances) {
            Short targetValue = instance.getItems()[attributePos];
            if (targetValuesFrequency.get(targetValue) == null) {
                targetValuesFrequency.put(targetValue, 1L);
                continue;
            }
            targetValuesFrequency.put(targetValue, (Long)targetValuesFrequency.get(targetValue) + 1L);
        }
        return targetValuesFrequency;
    }

    private Map<Short, Long> calculateFrequencyOfClassValues(List<Instance> instances) {
        HashMap<Short, Long> targetValuesFrequency = new HashMap<Short, Long>();
        for (Instance instance : instances) {
            Short targetValue = instance.getKlass();
            if (targetValuesFrequency.get(targetValue) == null) {
                targetValuesFrequency.put(targetValue, 1L);
                continue;
            }
            targetValuesFrequency.put(targetValue, (Long)targetValuesFrequency.get(targetValue) + 1L);
        }
        return targetValuesFrequency;
    }

    public void printStatistics() {
        System.out.println("Time to construct decision tree = " + (this.endTime - this.startTime) + " ms");
        System.out.println();
    }

    @Override
    protected Classifier train(Dataset dataset) {
        this.startTime = System.currentTimeMillis();
        DecisionTree tree = new DecisionTree(dataset.getMapItemToString(), dataset.getAttributes());
        int[] remainingAttributes = new int[dataset.getAttributes().size()];
        int j = 0;
        while (j < dataset.getAttributes().size()) {
            remainingAttributes[j] = j;
            ++j;
        }
        this.targetAttributeValues = dataset.getListOfClassValues();
        tree.root = this.id3(remainingAttributes, dataset.getInstances(), dataset.getMapClassToFrequency());
        this.endTime = System.currentTimeMillis();
        return new ClassifierID3(tree);
    }

    @Override
    public String getName() {
        return "ID3";
    }
}

