/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.data;

import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import java.util.ArrayList;

public class VirtualDataset
extends Dataset {
    VirtualDataset(Dataset dataset, int i, int j, String addedName) {
        this.instances = dataset.instances.subList(i, j);
        this.recalculateClassFrequencies();
        this.attributes = dataset.attributes;
        this.targetClassValues = dataset.targetClassValues;
        this.mapItemToString = dataset.mapItemToString;
        this.listAttributeIndexToItems = dataset.listAttributeIndexToItems;
        this.lastGivenID = dataset.lastGivenID;
        this.indexKlass = dataset.indexKlass;
        this.hasMissingValue = dataset.hasMissingValue;
        this.name = String.valueOf(dataset.getName()) + addedName;
    }

    public VirtualDataset(Dataset dataset, boolean isTesting, int posStart, int posEnd, String addedName) {
        int recordCount = dataset.getInstances().size();
        int testingSize = posEnd - posStart;
        int thisSize = isTesting ? testingSize : recordCount - testingSize;
        this.instances = new ArrayList(thisSize);
        int j = 0;
        while (j < dataset.getInstances().size()) {
            Instance instanceJ = dataset.getInstances().get(j);
            if (j >= posStart && j < posEnd) {
                if (isTesting) {
                    this.instances.add(instanceJ);
                }
            } else if (!isTesting) {
                this.instances.add(instanceJ);
            }
            ++j;
        }
        this.recalculateClassFrequencies();
        this.attributes = dataset.attributes;
        this.targetClassValues = dataset.targetClassValues;
        this.mapItemToString = dataset.mapItemToString;
        this.listAttributeIndexToItems = dataset.listAttributeIndexToItems;
        this.lastGivenID = dataset.lastGivenID;
        this.indexKlass = dataset.indexKlass;
        this.hasMissingValue = dataset.hasMissingValue;
        this.name = String.valueOf(dataset.getName()) + addedName;
    }

    public static Dataset[] splitDatasetForHoldout(Dataset dataset, double percentage) {
        int recordCount = dataset.getInstances().size();
        int recordCountFirstPart = (int)((double)recordCount * percentage);
        VirtualDataset dataset1 = new VirtualDataset(dataset, 0, recordCountFirstPart, "training");
        VirtualDataset dataset2 = new VirtualDataset(dataset, recordCountFirstPart, recordCount, "testing");
        return new Dataset[]{dataset1, dataset2};
    }

    public static Dataset[] splitDatasetForKFold(Dataset dataset, int i, int j) {
        VirtualDataset dataset1 = new VirtualDataset(dataset, false, i, j, "training");
        VirtualDataset dataset2 = new VirtualDataset(dataset, true, i, j, "testing");
        return new Dataset[]{dataset1, dataset2};
    }
}

