/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.data;

import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringDataset
extends Dataset
implements Serializable {
    private static final long serialVersionUID = 3107045909585715L;
    private String klass = null;

    public StringDataset(String path, String className) throws Exception {
        this.klass = className;
        try {
            String line;
            FileReader fileReader = new FileReader(path);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String header = bufferedReader.readLine();
            String[] nameAttributes = header.split(this.getSeparator());
            ArrayList metadataAttributes = new ArrayList();
            int i = 0;
            while (i < nameAttributes.length) {
                metadataAttributes.add(new ArrayList());
                ++i;
            }
            ArrayList<String[]> lines = new ArrayList<String[]>();
            while ((line = bufferedReader.readLine()) != null) {
                String[] values = line.split(this.getSeparator());
                if (line.isEmpty() || values.length <= 0) continue;
                int i2 = 0;
                while (i2 < values.length) {
                    if (!((List)metadataAttributes.get(i2)).contains(values[i2])) {
                        ((List)metadataAttributes.get(i2)).add(values[i2]);
                    }
                    ++i2;
                }
                lines.add(values);
            }
            Object[] klassValues = null;
            int klassIndexInFile = -1;
            int i3 = 0;
            while (i3 < metadataAttributes.size()) {
                String nameAttribute = nameAttributes[i3];
                Object[] values = new String[((List)metadataAttributes.get(i3)).size()];
                ((List)metadataAttributes.get(i3)).toArray(values);
                Arrays.sort(values);
                if (nameAttribute.contains(this.klass)) {
                    klassValues = values;
                    klassIndexInFile = i3;
                } else {
                    this.addNominalAttribute(nameAttribute, (String[])values);
                }
                ++i3;
            }
            if (klassValues == null) {
                bufferedReader.close();
                throw new Exception("The target attribute \"" + className + "\" that you have chosen does not exist.");
            }
            this.addKlass((String[])klassValues);
            i3 = 0;
            while (i3 < lines.size()) {
                String[] lineX = (String[])lines.get(i3);
                String[] reorderedLine = new String[lineX.length];
                int currentPosition = 0;
                int j = 0;
                while (j < lineX.length) {
                    if (j != klassIndexInFile) {
                        reorderedLine[currentPosition++] = lineX[j];
                    }
                    ++j;
                }
                reorderedLine[reorderedLine.length - 1] = lineX[klassIndexInFile];
                this.getItemForAttributeValue(reorderedLine);
                ++i3;
            }
            lines.clear();
            bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String getKlassName() {
        return this.klass;
    }

    protected String getSeparator() {
        return " ";
    }
}

