/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.data;

import ca.pfv.spmf.algorithms.classifiers.data.Attribute;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Dataset {
    protected List<Instance> instances;
    protected List<Attribute> attributes;
    protected String[] targetClassValues;
    protected Map<Short, Long> mapClassToFrequency = null;
    protected Map<Short, String> mapItemToString = new HashMap<Short, String>();
    protected List<List<Short>> listAttributeIndexToItems;
    protected short lastGivenID = 0;
    protected int indexKlass = -1;
    protected boolean hasMissingValue = false;
    protected String name = "UNTITLED_DATA";

    public Dataset() {
        this.instances = new ArrayList<Instance>();
        this.attributes = new ArrayList<Attribute>();
        this.listAttributeIndexToItems = new ArrayList<List<Short>>();
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public int getClassesCount() {
        return this.targetClassValues.length;
    }

    public String[] getTargetClassValues() {
        return this.targetClassValues;
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public void getItemForAttributeValue(String[] attributeValues) throws Exception {
        String klass = attributeValues[this.indexKlass].trim();
        Short internalRepresentationKlass = this.getItemRepresentingKlass(klass);
        Instance instance = new Instance(attributeValues.length);
        int i = 0;
        int j = 0;
        while (i < attributeValues.length) {
            if (i != this.indexKlass) {
                short internalRepresentation = this.getItemRepresentingAttributeValue(j, attributeValues[i].trim());
                if (internalRepresentation < 0) {
                    this.hasMissingValue = true;
                }
                instance.set(j, internalRepresentation);
                Short valueJ = instance.getAttributeValue(j);
                if (!this.mapItemToString.containsKey(valueJ)) {
                    this.mapItemToString.put(valueJ, attributeValues[i].trim());
                }
                ++j;
            }
            ++i;
        }
        if (internalRepresentationKlass < 0) {
            this.hasMissingValue = true;
        }
        instance.setKlass(internalRepresentationKlass);
        if (!this.mapItemToString.containsKey(internalRepresentationKlass)) {
            this.mapItemToString.put(internalRepresentationKlass, klass);
        }
        this.getInstances().add(instance);
    }

    short getItemRepresentingAttributeValue(int indexAttribute, String value) throws Exception {
        Attribute attribute = this.getAttributes().get(indexAttribute);
        int i = 0;
        while (i < attribute.getValues().length) {
            if (attribute.getValues()[i].equals(value)) {
                return this.listAttributeIndexToItems.get(indexAttribute).get(i);
            }
            ++i;
        }
        return -1;
    }

    short getItemRepresentingKlass(String value) {
        List<Short> klassIndexes = this.listAttributeIndexToItems.get(this.indexKlass);
        int i = 0;
        while (i < klassIndexes.size()) {
            if (this.targetClassValues[i].equals(value)) {
                return klassIndexes.get(i);
            }
            ++i;
        }
        return -1;
    }

    public void addNominalAttribute(String name, String[] values) {
        this.listAttributeIndexToItems.add(new ArrayList());
        int indexAttribute = this.getAttributes().size();
        int i = 1;
        while (i <= values.length) {
            this.lastGivenID = (short)(this.lastGivenID + 1);
            this.listAttributeIndexToItems.get(indexAttribute).add(this.lastGivenID);
            i = (short)(i + 1);
        }
        this.getAttributes().add(new Attribute(name, values));
    }

    public void addNumericAttribute(String nameAttribute) {
        Attribute attribute = new Attribute(nameAttribute);
        this.listAttributeIndexToItems.add(new ArrayList());
        this.getAttributes().add(attribute);
    }

    public short getKlassAt(int k) {
        return this.listAttributeIndexToItems.get(this.indexKlass).get(k);
    }

    public List<Short> getListOfClassValues() {
        return this.listAttributeIndexToItems.get(this.indexKlass);
    }

    Short getItemAtOfAttributeAt(int indexAttribute, int indexValue) {
        return this.listAttributeIndexToItems.get(indexAttribute).get(indexValue);
    }

    public String getStringCorrespondingToItem(short index) {
        return this.mapItemToString.get(index);
    }

    public Map<Short, String> getMapItemToString() {
        return this.mapItemToString;
    }

    int getItemOfKlass(String klass) {
        int i = 0;
        while (i < this.targetClassValues.length) {
            if (klass.equals(this.targetClassValues[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void addKlass(String[] values) {
        this.listAttributeIndexToItems.add(new ArrayList());
        this.indexKlass = this.getAttributes().size();
        int i = 1;
        while (i <= values.length) {
            this.lastGivenID = (short)(this.lastGivenID + 1);
            this.listAttributeIndexToItems.get(this.indexKlass).add(this.lastGivenID);
            i = (short)(i + 1);
        }
        this.targetClassValues = values;
    }

    public long getNumberInstancesPerKlass(Short klass) {
        return this.mapClassToFrequency.getOrDefault(klass, 0L);
    }

    public Map<Short, Long> getMapClassToFrequency() {
        if (this.mapClassToFrequency == null) {
            this.recalculateClassFrequencies();
        }
        return new HashMap<Short, Long>(this.mapClassToFrequency);
    }

    public int getDistinctItemsCount() {
        int total = this.getClassesCount();
        for (Attribute attribute : this.getAttributes()) {
            total += attribute.getValues().length;
        }
        return total;
    }

    public Attribute getAttributeOfItem(Short item) {
        int indexAttribute = -1;
        boolean found = false;
        indexAttribute = 0;
        while (indexAttribute < this.getAttributes().size() && !found) {
            int j = 0;
            while (j < this.listAttributeIndexToItems.get(indexAttribute).size() && !found) {
                if (this.listAttributeIndexToItems.get(indexAttribute).get(j) == item) {
                    found = true;
                }
                ++j;
            }
            ++indexAttribute;
        }
        return this.getAttributes().get(indexAttribute - 1);
    }

    public boolean hasMissingValue() {
        return this.hasMissingValue;
    }

    public Instance stringToInstance(String[] values) throws Exception {
        Instance instance = new Instance(values.length);
        int i = 0;
        while (i < this.getAttributes().size()) {
            Short val = this.getItemRepresentingAttributeValue(i, values[i]);
            instance.set(i, val);
            ++i;
        }
        return instance;
    }

    public void printStats() {
        System.out.println(" Number of attributes : " + this.getAttributes().size());
        System.out.println(" Number of records : " + this.getInstances().size());
        System.out.println(" Class value count: " + this.targetClassValues.length);
        System.out.println(" Class values: " + Arrays.toString(this.targetClassValues));
        int i = 0;
        while (i < this.getAttributes().size()) {
            System.out.println(" Attribute  " + i + ": " + this.getAttributes().get(i));
            ++i;
        }
    }

    public void printInternalRepresentation() {
        System.out.println(" ---- Internal representation of dataset ---- ");
        System.out.println("index class: " + this.indexKlass);
        System.out.println(" -- Attributes -- ");
        for (Attribute attribute : this.getAttributes()) {
            System.out.println(attribute.getName());
        }
        System.out.println(" -- Class --");
        int i = 0;
        while (i < this.getClassesCount()) {
            System.out.println(this.getKlassAt(i));
            ++i;
        }
        System.out.println(" -- Instances -- ");
        i = 0;
        while (i < this.getInstances().size()) {
            System.out.println(this.getInstances().get(i));
            ++i;
        }
    }

    public void printStringRepresentation() {
        System.out.println(" ---- String representation of dataset ---- ");
        System.out.println(" -- Attributes -- ");
        for (Attribute attribute : this.getAttributes()) {
            System.out.println(String.valueOf(attribute.getName()) + " " + Arrays.toString(attribute.getValues()));
        }
        System.out.println(" -- Class --");
        int i = 0;
        while (i < this.getClassesCount()) {
            System.out.println(this.targetClassValues[i]);
            i = (short)(i + 1);
        }
        System.out.println(" -- Instances -- ");
        for (Instance instance : this.getInstances()) {
            StringBuilder buffer = new StringBuilder();
            Short[] shortArray = instance.getItems();
            int n = shortArray.length;
            int n2 = 0;
            while (n2 < n) {
                Short value = shortArray[n2];
                buffer.append(this.getStringCorrespondingToItem(value));
                buffer.append(" ");
                ++n2;
            }
            System.out.println(buffer.toString());
        }
    }

    String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    protected void recalculateClassFrequencies() {
        this.mapClassToFrequency = new HashMap<Short, Long>();
        for (Instance instance : this.instances) {
            Short klass = instance.getKlass();
            Long val = this.mapClassToFrequency.get(klass);
            if (val == null) {
                this.mapClassToFrequency.put(klass, 1L);
                continue;
            }
            this.mapClassToFrequency.put(klass, val + 1L);
        }
    }
}

