/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.data;

import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ARFFDataset
extends Dataset {
    private static final String COMMENTCHAR1 = "%";
    private static final String COMMENTCHAR2 = "#";
    private static final String METACHAR = "@";
    private static final String SEPARATOR = ",";
    private static final String RELATION = "@relation";
    private static final String ATTRIBUTE = "@attribute";
    private String klass = "class";
    private int klassIndexInFile = -1;
    String[] klassValuesInFile = null;

    public ARFFDataset(String path, String className) throws Exception {
        this.klass = className;
        this.klassIndexInFile = -1;
        try (BufferedReader bufferedReader = null;){
            String line;
            FileReader fileReader = new FileReader(path);
            bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || this.isComment(line)) continue;
                if (line.startsWith(METACHAR)) {
                    this.proccessMetadata(line);
                    continue;
                }
                if (this.indexKlass == -1) {
                    if (this.klassValuesInFile == null) {
                        throw new Exception("The target attribute \"" + className + "\" that you have chosen does not exist.");
                    }
                    this.addKlass(this.klassValuesInFile);
                }
                this.proccessData(line);
            }
            bufferedReader.close();
        }
    }

    private void proccessMetadata(String line) {
        if (line.toLowerCase().startsWith(RELATION)) {
            this.setName(line.replace("@relation ", ""));
        } else if (line.toLowerCase().startsWith(ATTRIBUTE)) {
            this.processAttribute(line);
        }
    }

    private void processAttribute(String line) {
        Pattern p = Pattern.compile("@attribute .*\\{(.*)\\}", 2);
        Matcher m = p.matcher(line);
        String[] splitted = line.replaceAll(" +", " ").split(" ");
        String nameAttribute = splitted[1];
        if (m.matches()) {
            Object[] values = m.group(1).replaceAll(" *", "").split(SEPARATOR);
            Arrays.sort(values);
            if (nameAttribute.contains(this.klass)) {
                this.klassIndexInFile = this.listAttributeIndexToItems.size();
                this.klassValuesInFile = values;
            } else {
                this.addNominalAttribute(nameAttribute, (String[])values);
            }
        } else {
            this.addNumericAttribute(nameAttribute);
        }
    }

    private void proccessData(String line) throws Exception {
        String[] lineX = line.split(SEPARATOR);
        String[] reorderedLine = new String[lineX.length];
        int currentPosition = 0;
        int j = 0;
        while (j < lineX.length) {
            if (j != this.klassIndexInFile) {
                reorderedLine[currentPosition++] = lineX[j];
            }
            ++j;
        }
        reorderedLine[reorderedLine.length - 1] = lineX[this.klassIndexInFile];
        this.getItemForAttributeValue(reorderedLine);
    }

    private boolean isComment(String line) {
        return line.startsWith(COMMENTCHAR1) || line.startsWith(COMMENTCHAR2);
    }
}

