/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.cmar;

import ca.pfv.spmf.algorithms.classifiers.general.Rule;
import java.io.Serializable;

public class RuleCMAR
extends Rule
implements Serializable {
    private static final long serialVersionUID = -5417534776500597941L;
    public static double NUMBER_INSTANCES = 0.0;

    public RuleCMAR(short[] antecedent, short klass) {
        super(antecedent, klass);
    }

    @Override
    public void setSupportAntecedent(long supportAntecedent) {
        this.supportAntecedent = supportAntecedent;
    }

    @Override
    public void setSupportRule(long supportRule) {
        this.supportRule = supportRule;
    }

    @Override
    public void setSupportKlass(long supportKlass) {
        this.supportKlass = supportKlass;
    }

    public double getChiSquare() {
        double[] observedValues = new double[4];
        double[] expectedValues = new double[4];
        observedValues[0] = this.supportRule;
        observedValues[1] = this.supportAntecedent - this.supportRule;
        observedValues[2] = this.supportKlass - this.supportRule;
        observedValues[3] = NUMBER_INSTANCES - (double)this.supportAntecedent - (double)this.supportKlass + (double)this.supportRule;
        double supNotAntecedent = NUMBER_INSTANCES - (double)this.supportAntecedent;
        double supNotConsequent = NUMBER_INSTANCES - (double)this.supportKlass;
        expectedValues[0] = (double)(this.supportKlass * this.supportAntecedent) / NUMBER_INSTANCES;
        expectedValues[1] = supNotConsequent * (double)this.supportAntecedent / NUMBER_INSTANCES;
        expectedValues[2] = (double)this.supportKlass * supNotAntecedent / NUMBER_INSTANCES;
        expectedValues[3] = supNotConsequent * supNotAntecedent / NUMBER_INSTANCES;
        double sumChiSquaredValues = 0.0;
        int index = 0;
        while (index < observedValues.length) {
            double chiValue = Math.pow(observedValues[index] - expectedValues[index], 2.0) / expectedValues[index];
            sumChiSquaredValues += chiValue;
            ++index;
        }
        return sumChiSquaredValues;
    }

    public boolean isMoreGeneral(RuleCMAR rule) {
        return this.antecedent.size() < rule.antecedent.size();
    }

    public boolean isGreater(RuleCMAR other) {
        if (this.getConfidence() > other.getConfidence()) {
            return true;
        }
        if (Double.compare(this.getConfidence(), other.getConfidence()) == 0) {
            if (this.getSupportRule() > other.getSupportRule()) {
                return true;
            }
            if (Double.compare(this.getSupportRule(), other.getSupportRule()) == 0 && this.getAntecedent().size() < other.getAntecedent().size()) {
                return true;
            }
        }
        return false;
    }

    public double getChiSquareUpperBound() {
        double term = this.supportAntecedent < this.supportKlass ? Math.pow((double)this.supportAntecedent - (double)(this.supportAntecedent * this.supportKlass) / NUMBER_INSTANCES, 2.0) : Math.pow((double)this.supportKlass - (double)(this.supportAntecedent * this.supportKlass) / NUMBER_INSTANCES, 2.0);
        double eVlaue = this.calculateChiSquare();
        return term * eVlaue * NUMBER_INSTANCES;
    }

    private double calculateChiSquare() {
        double term1 = 1.0 / (double)(this.supportAntecedent * this.supportKlass);
        double term2 = 1.0 / ((double)this.supportAntecedent * (NUMBER_INSTANCES - (double)this.supportKlass));
        double term3 = 1.0 / ((double)this.supportKlass * (NUMBER_INSTANCES - (double)this.supportAntecedent));
        double term4 = 1.0 / ((NUMBER_INSTANCES - (double)this.supportAntecedent) * (NUMBER_INSTANCES - (double)this.supportKlass));
        return term1 + term2 + term3 + term4;
    }

    @Override
    public String getMeasuresToString() {
        return " #SUP: " + this.getSupportRule() + " #CONF: " + this.getConfidence() + " #CHISQUARE: " + this.getChiSquare();
    }
}

